        ****************************************************************
                (C) Copyright Johnson Controls, Inc. 1995 - 2005
          Use or copying of all or any part of the document, except as
                permitted by the License Agreement, is prohibited.
        ****************************************************************

================================================================================
                      Welcome to HVAC PRO (TM) Release 8.08
                           Updated:  March 18, 2005
================================================================================

This document contains notes on the following:
  HVAC PRO Basics
    - Installing HVAC PRO
    - Running HVAC PRO
    - Running HVAC PRO on a Metasys OWS
    - Running HVAC PRO in Pass Through Mode From Project Builder
    - Controller Access - Direct Connection
    - Controller Access - Auxiliary Access
  HVAC PRO Features: New and Improved at Release 8.0x
    - Updated Online help
    - N30 Pass Through Support
    - VMA Dual Duct Application
    - C00 Firmware for the VMA
    - TMZ Support for the VMA
    - Support for new AS-UNT1108-0, AS-UNT1126-0 and AS-UNT1144-0
    - Diagnostic data points added to UNT apps
    - Fan status input added to Unit Vent app
  Problem Fixes in Release 8.07
    - Improvement with NAE field controller name handling 
    - Improvement with downloading controllers
    - Improvement with VAV Box Flow test using NCM n2 passthrough
 Problem Fixes in Release 8.06
    - Improvement with the passthru feature. 
    - The use of short names when dealing with VMA's damper SMO and heating PAO's.
    - Improvement in downloading VMA's.
    - Fixed isuess with the Pressure Dependent mode.
    - Support of Windows XP.
  Problem Fixes in Release 8.01
    - Metasys dialup OWS timeout
    - VAV box flow test
    - N30 passthru unstable
    - N30 passthru missing devices
    - VMA download via Metasys OWS passthru
    - Unit Vent Skip DALL problem
    - Rooftop fan cycling problem
    - Lock up when trying to override AI and AO points
  Problem Fixes in Release 8.00
    - Interaction Between M3 Apps and HVAC PRO
    - HVAC PRO Locks Up on NT when Using Aux. Access
    - VMA Download Retry Causes HVAC PRO to Crash
  HVAC PRO Features: New and Improved at Release 7.0x
    - Support for Windows 98 and Windows NT
    - Support for TMx1600 LCD Room Sensor
    - Variable Air Volume Modular Assembly - VMA1400 Series Support
    - Software Addressing for VMA1400 Series
    - Download Controller - VMA1400 Series Code Download
    - Upgrade Controller - Option for VMA1400 Series Code Download
    - VAV Box Flow Test
    - Collect VAV Diagnostics
    - VMA Balancer Tool
    - VMA Application Views
    - File Save As - Additional Target Devices
    - Commissioning - Automated Exit Feature
    - Data Graphing - Improved Interface
    - Upgrade Controllers - VMA Code Download and VAV Tuning Parameters
    - Job Information History - Ability to Delete Entries
    - Unit Vent Applications - User Selectable Options
    - TC Fan Coil Applications
    - VMA Single Duct Application
    - AHU Applications - Incremental Valve Support Added
    - Commercial Zoning Applications
  Problem Fixes in Release 7.03
    - VMA Application - Incorrect Metric Defaults for the Remote Setpoint Option
    - VMA Application - Incorrect Operation when in Pressure Dependent Mode
    - VMA Application - Non-Default AOs and User-defined BOs are Incorrectly Upgraded
    - VMA Application - BIs and BOs are Offline to Metasys
    - VAV Application - Second (Nuisance) Occ Htg Setpoint is Created
    - Commercial Zoning Application - Allowable Limits for Metric AIs are Incorrect
    - HVAC PRO - Incompatible with Multiple Networks Defined in Metasys Release 9.01
    - HVAC PRO - Unable to Edit Interstage Delays for BOs
    - HVAC PRO - Corrupted Links when Changing BO Type to Momentary
    - HVAC PRO - Incorrect DDL is Generated for VMA Applications Using EHS
  Problem Fixes in Release 7.02
    - VMA Application - Constant Volume VAVs
    - VMA Application - Attribute Mapping
    - Terminal Unit Application - Two Pipe Common Htg/Clg Coil
    - Commercial Zoning Application - Non-priority Mode
    - Commercial Zoning Application - Default Zone Unresponse Time
    - Sideloop Application - Condition Single BO
    - HVAC PRO - VMA File Upgrades
    - HVAC PRO - VMA Download Failures
    - HVAC PRO - Vendor Device Unknown
    - HVAC PRO - Sideloop Deletion
    - HVAC PRO - Download Via Ethernet
  Problem Fixes in Release 7.01
    - Incremental Outputs - Actuators with Different Stroke Times
                            in Each Direction
    - Incremental Outputs - Output Command Stops Near Zero or One Hundred
    - VMA Application - Autocal Now Runs when Autocal Period is Changed
    - VMA Application - Units Attributes Added
    - VMA Application - Flow Controller Now Properly Setup for CU Meters/Hr
    - OEM Application - McQuay Global Chiller Modified to Improve Startup
    - HVAC PRO - VMA Box Balancing
    - HVAC PRO - VMA Download Error
    - HVAC PRO - Configuration Process Aborted
    - HVAC PRO - Cannot Initialize Commissioning Mode
  Problem fixes in Release 7.00
    - File Save As - Unreferenced Sideloop Parameter
    - AHU Application - Cooling Windup for 100% OA Units
  Miscellaneous Information and Interactions
    - Template Files
    - WARNING! TC-9100 CONTROLLER DOWNLOADS VIA METASYS
    - Commissioning DX-9100/9120 Controllers
    - HW Analog Input Sensor Type
    - ASCs:  Analog Input Ranging for Pressure Sensors
    - Data Graphing - General Protection Fault
    - Communication Errors Due to Converter



        ****************************************************************
                                HVAC PRO Basics
        ****************************************************************

Installing HVAC PRO
================================================================================
Installation requires Windows 2000 or Windows XP.
The HVAC PRO software is installed as a part of Configuration Tools. 
Follow the installation instructions provided in the Configuration Tools Readme 
file, README.CTN.  No special provisions must be taken for installing HVAC PRO on
a Metasys Operator Workstation (OWS) or N30 Workstation.

It is not necessary to keep copies of older versions of HVAC PRO.  HVAC PRO is
capable of reading and saving older applications.  However, if you still wish to
keep more than one version on the same PC, you need to change the default
installation paths and group name during installation.  Be AWARE however, that
there is only one hvacpro.ini file in the windows directory that contains the
locations of HVAC PRO files.  In order to use multiple versions, you will need
to edit the hvacpro.ini file each time a different version is used.  Change the
entries for 'DATA=' (location of the executable) and 'FILES=' (location for file
storage) to point to the correct directories for the version being used.


Running HVAC PRO
================================================================================
The main HVAC PRO screen consists of a Menu Bar, List Boxes (which display 
information), and Display Buttons (which control what is displayed).  From the 
main menu, the user selects the tasks from the Configuration, Download, 
Upload, Commission, and Action menus.

Configuration mode is the default mode of HVAC PRO and is used for creating and
modifying configuration files.  From the File menu, you can create a NEW con-
figuration or OPEN an existing configuration.  After creating or modifying the
configuration, you will need to perform a SAVE or SAVE AS.  NOTE:  Use the
Options menu to set options for generating the CS Model DDL and print (PRN)
files during the File Save process.  Questions during the creation process can
be answered by double clicking the answer.

After saving a configuration, the typical next step is to DOWNLOAD the con-
figuration.  You must have a saved configuration displayed to enable this
selection.  HVAC PRO will prompt you for the PC's communications port and the
address(es) to download to. To specify multiple addresses, use the following
formats:
   - Specify an address series by listing the first and last
     addresses in the series separated by two dots
   - Separate individual addresses or address series by commas
   Example:  1,3,7..22,28,32..37,42

Use the VMA Code command in the Download menu to download the firmware code to a
VMA controller.  Note that downloading VMA firmware code will delete any exist-
ing control application in the VMA.  If you wish to update the controller
firmware AND retain the current control application, use the Upgrade Controller
feature (see below).

Uploading provides a means of obtaining the configuration in the controller
without the associated configuration file.  Use the Configuration in Controller
command in the Upload menu to upload a controller.  HVAC PRO will prompt you for
the PC's communications port and the address to upload from.  HVAC PRO cannot
upload DX-9100 controllers (use GX9100).

Use the Upgrade Controller command in the Upload menu to upgrade a controller to
the current HVAC PRO revision.  The controller upgrade feature includes an
option to download the VMA firmware code as part of the upgrade process.  This
allows you to update the VMA firmware and control application in the same
process.

Commission mode is used to monitor or modify an existing controller application.
Select CURRENT CONFIGURATION to enter commissioning for the current configura-
tion or CONFIGURATION IN CONTROLLER to enter commissioning for the configuration
in the controller.  Once in Commissioning mode, you may view, override, and
adjust commandable items.  Modify the desired points by double-clicking on them.

HVAC PRO's Controller Information feature logs and/or displays information about
single or multiple controllers.  Select the Controller Information command from
Action menu to access this feature.


Running HVAC PRO on a Metasys OWS
================================================================================
HVAC PRO operates in a Pass Through mode on an OWS.  As long as the Metasys PMI
is operating when you start HVAC PRO, the software automatically detects the
Metasys PMI and replaces all of the communication option screens with lists of
NCMs and systems/objects defined on the active Metasys Network.  Metasys Release
6.00 or greater is required.

Most HVAC PRO features are available when running HVAC PRO from the OWS on a
Metasys Network.  You can obtain controller information, upload, download, com-
mission, tune, and upgrade controllers.  It is recommended that PI Loop Tuning
NOT be performed in Pass Through mode on an OWS, because the precise
timing required for good results is affected by network traffic.  Features
not available when running HVAC PRO on a Metasys OWS include VMA code download
and VMA Balancer Tool (VBT).


Running HVAC PRO in Pass Through Mode From Project Builder
================================================================================
HVAC PRO operates in a Pass Through mode from Project Builder.  From the Tools
menu of Project Builder, select N2 Controller Editors > HVACPRO Through N30.

Most HVAC PRO features are available when running HVAC PRO from Project Builder
on an N30 network.  You can obtain controller information, upload, download,
commission, tune, and upgrade controllers.  It is recommended that PI Loop Tuning
NOT be performed in Pass Through mode on an OWS, because the precise timing 
required for good results is affected by network traffic.  Features not 
available when running HVAC PRO in Pass Through mode include VMA code down-
load and VMA Balancer Tool (VBT).


Controller Access - Direct Connection
================================================================================
On Windows 3.1x, Windows 95, Windows 98, and Windows NT, direct N2 and RS485
Zone Bus communications are supported.  This requires the use of either a
MM-CVT101 converter, an IU-9100 converter, or a B&B Electronics converter (P/N
485TBLED) with modifications.  See the product update literature on the Advisor
for details (Product Update 98-05).  Note:  Windows NT is only supported with
the use of the IU-9100 converter or the modified B&B Electronics converter.

On Windows 3.1x, Windows 95, and Windows 98 platforms, non-RS485 Zone Bus com-
munication is supported through the use of an AS-CBLPRO converter.  This
communication occurs at 1200 baud.

On Windows 3.1x, Windows 95, and Windows 98 platforms, communication with the
DX-9100 or DX-9120 controllers is supported through an RS232-C port using a null
modem cable.


Controller Access - Auxiliary Access
================================================================================
Auxiliary Access is used to access the N2 Bus indirectly via modem or a cable
connection (null modem cable) to an N2 Dialer Module (NDM), or Companion/Fac-
ilitator PC or Panel.



        ****************************************************************
              HVAC PRO Features: New and Improved at Release 8.0x
        ****************************************************************

Updated Online Help
================================================================================
The online help for HVAC PRO has been upgraded to take advantage of Microsoft
Help version 4.10.1998.


N30 Pass Through Support
================================================================================
The HVAC PRO software has been modified in order to allow HVAC PRO to com-
municate with devices located on N30 controller networks.


VMA Dual Duct Application
================================================================================
The VMA dual duct application has been added to the VAV Application group.


C00 Firmware for the VMA
================================================================================
With HVAC PRO Release 8.00, the VMA firmware has been upgraded to C00.  This
firmware includes the fix for falsely sensed stall conditions for the integrated
actuator.


TMZ Support for the VMA
================================================================================
The TMZ digital room sensor is now supported with the VMA1400 series con-
trollers.  In order to utilize this feature, you must have VMA firmware revision 
B15 or greater and HVAC PRO Release 8.00 or later.


Support for new AS-UNT1108-0, AS-UNT1126-0 and AS-UNT1144-0
================================================================================
Three new UNTs are now supported with more memory, relay BOs, a faster processor,
and support for modular communications.


Diagnostic data points added to UNT apps
================================================================================
Controller run time and moving avg zone temp error were added to Unit Vent, 
Rooftop, Heatpump, and Fan Coil apps for the UNT.


Fan status input added to Unit Vent app
================================================================================
A fan status BI is now supported by the Unit Vent app

 
        ****************************************************************
                         Problem Fixes in Release 8.07
                         
Improvement with NAE field controller name handling 
=================================================================================
ZSWHPRO.exe would be terminated by Windows if the controller name was greater than 38
characters.  HVAC PRO now supports up to 157 characters allowing at least 20 for the 
domain name.  
Be aware that SCT 1.2 or later is required to take full advantage of this fix.

                         
Improvement with downloading controllers
=================================================================================
Sometimes ZSWHPRO.exe would be terminated by Windows while downloading any type of
controller.  

Improvement with VAV Box Flow test using NCM n2 passthrough
=================================================================================
HVAC PRO application crashes during VAV Box Flow test if one of the VAVs selected
is offline.




        ****************************************************************
                         Problem Fixes in Release 8.06
        ****************************************************************

Improvement with the Pass Thru Feature.
================================================================================
Several problems occur when using HVAC Pro version 8.05 to commission devices
in pass thru mode. All supervisory controller types are affected. Field  
devices may report OFFLINE or may not respond with data when selected for  
commissioning.

The use of short names when dealing with VMA's damper SMO and heating PAO's.
================================================================================
In HVACpro 8.05 the VMA's damper SMO and heating PAO's have a blank short     
name. If you click OK you get error message "Short name is blank or contains  
invalid characters", and you can't save it. Long name is ok. Upload of 
configuration from VMA shows these short names as blank also, even if VMA     
downloaded with HVACpro 8.04b. Short names blank in commissioning mode also.

Improvement in downloading VMA's.
================================================================================
*Owshpro at release 12.03 causes a General Protection Fault when downloading
a VMA controller. The failure occurs when the download is 95% complete.

Fixed isuess with the Pressure Dependent mode.
================================================================================
Once VMA1430 goes into Pressure Dependent mode because of unreliable dp       
sensor it will not switch back to press ind. mode. The user sets the max dp   
damper command to 30% which forces the ai into the reliable range yet it does 
not control to cfm setpoint.  It stays at 30%. 




        ****************************************************************
                         Problem Fixes in Release 8.01
        ****************************************************************



Metasys dialup OWS timeout
================================================================================
There was a timeout problem retrieving a very long device lists in passthru with 
dialup OWS.  This would sometimes cause the message "NC has no supported devices" 
to be displayed erroneously. This has been corrected.


VAV box flow test
================================================================================
There was a problem with the VAV flow test on VAV controllers with incremental 
actuators which sometimes caused erroneous starved-box indications.  This has 
been corrected.


N30 passthru unstable
================================================================================
There was a pronblem with N30 passthru which resulted in unpredictable behavior 
(system lockups, etc). This has been corrected.


N30 passthru missing devices
================================================================================
There was a case sensitivity problem which sometimes caused controllers not to 
show up in a supervisory controller's device list. This has been corrected.


VMA download via Metasys OWS passthru
================================================================================
VMA downloads via Metasys would sometimes fail and cause DDE server to hang.
This has been corrected.


Unit Vent Skip DALL problem
================================================================================
The Skip DALL function of the Unit Vent application did not work correctly for 
cycles I and W. This has been corrected.


Rooftop fan cycling problem
================================================================================
The fan was cycling incorrectly in certain Rooftop applications. This has been 
corrected.


Lock up when trying to override AI and AO points
================================================================================
HVACPRO would sometimes hang when trying to override AI or AO points. This has 
been corrected.



        ****************************************************************
                         Problem Fixes in Release 8.00
        ****************************************************************

Interaction Between M5 Apps and HVAC PRO
================================================================================
On PCs executing M5 applications, HVAC PRO would cause the PC to lock up until
the offending M5 application was shut down.  This has been corrected.


HVAC PRO Locks Up on NT when Using Aux. Access
================================================================================
On PCs running NT, attempting to use HVAC PRO through the auxiliary access task
would cause the PC to lock up.  This has been corrected.


VMA Download Retry Causes HVAC PRO to Crash
================================================================================
If for any reason the VMA download would fail, clicking the RETRY button would
cause HVAC PRO to crash.  This has been corrected.



        ****************************************************************
              HVAC PRO Features: New and Improved at Release 7.0x
        ****************************************************************

Support for Windows 98 and Windows NT
================================================================================
Beginning with Release 7.03, HVAC PRO supports Windows 98 and Windows NT.  See
the information presented under Controller Access - Direct Connection (above).


Support for TMx1600 LCD Room Sensor
================================================================================
HVAC PRO supports the TMx1600 LCD room sensor.  The TMZ1600 is supported by VAV
and UNT controllers with revision D00 or newer firmware downloaded with HVAC PRO
Release 7.02 or later.  The TMS1600 is supported by TC-9102 controllers down-
loaded with HVAC PRO Release 7.02 or later.  HVAC PRO places information in the
controller so the TMx1600 can communicate with the Zone Temperature and Zone
Setpoints.  If the application chosen is not supported by the TMx1600, this
information is not placed into the controller and the TMx1600 will display an
error.

  Current applications supported by the TMZ1600 include:
    *SSP, Mixed Air Single Path - Supply Air Reset from Zone Temperature
     SSP, Commercial Zoning Applications - Damper Assembly (VAV)
     SSP, OEM Applications - Lennox VAV Zone Boxes
   **DSP, Rooftop Applications - Packaged Rooftop
     DSP, Terminal Unit Applications - Unit Vent
     DSP, Terminal Unit Applications - Fan Coil
     DSP, Terminal Unit Applications - Heat Pump
     DSP, OEM Applications - Water Furnace
     DSP, OEM Applications - York Rooftop
     DSP, OEM Applications - Lennox TCB19
  ***S&DSP, Mixed Air Single Path - Room Control
     S&DSP, Mixed Air Single Path - Room Control Cooling/Room Reset Heating
     S&DSP, 100% OA Single Path - Room Control
     S&DSP, 100% OA Single Path - Room Control Cooling/Room Reset Heating
     S&DSP, 100% OA Single Path - Supply Air Reset from Zone Temperature
     S&DSP, VAV Applications - Single Duct
     S&DSP, VAV Applications - Dual Duct

  Current applications supported by the TMS1600 include:
     DSP, Terminal Unit Applications - TC Fan Coil

  *SSP   = Single Setpoint Only
 **DSP   = Dual Setpoint Only
***S&DSP = Single and Dual Setpoint


Variable Air Volume Modular Assembly - VMA1400 Series Support
================================================================================
HVAC PRO supports the VMA device for pressure-independent control of a single
VAV box. VMA devices include an integrated DP sensor (VMA1410 and VMA1420 also
include a stepper motor actuator).  The VMA is supported for most standard HVAC
PRO features (upload, download, commissioning, etc.).  You can also include the
VMA for VAV box flow tests and collecting VAV diagnostics.


Software Addressing for VMA1400 Series
================================================================================
Beginning with HVAC PRO Release 7.02, VMAs with revision B12 firmware (or later)
support software addressing when the address dip switches are set to 0 or
255.  The software address can be set through either the Controller Information 
command or through the VBT via the Zone Bus.


Download Controller - VMA1400 Series Code Download
================================================================================
The VMA Code command in the Download menu downloads updated firmware code to a
VMA device.  You must use an N2 connection to download firmware code to a VMA
device - the Zone Bus does not support this feature.

Note that downloading firmware code to a VMA device deletes the current control
application.  Use the Upgrade Controller feature (see below) to update the
controller firmware and retain the current control application.


Upgrade Controller - Option for VMA1400 Series Code Download
================================================================================
The Controller Upgrade feature includes an option to download the VMA firmware
code as part of the upgrade process.  This allows you to update the firmware and
control application in the same process.  Since firmware code downloads require
N2 communication, the Zone Bus option is not available when you choose to per-
form the code download during an upgrade process.


VAV Box Flow Test
================================================================================
The VAV Box Flow Test feature, located in the Action menu, tests the operation
of Single Duct, Pressure Independent VAV Boxes controlled by a VMA or VAV con-
troller.  HVAC PRO commands each VAV box damper to a series of positions based
on a starting command and specified step amount.  At each damper position, the
test takes an airflow reading after the actuator has positioned the damper and
the airflow has become stable (based on stroke time and settle time).  Once the
test is complete, the airflow readings are used to determine the flow character-
istics of the VAV box and to check its operation.


Collect VAV Diagnostics
================================================================================
You can collect VAV diagnostic values from all VMA devices on the N2 Bus using
the Collect VAV Diagnostics command (Action menu).  This feature retrieves and
stores the values for the actuator run time, moving average flow error, and
moving average zone temperature errors, along with several other values.  The
data is saved in a file, VAVDIAG.LOG, in a tab-delimited format suitable for
importing into a spreadsheet.  Note that you must use an N2 connection to
collect VAV diagnostics from a VMA device.  The Zone Bus connection is not
supported for this feature.


VMA Balancer Tool
================================================================================
A balancer tool is available for VMA devices. The VMA Balancer Tool (VBT), 
located in the Action menu, automatically calculates the correct pickup gain for 
a VAV box controlled by a VMA device.  The calculations for the minimum, maximum, 
or average pickup gain are based on actual, operator-entered flow readings.


VMA Application Views
================================================================================
The View selection in the Options menu was added to give you control over the
number of points displayed in the Parameters list box for the VMA application.
This menu item is only available when a VMA application is displayed.


File Save As - Additional Target Devices
================================================================================
The following target devices are part of the HVAC PRO database:
   UNT240-1 (8K Unitary Controller)
     Six AIs, four BIs (24 VAC), eight BOs (High/Low Side
     Selectable). N2 Isolation, Low Temp/High %RH Use.
     OEM Label (YORK), Special Factory Download. ZB LED,
     Removable PWR Terms.

   UNT113-1 (8K Unitary Controller)
     Six AIs, four BIs (24 VAC), two AOs, six BOs (with separate
     triac "BO" and "Return" terminals to accommodate multiple
     load transformers). N2 Isolation. ZB LED, Removable PWR Terms.

   VMA1410  (Variable Air Volume Modular Assembly)
     Two external AIs plus integrated DP sensor at AI-5, three BIs,
     Occupancy Indicator LED at BO-6, integrated stepper motor
     actuator.

   VMA1420  (Variable Air Volume Modular Assembly)
     Four external AIs plus integrated DP sensor at AI-5, three BIs,
     two AOs, five external BOs plus Occupancy indicator LED at BO-6,
     integrated stepper motor actuator.

   VMA1430  (Variable Air Volume Modular Assembly)
     Four external AIs plus integrated DP sensor at AI-5, three BIs,
     two AOs, five external BOs plus Occupancy indicator LED at BO-6.


Commissioning - Automated Exit Feature
================================================================================
The Exit Commissioning dialog box automatically appears if you close HVAC PRO
during Commissioning mode using any of the following methods: File-Exit, Close
button on title bar, Alt-F4, or Close command from Control menu.


Data Graphing - Improved Interface
================================================================================
We have updated and improved the interface for selecting points to graph using
the Data Graphing command in the Commission menu.


Upgrade Controllers - VMA Code Download and VAV Tuning Parameters
================================================================================
In addition to the Code Download option added for VMA devices (described above
in the Upgrade Controller - Option for VMA1400 Series Code Download section), 
we have added an option to update the VAV tuning parameters (Prop Band, 
Integral Time, and Deadband).  In HVAC PRO Release 6.05 and earlier, the upgrade 
feature automatically recalculated and updated the VAV tuning parameters in 
applicable configurations.  You can now deselect this option if you wish to 
retain the current controller values for the VAV tuning parameters (only applies 
to VAV controllers).  This option is ignored for upgrades of VAV controllers
loaded with a DOS version of HVAC PRO.


Job Information History - Ability to Delete Entries
================================================================================
You can delete existing Job Information History entries with HVAC PRO Release 7.00 
or later.  Select Job Information from the Options Menu, then for each existing
history entry you wish to delete, highlight the entry and select the Remove
button.


Unit Vent Applications - User Selectable Options
================================================================================
You may select a shutdown position for the Heating Valve (two-position or pro-
portional) in Unit Vent applications.  Requires HVAC PRO Release 7.00 or later.

When selecting Unoccupied override of the heating valve, the user may select
from a fixed position of full open or a minimum position where the room control
can open the valve further if zone temperature continues to drop.


TC Fan Coil Applications
================================================================================
HVAC PRO Release 6.00 and later supports the full line of TC-9100 controllers. 
This fixed function controller handles small fan coil units that require
networking.  HVAC PRO will allow you to select the heating and cooling output
types, setpoint type and fan type.  Note that there are restrictions regarding
TC-9100 downloads via a Metasys OWS.  Details are available in the Miscellaneous
Information and Interactions section below.

The following features are now supported for TC-9100 fan coil applications
(requires HVAC PRO Release 6.03 or later):
    - Heating/Cooling Interlocked with Fan
      For Three-Speed Fan applications, you may now select an option to
      interlock the heating and/or cooling with the fan output. Note - this
      feature is DISABLED in TC-9100 controllers with firmware earlier than 
      revision 3.0.

    - Configurable Limits for Winter/Summer Compensation
      Compensation limits can now be configured for all TC-9100 controllers with
      firmware revision 3.0 or later (does not apply to earlier firmware
      revisions).


VMA Single Duct Application
================================================================================
The VMA Single Duct application is new at Release 7.00.  This application
provides for pressure-independent control of a single VAV box, using advanced
algorithms for improved control.  The VMA Single Duct application includes
Pattern Recognition Adaptive Control (PRAC) within the controller to provide
continuous tuning of the Zone temperature control loop(s).  Flow control uses a
new P-Adaptive control algorithm that requires no tuning - simply define the box
area and box constant (pickup gain).  P-Adaptive provides a fast response to
minimize the time required to balance and commission the VAV box.  The VMA
Single Duct application may only be targeted for a VMA device.

Starting with Release 7.02, the VMA application now supports an external
floating/3-wire or proportional actuator for the flow control loop.  AI-2 and
AI-3 also support user-defined ranges.  These allow user-defined scaling of
these inputs.


AHU Applications - Incremental Valve Support Added
================================================================================
Incremental (position adjust output) choices have added to the heating and
cooling output type choices.


Commercial Zoning Applications
================================================================================
Commercial zoning applications are new at Release 7.02.



        ****************************************************************
                         Problem fixes in Release 7.03
        ****************************************************************

VMA Application - Incorrect Metric Defaults for the Remote Setpoint Option
================================================================================
In HVAC PRO Release 7.02, an incorrect Metric limit is used for the Remote 
Setpoint (AI2) option in VMA applications.  The Metric Output_Range_High 
parameter is incorrectly defaulted to 18, and should be 28.  Upgrading the 
controllers will not correct the problem.  Enter the correct Output_Range_High 
manually, or rebuild the application using HVAC PRO Release 7.03.  Note that this 
is only a problem with new VMA applications built using HVAC PRO Release 7.02.


VMA Application - Incorrect Operation when in Pressure Dependent Mode
================================================================================
For VMA applications generated with HVAC PRO Release 7.02, when the Supply 
Delta P (DP) becomes unreliable, the VMA will stop commanding the damper.  This 
has been corrected in HVAC PRO Release 7.03.  In this release, should the DP 
sensor become unreliable, the application will enter the Pressure Dependent mode 
and command the damper as a percent of full open.  Performing an upgrade of the 
affected controllers will correct this problem.


VMA Application - Non-Default AOs and User-defined BOs are Incorrectly Upgraded
================================================================================
When using HVAC PRO Release 7.02 or earlier to upgrade VMA applications, the 
non-default AOs and user-defined BOs will be incorrectly upgraded.  From the 
HVAC PRO commissioning window, the device will erroneously appear to be operating 
correctly. This problem has been corrected in HVAC PRO Release 7.03.  In other 
words, HVAC PRO Release 7.03 will correctly upgrade VMA applications using 
non-default AOs or user-defined BOs.  If HVAC PRO Release 7.02 has already been 
used to upgrade an application containing non-default AOs or user-defined BOs, 
the only way to correct this situation is to rebuild the application from scratch.  
Note that this is not a problem when the applications use only default AOs and 
do not contain any user-defined BOs.


VMA Application - BIs and BOs are Offline to Metasys
================================================================================
VMA BIs and BOs are offline to Metasys Release 10.00 or earlier after commis-
sioning with HVAC PRO.  This is not an HVAC PRO problem, but is a Metasys OWS
problem.  The BIs and BOs which are online to Metasys prior to commissioning go
offline during commissioning, but never return to online after commissioning is
completed.  Overriding and releasing the points from Metasys will return the
points to the online status.  A future release of Metasys should correct this
problem.


VAV Application - Second (Nuisance) Occ Htg Setpoint is Created
================================================================================
Certain VAV applications created with HVAC PRO Release 7.02 will create a second
Occ_Htg_Setpoint in the parameters window.  This second setpoint is a nuisance 
and can be ignored.  Upgrading the affected controllers with HVAC PRO Release 7.03 
will correct the problem.  Note that the application revision does not change.


Commercial Zoning Application - Allowable Limits for Metric AIs are Incorrect
================================================================================
The metric limits for Commercial Zoning Applications built using HVAC PRO 
Release 7.02 are incorrectly set to zero.  This is only a problem when using 
metric units. This has been corrected in HVAC PRO Release 7.03.  Upgrading the 
controllers will not correct the problem.  Either these applications must be 
rebuilt (not upgraded) using HVAC PRO Release 7.03 or the limits must be manually 
adjusted and the application downloaded.


HVAC PRO - Incompatible with Multiple Networks Defined in Metasys Release 9.01
================================================================================
HVAC PRO Release 7.02 will only work with the first network defined in a Metasys 
Release 9.01 multiple network system.  The typical symptom is the report of a 
check sum error when communication is attempted.  This has been corrected in 
HVAC PRO Release 7.03.  This release of HVAC PRO has been adjusted to be compatible 
with multiple networks on either Metasys Release 9.01 or Release 10.00 systems.


HVAC PRO - Unable to Edit Interstage Delays for BOs
================================================================================
When using HVAC PRO Release 7.02 for Application Specific Controllers (ASCs), the
interstage delays between BOs are not available for editing.  When you open a
previously saved file with interstages, the interstage delay box is not shown
when the BO is edited.  If the configuration was saved with these missing inter-
stage delays, the interstage links have been corrupted.  This problem has been
corrected in HVAC PRO Release 7.03.

Open the configuration file with HVAC PRO Release 7.03 to show whether the 
interstage links have been corrupted.  If the interstage delays are not 
available for editing, the interstages have been corrupted and will need to be 
rebuilt using HVAC PRO Release 7.03.


HVAC PRO - Corrupted Links when Changing BO Type to Momentary
================================================================================
When using HVAC PRO Release 7.02, the Pulse Type of the user-defined BO is 
available for editing on the second momentary BO.  This is incorrect.  If the 
configuration was saved (using HVAC PRO Release 7.02) with an adjustable Pulse 
Type for the second momentary BO, the association with the first BO has been 
corrupted.  This problem has been corrected in HVAC PRO Release 7.03.

To verify and correct the problem, open the configuration file with HVAC PRO 
Release 7.03 to see whether the second momentary BO has an adjustable Pulse Type.  
If it is not adjustable, no correction is required.  If however, the second BO 
Pulse Type is adjustable, delete the second BO, change the first momentary BO 
Pulse Type to Maintained, and select OK.  Then edit this BO again, change it 
back to a Momentary Pulse Type, and select OK.  This action will create the 
corrected momentary BO which will not have an adjustable Pulse Type.


HVAC PRO - Incorrect DDL is Generated for VMA Applications using EHS
================================================================================
HVAC PRO Release 7.02 or earlier generates incorrect DDL code for VMA 
applications using Electric Heating Stage (EHS) outputs.  This does not present 
a problem for the operation of the VMA, but will result in incomplete information 
for point mappings.  This has been corrected in HVAC PRO Release 7.03.  To 
generate the correct DDL files, open the configuration using HVAC PRO Release 7.03,
making sure the Generate DDL box is checked, and save the application.



        ****************************************************************
                         Problem Fixes in Release 7.02
        ****************************************************************

VMA Application - Constant Volume VAVs
================================================================================
The VMA will no longer wind up the cooling integration if the cooling max and
min are the same.  This will prevent long delays before switching to a Heating
mode.


VMA Application - Attribute Mapping
================================================================================
The ADF of several attributes has been changed to allow overrides from Metasys:

    Attribute Name                  Old ADF      New ADF
    Sideloop PID.Setpoint             57           199
    Cooling PID.Present Value         27            70
    Box Heating PID.Present Value     28            72
    Suppl Heating PID.Present Value   29            73

    Note: Any CS Models or direct mapped AIs or AOs will need to be updated.


Terminal Unit Application - Two Pipe Common Htg/Clg Coil
================================================================================
Heating PI will not wind up when in Summer mode and Cooling PI will not wind up
when in Winter mode.


Commercial Zoning Application - Non-priority Mode
================================================================================
Non-priority mode can now activate during unoccupied or intermittent fan
operation.


Commercial Zoning Application - Default Zone Unresponse Time
================================================================================
The default Zone Unresponse Time has been changed from 1 hour to 4 hours.


Sideloop Application - Condition Single BO
================================================================================
The default value of BO On/Off Command can now be selected by the user.  If the
user wants to change the default for an existing application, they must perform
an upload from the controller first.


HVAC PRO - VMA File Upgrades
================================================================================
HVAC PRO will now properly upgrade a VMA configuration file created at Release
7.00.


HVAC PRO - VMA Download Failures
================================================================================
HVAC PRO now waits for archive completion for application downloads.  This
provides a better indication of a completed download.


HVAC PRO - Vendor Device Unknown
================================================================================
Vendor devices no longer show up as unknown devices on controller information.


HVAC PRO - Sideloop Deletion
================================================================================
When a configuration file is opened with Windows Explorer or AIM Project File
Manager, sideloops are no longer deleted.


HVAC PRO - Download Via Ethernet
================================================================================
A parameter was added to HVACPRO.INI to provide additional communication time
over an ethernet.  If you have problems with downloads over ethernet, add the
following to your HVACPRO.INI file:

    ExtraCommTiming=5

This provides an extra 5 seconds for communication timeouts.  The default is
zero seconds.  Adjust the value as necessary to achieve error free downloads.




        ****************************************************************
                         Problem Fixes in Release 7.01
        ****************************************************************

Incremental Outputs - Actuators with Different Stroke Times in Each Direction
================================================================================
All applications that support incremental actuators now allow the UNT or VAV to
synchronize the actuator position when the controller thinks the output has been
at zero or one hundred for twenty minutes.  At that time it will drive the
output in the appropriate direction for one and a half times the stroke time.  
If the command remains at zero or one hundred for another twenty minutes, the
controller will resynch again.  After two resynchs, the controller will not
attempt to resynch again until the position it thinks the output is in is not
zero or one hundred.

The user should enter a stroke time that is the average of the fastest and the
slowest.  If 1.5 times this stroke time is not greater than or equal to the
longest stroke time, the user should change the stroke time so that the product
(1.5 * stroke time) is greater than or equal to the longest stroke time.


Incremental Outputs - Output Command Stops Near Zero or One Hundred
================================================================================
The command to an incremental output could stick near zero or one hundred
percent.  If the command was within deadband of either limit, the command would
not go to zero or one hundred.  The deadband is automatically calculated by
dividing 0.51 by the stroke time (in minutes) for sideloop applications and by
dividing 0.9 by the stroke time for all other applications.


VMA Application - Autocal Now Runs when Autocal Period is Changed
================================================================================
Autocalibration will run when the Autocal Period attribute is changed.  If the
current Autocal Time is greater than the Autocal Period, the sensor will be
calibrated.


VMA Application - Units Attributes added
================================================================================
Units attributes have been added to the views to allow changing to liters per
second (l/s).


VMA Application - Flow Controller Now Properly Setup for CU Meters/Hr
================================================================================
The Flow controller will be setup properly when the job information is changed
to metric.  If liters per second (l/s) are required, the values must be changed
manually.  The following table lists the values for each unit type.

    Attr              IP              SI              SI
    ---------------------------------------------------------------
    Pvar Units        CFM             cu meters/hr    l/s
    Max Velocity      3200            58522           16243
    Delta Vp          0.0001282116    0.03193610      0.03193610
    Min Delta Vp      0.05            12.45           12.45
    Flow Coefficient  4004            4644            1289


OEM Application - McQuay Global Chiller Modified to Improve Startup
================================================================================
The application now allows the unit to run for at least 10 seconds on startup,
even if the previous pumpdown had pulled the pressure to a vacuum.


HVAC PRO - VMA Box Balancing
================================================================================
The VMA box balancing tool would not calculate correct pickup gains if the flow
controller were not setup for CFM.


HVAC PRO - VMA Download Error
================================================================================
Near the end of a VMA download, the HVAC PRO comhndlr would abort.


HVAC PRO - Configuration Process Aborted
================================================================================
When a change to an existing VMA configuration loads an I/O point at a
previously defined I/O location, the configuration process aborts and all
configuration changes were lost.  HVAC PRO was modified to automatically over-
write the user-defined I/O.


HVAC PRO - Cannot Initialize Commissioning Mode
================================================================================
Release 7.00 produced an error when attempting to commission a controller at
Release 6.02.



        ****************************************************************
                         Problem Fixes in Release 7.00
        ****************************************************************

File Save As - Unreferenced Sideloop Parameter
================================================================================
An Unreferenced Parameter error for File-Save As has been corrected. This
error affected configurations containing a sideloop that used PI with reset
control. The error occurred only if the configuration was initially saved for a
2K UNT and was subsequently saved for an 8K UNT.


AHU Application - Cooling Windup for 100% OA Units
================================================================================
The AHU 100% OA paths have been fixed to prevent cooling windup when the cooling
is locked out. The problem caused overcooling in the zone. HVAC PRO now looks at
the cooling lockout and fan status to zero the Integration Term for the PI loop.



        ****************************************************************
                   MISCELLANEOUS INFORMATION AND INTERACTIONS
        ****************************************************************

Template Files
================================================================================
A template file is any file with the extension DMO or DDL that uses the CS Model
DDL syntax.  HVAC PRO creates DDL files for TC-9100 devices while GX9100 creates
DMO files for DX-9100 devices.

The points listed in a template file are displayed as inputs (CSAI, CSBI),
outputs (CSAO, CSBO), or parameters (CSAD, CSBD, CSSP, CSMS) on the HVAC PRO
screen.  A maximum of 225 parameters may be displayed.  When you open a template
file, HVAC PRO will ignore any parameter type points after the first 225 are
read.  A message indicating this will be written to the error/warning file
(filename.err) generated by HVAC PRO.


WARNING! TC-9100 CONTROLLER DOWNLOADS VIA METASYS
            RESTRICTIONS FOR HVAC PRO Release 6.03 or later CONFIGURATIONS
================================================================================
TC-9100 configurations created using HVAC PRO Release 6.03 or later CANNOT be 
downloaded to a TC device using the Metasys PMI Action Menu (Download command) 
for Metasys Release 9.0 or EARLIER!  TC-9100 download files created by HVAC PRO 
Release 6.03 or later now use the extension "TCD" and will NOT be recognized as 
downloadable files by Metasys Release 9.0 or earlier. TC-9100 download files 
created by previous versions of HVAC PRO used the file extension "TCO" which IS 
recognized as a downloadable file and CAN be downloaded via the Metasys PMI 
Action Menu.
   ***********************************************************
   ***  DO NOT RENAME *.TCD FILES AND ATTEMPT TO DOWNLOAD  ***
   ***    THEM USING METASYS Release 9.0 OR EARLIER!       ***
   ***  THIS WILL CAUSE A PROTECT VIOLATION IN THE NCM!    ***
   ***********************************************************
   Note:  You CAN use HVAC PRO Release 6.03+ running on the OWS to download
          HVAC PRO Release 6.03+ TC-9100 configurations.


Commissioning DX-9100/9120 Controllers
================================================================================
If you install HVAC PRO, you do NOT need to install DX Commissioning
to commission DX-9100/9120 controllers!  Simply open the DX template file
(*.DMO) using the Open command in the HVAC PRO File menu (hint: select Templates
as the File Type on the File Open dialog box). Then enter commissioning using
the Current Configuration command in the Commission menu.

Note: DX-9120 controllers can only be commissioned via the RS232-C serial port
      or while running HVAC PRO on an OWS.


HW Analog Input Sensor Type
================================================================================
Note that the Honeywell C7170A Discharge Water Sensor type (HW) should ONLY be
used for applications targeted for a UNT-330-1 controller. If the HW sensor is
used for any AIs in an application, all other target devices will removed from
the Devices Allowed listing when you save the configuration file.


ASCs: Analog Input Ranging for Pressure Sensors
================================================================================
When an ASC download object is generated, HVAC PRO determines the full range and
the reliability range of each analog input sensor based on its sensor type and
the range values specified in the Analog Input Modify screen.

For most analog inputs, the reliability range of the sensor is defined by the
low and high output range values entered by the operator. However, for AIs
defined as pressure sensors in the Question and Answer (Q/A) session, the usable
range of the DP sensor (e.g. 0 to 1.5 in. w.g, 1 to 5 volts) must be
extrapolated to the full range of the A/D converter (e.g. -0.2 to 10.2 volts).

The extrapolated values then represent both the full range and the reliability
range of the sensor. When the controller is downloaded, the high and low limit
values of the full range are stored in the controller along with the high and
low limit values of the reliability range.

For pressure sensors, the reliability range equals the full range.  Thus, the
range values entered by the operator (e.g. 0 to 1.5 in. w.g., 1 to 5 volts) are
not stored in the controller and cannot be retrieved by the upload or com-
missioning utilities. This may result in value differences between the range
values stored in a configuration file and the values obtained from the
controller during an upload, upgrade, or commissioning.

The differences between the values do not affect the operation of the
controller!  Using the full range values retrieved from the controller rather
than the specific range values shown in the original configuration file will
yield the same result.  The calibration remains the same and the AI offset is
unaffected.


Data Graphing - General Protection Fault
================================================================================
Problems with the data graphing feature on certain computers have been reported.
When attempting to perform data graphing or loop tuning, a general protection
fault error will be generated.  A somewhat reliable workaround on these PCs has
been to delete all the printers defined on the PC, re-install HVAC PRO and
install a generic text printer.

If the above work around is unsuccessful, it will be necessary to begin with a
freshly formatted drive and install HVAC PRO as one of the first applications.
It may be possible to re-install the other applications once the loop tuning
and data graphing features are operating properly.


Communication Errors Due to Converter
================================================================================
HVAC PRO Release 7.03 or later should automatically detect the operating sys-
tem platform and properly adjust for the supported N2 converter.  If you are
unable to communicate via the N2, you may manually override the converter type.
In the HVACPRO.INI file, add a line UseNTCVT=0 for the MM-CVT101 converter or
add a line UseNTCVT=1 for the B&B converter.  Remember on NT machines, only the
B&B converter will work.


