/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package appliance.ui;

import java.io.*;
import java.util.*;
import javax.baja.sys.*;
import javax.baja.collection.*;
import javax.baja.naming.*;
import javax.baja.status.*;
import javax.baja.file.*;
import javax.baja.util.*;
import javax.baja.gx.*;
import javax.baja.ui.*;
import javax.baja.ui.event.*;
import javax.baja.ui.table.*;
import javax.baja.ui.util.*;
import javax.baja.workbench.*;
import javax.baja.workbench.view.*;
import javax.baja.workbench.bql.table.*;
import appliance.*;
import appliance.driver.*;

/**
 * BEquipSummary shows a summary of equip assigned to a Group.
 *
 * @author    Brian Frank       
 * @creation  18 Nov 04
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public class BEquipSummary  
  extends BWbComponentView
{   

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BEquipSummary.class);
  
  public void doLoadValue(BObject obj, Context cx)
  {
    BGroup group = (BGroup)obj;
    
    BBqlTable table = new BBqlTable(new BqlTableColumn[]
      {      
        new BqlTableColumn("displayName",      "Name", 0),
        new BqlTableColumn("type.displayName", "Type", 0),
        new BqlTableColumn("tempToString",     "Temp", 0),
        new BqlTableColumn.Icon(),
        new BqlTableColumn.Nav(),
        new BqlTableColumn.Status(),
      });                                                      
    BqlTableModel model = table.getBqlModel();
    model.setExtent("demoAppliance:ApplianceDevice");
    model.setPredicate("group = '" + group.getHandleOrd() + "'");
    model.setBase(group, "station:|slot:/");
    model.load();

    // no popup
    table.setController(new BqlTableController()
    {
      protected BMenu makePopup(BqlTableSubject subject) 
      { 
        return null; 
      }
    });
    
//    // run BQL query to get ords of devices
//    String bql = "station:|slot:/|bql:select " +
//      "displayName as 'Name', type.displayName as 'Type', tempToString as 'Temp' " +   
//      "from demoAppliance:ApplianceDevice " +
//      "where group = '" + group.getHandleOrd() + "'";
//    BITable result = (BITable)BOrd.make(bql).get(group);

    // map into TableModel
    setContent(BTitlePane.makePane("Equip for " + group.getDisplayName(null), table));
  } 
  
}

