/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package appliance.ui;

import java.io.*;
import java.util.*;
import javax.baja.sys.*;
import javax.baja.naming.*;
import javax.baja.space.*;
import javax.baja.status.*;
import javax.baja.file.*;
import javax.baja.util.*;
import javax.baja.gx.*;
import javax.baja.ui.*;
import javax.baja.ui.event.*;
import javax.baja.workbench.*;
import javax.baja.workbench.component.table.*;
import javax.baja.workbench.mgr.*;
import javax.baja.schedule.*;
import appliance.*;
import appliance.driver.*;

/**
 * BEquipManager is a simple tools for adding/removing/configuring ApplianceDevices.
 *
 * @author    Brian Frank       
 * @creation  18 Nov 04
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public class BEquipManager  
  extends BAbstractManager
{   

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BEquipManager.class);
  
////////////////////////////////////////////////////////////////
// AbstractManager
////////////////////////////////////////////////////////////////

  protected MgrModel makeModel() { return new Model(this); }
  protected MgrController makeController() { return new Controller(this); }

////////////////////////////////////////////////////////////////
// Model
////////////////////////////////////////////////////////////////
  
  class Model extends MgrModel
  {                                  
    Model(BEquipManager mgr) { super(mgr); }
    
    protected String makeTableTitle()
    {
      return "Equipment";
    }  
    
    protected MgrColumn[] makeColumns()
    {
      return new MgrColumn[] 
      { 
        new MgrColumn.Name(),
        new MgrColumn.Type(0),
        new MgrColumn.Prop(BApplianceDevice.status),
        new MgrColumn.Prop("Group", BApplianceDevice.groupDisplay, 0),
        new MgrColumn.Prop(BApplianceDevice.occupied),
        new ColGroup(),
        new MgrColumn.Prop(BApplianceDevice.enabled, MgrColumn.UNSEEN | MgrColumn.EDITABLE),
        new MgrColumn.Prop(BApplianceDevice.temp),
        new MgrColumn.Prop(BApplianceDevice.setpoint, MgrColumn.EDITABLE),
      };
    }
  
    public Type[] getIncludeTypes()
    {                                   
      return new Type[] { BApplianceDevice.TYPE };
    }                                                              
    
    public MgrTypeInfo[] getNewTypes()
    {                            
      Array types = new Array(MgrTypeInfo.class);
      
      // make all the bog files found in file:^prototypes available
      BIDirectory dir = (BIDirectory)BOrd.make("file:^prototypes").get(getCurrentValue());
      BIFile[] files = dir.listFiles();
      for(int i=0; i<files.length; ++i)
      {
        BIFile file = files[i];
        try
        { 
          // find component called "Prototype" in each bog
          String name = FileUtil.getBase(file.getFileName());
          BOrd protoOrd = BOrd.make("bog:|slot:/Prototype");
          BComponent proto = (BComponent)protoOrd.get((BObject)file);
          types.add(new ProtoType(name, proto));
        }        
        catch(Exception e)
        {
          System.out.println("ERROR: Not prototype bog: " + file + ": " + e);
        }
      }             
      
      return (MgrTypeInfo[])types.trim();
    }
  }
  
  static class ColGroup extends MgrColumn.Prop
  {              
    ColGroup()
    {
      super(BApplianceDevice.group, MgrColumn.UNSEEN | MgrColumn.EDITABLE);
    }                       
    
    public String toDisplayString(Object row, Object value, Context cx)
    {                      
      // this is rather expensive, since it has a potential 
      // network call the first time we resolve the ord
      BOrd ord = (BOrd)value;
      if (ord.isNull()) return "";
      BComponent c = (BComponent)ord.get(getManager().getCurrentValue());
      return c.getDisplayName(cx);
    }
  }

  static class ProtoType extends MgrTypeInfo
  {                        
    ProtoType(String name, BComponent proto) { this.name = name; this.proto = proto; }
    public String getDisplayName() { return name; }
    public BImage getIcon() { return BImage.make(proto.getIcon()); }
    
    public BComponent newInstance() 
      throws Exception
    {        
      CopyHints hints = new CopyHints();
      hints.swizzleHandles = true;    
      return (BComponent)proto.newCopy(hints);                     
    }
    
    public boolean isMatchable(BComponent db) { return db.getType().is(proto.getType()); }
    String name;
    BComponent proto;
  }
  
////////////////////////////////////////////////////////////////
// Controller
////////////////////////////////////////////////////////////////
  
  class Controller extends MgrController
  {
    Controller(BEquipManager mgr) 
    { 
      super(mgr); 
    }                                                                                  

    public BMenu makePopup(BMgrTable table, ComponentTableSubject selection, BMenu menu)
    {
      menu = super.makePopup(table, selection, menu);
      return BApplianceProfile.trim(menu);
    }
    
    public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col)
    {                                      
      BComponent comp = table.getComponentAt(row);
      BWbShell shell = getWbShell();
      if (comp != null && shell != null)
        shell.hyperlink(new HyperlinkInfo(comp.getNavOrd(), event));
    }  
  }

}

