/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
package appliance.hx;

import javax.baja.hx.mgr.*;
import javax.baja.sys.*;
import appliance.*;
import appliance.driver.*;

/**
 * BHxEquipManager.
 *
 * @author    Andy Frank
 * @creation  22 Mar 05
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public class BHxEquipManager
  extends BHxAbstractManager
{
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public static final BHxEquipManager INSTANCE = new BHxEquipManager();
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BHxEquipManager.class);
      
  protected BHxEquipManager() {}

////////////////////////////////////////////////////////////////
// Model
////////////////////////////////////////////////////////////////

  protected HxMgrModel makeModel() { return new Model(); }
  
  class Model extends HxMgrModel
  {                                  
    public String makeTableTitle() { return "Equipment"; }  
    public Type[] getIncludeTypes() { return new Type[] { BApplianceDevice.TYPE }; }
    protected HxMgrColumn[] makeColumns()
    {
      return new HxMgrColumn[] {
        new HxMgrColumn.Name(),
        new HxMgrColumn.Type(0),
        new HxMgrColumn.Prop(BApplianceDevice.status),
        new HxMgrColumn.Prop("Group", BApplianceDevice.groupDisplay, 0),
        new HxMgrColumn.Prop(BApplianceDevice.occupied),        
        new HxMgrColumn.Prop(BApplianceDevice.temp),
        new HxMgrColumn.Prop(BApplianceDevice.setpoint, HxMgrColumn.EDITABLE),
      };
    }    
  }   
}


