/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
package appliance.hx;

import javax.baja.hx.*;
import javax.baja.hx.table.view.*;
import javax.baja.naming.*;
import javax.baja.sys.*;
import javax.baja.user.*;
import appliance.ui.*;

/**
 * BHxApplianceUserManager.
 *
 * @author    Andy Frank
 * @creation  24 Mar 05
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public class BHxApplianceUserManager
  extends BTableView
{
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public static final BHxApplianceUserManager INSTANCE = new BHxApplianceUserManager();
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BHxApplianceUserManager.class);
      
  protected BHxApplianceUserManager() {}

////////////////////////////////////////////////////////////////
// BComponentTable
////////////////////////////////////////////////////////////////

  public TableViewModel makeModel(HxOp op)
    throws Exception
  { 
    return new Model(op); 
  }

  class Model extends CompTableViewModel
  {                                  
    public Model(HxOp op) 
      throws Exception 
    { 
      super(op);
    }
    
    public String getTableTitle(HxOp op)  
    { 
      return BApplianceUserManager.TYPE.getDisplayName(null);
    }
      
    public Type[] getNewTypes() 
    { 
      return new Type [] { BUser.TYPE }; 
    }    
    
    public Type[] getIncludeTypes() 
    { 
      return new Type [] { BUser.TYPE };
    }

    public boolean accept(BComponent c)
    {
      if (c.getName().equals("admin")) return false;
      if (c.getName().equals("guest")) return false;
      return true;
    }    

    public BComponent newInstance(Type type)
      throws Exception
    {                 
      BUser[] protos = BApplianceUserManager.getProtos(Sys.getStation());
      BUser user = (BUser)type.getInstance();
      user.add("role", BString.make(protos[0].getName()), Flags.READONLY);
      return BApplianceUserManager.copyFromProto(user, protos[0]);
    }
        
    public CompTableViewCol[] makeColumns(HxOp op)
    {
      return new CompTableViewCol[] 
      {
        new CompTableViewCol.Name(),
        new CompTableViewCol.Prop(BUser.password, CompTableViewCol.EDITABLE | CompTableViewCol.UNSEEN),
        new RoleColumn()
      };
    }
    
    public Command[] makeCommands(HxOp op)
    {
      return new Command[]
      {
        new CompTableViewCommands.New(BHxApplianceUserManager.INSTANCE),
        new CompTableViewCommands.Edit(BHxApplianceUserManager.INSTANCE),
        new CompTableViewCommands.Delete(BHxApplianceUserManager.INSTANCE)
      };
    }
  }

////////////////////////////////////////////////////////////////
// RoleColumn 
////////////////////////////////////////////////////////////////

  class RoleColumn extends CompTableViewCol
  {                   
    public RoleColumn() 
    { 
      super("Role", CompTableViewCol.EDITABLE); 
    }
    
    public Object get(Object row)
    {
      BComplex complex = (BComplex)row;
      return complex.get("role");
    }

    public BHxFieldEditor getEditor(BComponent[] rows)
    {
      return BHxUserRoleFE.INSTANCE;
    }
    
    public void save(BComponent[] rows, BValue value, Context cx)
    { 
      for (int j=0; j<rows.length; j++)
      {
        BComponent target = rows[j];
        Property prop = target.getProperty("role");
        BValue old = target.get(prop);
        if (!old.equivalent(value)) 
        {
          target.set(prop, value.newCopy(), cx);
          String role = ((BString)value).getString();          
          BUser[] protos = BApplianceUserManager.getProtos(Sys.getStation());
          for (int i=0; i<protos.length; i++)
          {
            String name = SlotPath.unescape(protos[i].getName());
            if (role.equals(name)) 
              BApplianceUserManager.copyFromProto((BUser)target, protos[i]);
          }        
        }
      }
    }
  }     
}


