/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
package appliance.hx;

import java.util.*;
import javax.baja.agent.*;
import javax.baja.file.*;
import javax.baja.gx.*;
import javax.baja.hx.*;
import javax.baja.io.*;
import javax.baja.naming.*;
import javax.baja.nav.*;
import javax.baja.space.*;
import javax.baja.sys.*;

/**
 * BApplianceHxViewMenu displays the available views for the
 * active target as a set of tabs.
 *
 * @author    Andy Frank
 * @creation  17 Mar 05
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public class BApplianceHxViewMenu
  extends BHxView
{
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public static final BApplianceHxViewMenu INSTANCE = new BApplianceHxViewMenu();
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BApplianceHxViewMenu.class);
  
  protected BApplianceHxViewMenu() {}

////////////////////////////////////////////////////////////////
// HxView
////////////////////////////////////////////////////////////////
  
  /**
   * Write out the view to the content stream.
   */
  public void write(HxOp op) 
    throws Exception
  {
    AgentList agents  = HxUtil.getViews(op);
    AgentInfo defView = HxUtil.getDefaultView(op);
    HtmlWriter out = op.getHtmlWriter();
    
    // check if the ord ends with |view: viewId
    String viewId = null;
    OrdQuery[] queries = op.getOrd().parse();    
    if (queries.length > 0)
    {
      OrdQuery lastQuery = queries[queries.length-1];
      if (lastQuery instanceof ViewQuery)
        viewId = ((ViewQuery)lastQuery).getViewId();
    }
    
    // Strip exisiting view from base ord
    String base = op.getOrd().toString();
    int index = base.indexOf("|view:");
    if (index != -1) base = base.substring(0, index);
    
    // Write views
    out.w("<ul class='appliance-views'>");
    for (int i=0; i<agents.size(); i++)
    {
      AgentInfo agent = agents.get(i);
      String name = agent.getDisplayName(op);
      String agentId = agent.getAgentId();
      BImage icon = BImage.make(agent.getIcon(op));
      
      BOrd ord  = BOrd.make(base + "|view:" + agentId);
      out.w("<li><a");
      
      if (viewId != null && viewId.equals(agentId))
        out.attr(" class", "appliance-view-link active");
      else if (viewId == null && agentId.equals(defView.getAgentId()))
        out.attr(" class", "appliance-view-link active");
      else
        out.attr(" class", "appliance-view-link");
              
      out.attr(" href", ord.relativizeToSession()).w(">");
      out.w("<img ").attr("src", icon.getOrdList().get(0));
      out.w(" border='0' style='vertical-align:middle;'/> ");
      out.w(name);
      out.w("</a></li>");
    }
    out.w("</ul>");    
  }  
}



