/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
package appliance.hx;

import java.util.*;
import javax.baja.agent.*;
import javax.baja.file.*;
import javax.baja.gx.*;
import javax.baja.hx.*;
import javax.baja.io.*;
import javax.baja.naming.*;
import javax.baja.nav.*;
import javax.baja.space.*;
import javax.baja.sys.*;

/**
 * BApplianceHxLocatorBar is used by BApplianceHxProfile to
 * visualize to location/ord of the active view.
 *
 * @author    Andy Frank
 * @creation  17 Mar 05
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public class BApplianceHxLocatorBar
  extends BHxView
{
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public static final BApplianceHxLocatorBar INSTANCE = new BApplianceHxLocatorBar();
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BApplianceHxLocatorBar.class);
  
  protected BApplianceHxLocatorBar() {}

////////////////////////////////////////////////////////////////
// HxView
////////////////////////////////////////////////////////////////
  
  /**
   * Write out the view to the content stream.
   */
  public void write(HxOp op) 
    throws Exception
  {
    HtmlWriter out = op.getHtmlWriter();
    out.w("<div class='appliance-locator-border'>");
    
    // Lookup target in NavFile
    BINavNode target = (BINavNode)op.get();
    BIFile file = (BIFile)BOrd.make("file:^NavFile.nav").get();
    BNavFileSpace space = NavFileDecoder.load(file);
    BINavNode node = space.lookup(target.getNavOrd());
    
    // Build path
    ArrayList path = new ArrayList();
    while (node != null && !(node instanceof BSpace))
    {
      path.add(0, node);
      node = node.getNavParent();
    }
    
    // Write path
    out.w("<div class='appliance-locator-path'>");
    for (int i=0; i<path.size(); i++)
    {
      if (i > 0) out.w(" &raquo; ");
      writeNode((BINavNode)path.get(i), op);
    }    
    out.w("</div>");
    
    // Write children
    node = space.lookup(target.getNavOrd());
    if (node != null)
    {
      BINavNode[] kids = node.getNavChildren();
      if (kids.length > 0)
      {
        out.w("<div class='appliance-locator-kids'>");
        for (int i=0; i<kids.length; i++)
        {
          if (i > 0) out.w("&nbsp;&nbsp;");
          writeNode(kids[i], op);  
        }    
        out.w("</div>");
      }
    }
        
    out.w("</div>");
  }
    
////////////////////////////////////////////////////////////////
// Util
////////////////////////////////////////////////////////////////
  
  /**
   * Writes a node as an icon and hyperlink.
   */
  private void writeNode(BINavNode node, HxOp op)
    throws Exception
  {
    HtmlWriter out = op.getHtmlWriter();
    
    // Icon
    BImage icon = BImage.make(node.getNavIcon());
    out.w("<img ").attr("src", icon.getOrdList().get(0));
    out.attr("style", "vertical-align:middle;").w("/>");
    
    // Link
    out.w(" <a ").attr("href", node.getNavOrd()).w(">");
    out.w(node.getNavDisplayName(op));
    out.w("</a>");
  }
}



