/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package appliance.driver;

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.agent.*;
import javax.baja.nav.*;
import javax.baja.naming.*;
import javax.baja.units.*;
import javax.baja.util.*;
import javax.baja.driver.*;
import appliance.*;

/**
 * BApplianceDevice
 *
 * @author    Brian Frank
 * @creation  18 Nov 04
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public abstract class BApplianceDevice
  extends BDevice
{          

  static final BUnit degrees;
  static final BUnit cfm;
  static 
  {
    UnitDatabase.getDefault();
    degrees = BUnit.getUnit("fahrenheit");
    cfm = BUnit.getUnit("cubic feet per minute");
  }

  /*-
  class BApplianceDevice
  {
    properties
    {
      address: String
        default {[ "" ]}
      
      group: BOrd
        -- should always be handle ord
        default {[ BOrd.NULL ]}
        slotfacets {[ BFacets.make(BFacets.FIELD_EDITOR, "demoAppliance:GroupOrdFE") ]}      

      groupDisplay: String
        default {[ "-" ]}
        
      temp: BStatusNumeric
        default {[ new BStatusNumeric(70) ]}
        slotfacets {[ BFacets.make(BFacets.UNITS, degrees, BFacets.PRECISION, BInteger.make(1)) ]}      
        
      setpoint: double
        default {[ 70 ]}
        slotfacets {[ BFacets.make(BFacets.UNITS, degrees, BFacets.PRECISION, BInteger.make(1)) ]}      
        
      effectiveSetpoint: BStatusNumeric
        default {[ new BStatusNumeric(70) ]}
        slotfacets {[ BFacets.make(BFacets.UNITS, degrees, BFacets.PRECISION, BInteger.make(1)) ]}      
        
      occupied: BStatusBoolean
        default {[ new BStatusBoolean() ]}
        slotfacets {[ BFacets.makeBoolean("Occupied", "Unoccupied") ]}      
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $appliance.driver.BApplianceDevice(1742417947)1.0$ @*/
/* Generated Sat Nov 20 20:49:24 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "address"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>address</code> property.
   * @see appliance.driver.BApplianceDevice#getAddress
   * @see appliance.driver.BApplianceDevice#setAddress
   */
  public static final Property address = newProperty(0, "",null);
  
  /**
   * Get the <code>address</code> property.
   * @see appliance.driver.BApplianceDevice#address
   */
  public String getAddress() { return getString(address); }
  
  /**
   * Set the <code>address</code> property.
   * @see appliance.driver.BApplianceDevice#address
   */
  public void setAddress(String v) { setString(address,v,null); }

////////////////////////////////////////////////////////////////
// Property "group"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>group</code> property.
   * should always be handle ord
   * @see appliance.driver.BApplianceDevice#getGroup
   * @see appliance.driver.BApplianceDevice#setGroup
   */
  public static final Property group = newProperty(0, BOrd.NULL,BFacets.make(BFacets.FIELD_EDITOR, "demoAppliance:GroupOrdFE") );
  
  /**
   * Get the <code>group</code> property.
   * @see appliance.driver.BApplianceDevice#group
   */
  public BOrd getGroup() { return (BOrd)get(group); }
  
  /**
   * Set the <code>group</code> property.
   * @see appliance.driver.BApplianceDevice#group
   */
  public void setGroup(BOrd v) { set(group,v,null); }

////////////////////////////////////////////////////////////////
// Property "groupDisplay"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>groupDisplay</code> property.
   * @see appliance.driver.BApplianceDevice#getGroupDisplay
   * @see appliance.driver.BApplianceDevice#setGroupDisplay
   */
  public static final Property groupDisplay = newProperty(0, "-",null);
  
  /**
   * Get the <code>groupDisplay</code> property.
   * @see appliance.driver.BApplianceDevice#groupDisplay
   */
  public String getGroupDisplay() { return getString(groupDisplay); }
  
  /**
   * Set the <code>groupDisplay</code> property.
   * @see appliance.driver.BApplianceDevice#groupDisplay
   */
  public void setGroupDisplay(String v) { setString(groupDisplay,v,null); }

////////////////////////////////////////////////////////////////
// Property "temp"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>temp</code> property.
   * @see appliance.driver.BApplianceDevice#getTemp
   * @see appliance.driver.BApplianceDevice#setTemp
   */
  public static final Property temp = newProperty(0, new BStatusNumeric(70),BFacets.make(BFacets.UNITS, degrees, BFacets.PRECISION, BInteger.make(1)) );
  
  /**
   * Get the <code>temp</code> property.
   * @see appliance.driver.BApplianceDevice#temp
   */
  public BStatusNumeric getTemp() { return (BStatusNumeric)get(temp); }
  
  /**
   * Set the <code>temp</code> property.
   * @see appliance.driver.BApplianceDevice#temp
   */
  public void setTemp(BStatusNumeric v) { set(temp,v,null); }

////////////////////////////////////////////////////////////////
// Property "setpoint"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>setpoint</code> property.
   * @see appliance.driver.BApplianceDevice#getSetpoint
   * @see appliance.driver.BApplianceDevice#setSetpoint
   */
  public static final Property setpoint = newProperty(0, 70,BFacets.make(BFacets.UNITS, degrees, BFacets.PRECISION, BInteger.make(1)) );
  
  /**
   * Get the <code>setpoint</code> property.
   * @see appliance.driver.BApplianceDevice#setpoint
   */
  public double getSetpoint() { return getDouble(setpoint); }
  
  /**
   * Set the <code>setpoint</code> property.
   * @see appliance.driver.BApplianceDevice#setpoint
   */
  public void setSetpoint(double v) { setDouble(setpoint,v,null); }

////////////////////////////////////////////////////////////////
// Property "effectiveSetpoint"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>effectiveSetpoint</code> property.
   * @see appliance.driver.BApplianceDevice#getEffectiveSetpoint
   * @see appliance.driver.BApplianceDevice#setEffectiveSetpoint
   */
  public static final Property effectiveSetpoint = newProperty(0, new BStatusNumeric(70),BFacets.make(BFacets.UNITS, degrees, BFacets.PRECISION, BInteger.make(1)) );
  
  /**
   * Get the <code>effectiveSetpoint</code> property.
   * @see appliance.driver.BApplianceDevice#effectiveSetpoint
   */
  public BStatusNumeric getEffectiveSetpoint() { return (BStatusNumeric)get(effectiveSetpoint); }
  
  /**
   * Set the <code>effectiveSetpoint</code> property.
   * @see appliance.driver.BApplianceDevice#effectiveSetpoint
   */
  public void setEffectiveSetpoint(BStatusNumeric v) { set(effectiveSetpoint,v,null); }

////////////////////////////////////////////////////////////////
// Property "occupied"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>occupied</code> property.
   * @see appliance.driver.BApplianceDevice#getOccupied
   * @see appliance.driver.BApplianceDevice#setOccupied
   */
  public static final Property occupied = newProperty(0, new BStatusBoolean(),BFacets.makeBoolean("Occupied", "Unoccupied") );
  
  /**
   * Get the <code>occupied</code> property.
   * @see appliance.driver.BApplianceDevice#occupied
   */
  public BStatusBoolean getOccupied() { return (BStatusBoolean)get(occupied); }
  
  /**
   * Set the <code>occupied</code> property.
   * @see appliance.driver.BApplianceDevice#occupied
   */
  public void setOccupied(BStatusBoolean v) { set(occupied,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BApplianceDevice.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Factory
////////////////////////////////////////////////////////////////

  static BPxView makeView(String icon, String ord)
  {             
    BPxView v = new BPxView();
    v.setIcon(BIcon.std(icon));
    v.setPxFile(BOrd.make(ord));
    return v;
  }

////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  public String tempToString()
  {
    return propertyValueToString(temp, null);
  }

  public Type getNetworkType()
  {
    return BApplianceNetwork.TYPE;
  }            
  
  public IFuture postPing()
  {  
    return null;
  }

  public void doPing()
  {  
    pingOk(); // fake it
  }
  
  public void started()
    throws Exception
  {       
    super.started();
    updateGroup();
  } 
  
  public void changed(Property prop, Context cx)
  {                 
    super.changed(prop, cx); 
    if (isRunning())
    {
      if (prop.equals(group)) 
      {                  
        ((BApplianceNetwork)getNetwork()).rebuildNavFile();
        updateGroup();
      }
    }
  }

////////////////////////////////////////////////////////////////
// Group
////////////////////////////////////////////////////////////////
  
  /**
   * Called when group is changed.
   */
  public void updateGroup()
  {             
    try
    {                  
      BGroup group = (BGroup)getGroup().get(this);
      setGroupDisplay(group.getDisplayName(null));
      compute(group);
    }
    catch(Exception e)
    {
      setGroupDisplay("");
    }
  }             
  
  /**
   * Called periodically by group to sync
   */
  public void compute(BGroup group)
  {     
    BStatusBoolean occupied = (BStatusBoolean)group.getSchedule().getOut().newCopy();
    setOccupied(occupied);
    if (occupied.getValue())
    {
      setEffectiveSetpoint(new BStatusNumeric(
        getSetpoint(), statusSetpoint));
    }
    else
    {
      setEffectiveSetpoint(new BStatusNumeric(
        group.getUnoccupiedSetpoint(), statusUnoccupied));
    }                               
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  static final BStatus statusSetpoint = BStatus.make(0, BFacets.make("setpoint", BBoolean.TRUE));  
  static final BStatus statusUnoccupied = BStatus.make(0, BFacets.make("unoccupied", BBoolean.TRUE));  
  
}
