/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package appliance;

import javax.baja.sys.*;
import javax.baja.naming.*;
import javax.baja.nav.*;
import javax.baja.agent.*;
import javax.baja.units.*;
import javax.baja.util.*;
import javax.baja.schedule.*;

/**
 * BGroupFolder contains other Groups
 *
 * @author    Brian Frank
 * @creation  18 Nov 04
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public class BGroupFolder
  extends BFolder
{          

  /*-
  class BGroupFolder
  {
    properties
    {
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $appliance.BGroupFolder(1954612599)1.0$ @*/
/* Generated Sat Nov 20 15:29:49 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BGroupFolder.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Lifecycle
////////////////////////////////////////////////////////////////

  public void added(Property prop, Context cx)
  {          
    super.added(prop, cx);
    rebuildNavFile();
  }

  public void removed(Property prop, BValue old, Context cx)
  {          
    super.removed(prop, old, cx);
    rebuildNavFile();
  }

  public void renamed(Property prop, String old, Context cx)
  {
    super.renamed(prop, old, cx);
    rebuildNavFile();
  }

  public void reordered(Context cx)
  {
    super.reordered(cx);
    rebuildNavFile();
  }
  
  void rebuildNavFile()
  {
    try
    {               
      if (isRunning()) BApplianceApp.get().rebuildNavFile();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }

////////////////////////////////////////////////////////////////
// BObject
////////////////////////////////////////////////////////////////

  public AgentList getAgents(Context cx)
  {      
    AgentList agents = super.getAgents(cx);
    agents.toTop("demoAppliance:GroupManager");
    return agents;
  }

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("pointFolder.png");
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
}
