/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package appliance;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.naming.*;
import javax.baja.nav.*;
import javax.baja.units.*;
import javax.baja.util.*;
import javax.baja.xml.*;
import appliance.driver.*;

/**
 * BApplianceApp
 *
 * @author    Brian Frank
 * @creation  18 Nov 04
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public class BApplianceApp
  extends BAbstractService
{          

  /*-
  class BApplianceApp
  {
    properties
    {             
      splash: BOrd
        default {[ BOrd.make("module://demoAppliance/appliance/ui/InitechSplash.png") ]} 
      groups: BGroupFolder
        default {[ new BGroupFolder() ]}
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $appliance.BApplianceApp(3548199255)1.0$ @*/
/* Generated Sat Nov 20 15:29:49 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "splash"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>splash</code> property.
   * @see appliance.BApplianceApp#getSplash
   * @see appliance.BApplianceApp#setSplash
   */
  public static final Property splash = newProperty(0, BOrd.make("module://demoAppliance/appliance/ui/InitechSplash.png"),null);
  
  /**
   * Get the <code>splash</code> property.
   * @see appliance.BApplianceApp#splash
   */
  public BOrd getSplash() { return (BOrd)get(splash); }
  
  /**
   * Set the <code>splash</code> property.
   * @see appliance.BApplianceApp#splash
   */
  public void setSplash(BOrd v) { set(splash,v,null); }

////////////////////////////////////////////////////////////////
// Property "groups"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>groups</code> property.
   * @see appliance.BApplianceApp#getGroups
   * @see appliance.BApplianceApp#setGroups
   */
  public static final Property groups = newProperty(0, new BGroupFolder(),null);
  
  /**
   * Get the <code>groups</code> property.
   * @see appliance.BApplianceApp#groups
   */
  public BGroupFolder getGroups() { return (BGroupFolder)get(groups); }
  
  /**
   * Set the <code>groups</code> property.
   * @see appliance.BApplianceApp#groups
   */
  public void setGroups(BGroupFolder v) { set(groups,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BApplianceApp.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Accesss
////////////////////////////////////////////////////////////////

  public static BApplianceApp get()
  {
    return (BApplianceApp)Sys.getService(TYPE);
  }                                            
  
  public static BApplianceNetwork getEquip()
  {             
    return (BApplianceNetwork)Sys.getService(BApplianceNetwork.TYPE);
  }

////////////////////////////////////////////////////////////////
// NavFile
////////////////////////////////////////////////////////////////

  public void rebuildNavFile()
  {
    try
    {
      // header    
      System.out.println("rebuildNavFile");
      XWriter out = new XWriter(new File(Sys.getStationHome(), "NavFile.nav"));
      out.prolog();
      out.w("<nav version='1.0'>\n");
      out.w("<node name='Home' ord='station:|slot:/App' icon='module://icons/x16/home.png'>\n");
      // groups
      writeTree(out, getGroups(), 2);
      // equip
      writeTree(out, getEquip(), 2);
      // misc links
      out.w("  <node name='Histories' ord='history:' icon='module://icons/x16/historyDatabase.png'/>\n");
      out.w("  <node name='Alarms' ord='station:|slot:/Services/AlarmService/Console' icon='module://icons/x16/alarm.png'/>\n");
      out.w("  <node name='Users' ord='station:|slot:/Services/UserService' icon='module://icons/x16/user.png'/>\n");
      // footer
      out.w("</node>\n");
      out.w("</nav>\n");
      out.close();    
      BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeReplaced(BOrd.make("local:|file:^"), "NavFile.nav", null));
    }
    catch(Exception e)
    {             
      e.printStackTrace();
    }
  }      
  
  void writeTree(XWriter out, BINavNode n, int indent)
  {                           
    out.indent(indent)
       .w("<node name='").safe(n.getNavDisplayName(null))
       .w("' ord='").safe(n.getNavOrd().relativizeToSession().toString())
       .w("' icon='").safe(n.getNavIcon().toString()).w("'>\n");         
       
    BINavNode[] kids;
    if (n instanceof BGroup)
    {               
      kids = ((BGroup)n).getDevicesInGroup();
    }
    else if (n instanceof BApplianceDevice)
    {                 
      kids = new BINavNode[0];
    }
    else
    {    
      kids = n.getNavChildren();
    }
    for(int i=0; i<kids.length; ++i)
      writeTree(out, kids[i], indent+2);
    out.indent(indent).w("  </node>");    
  }

////////////////////////////////////////////////////////////////
// IService
////////////////////////////////////////////////////////////////

  public Type[] getServiceTypes()
  {
    return new Type[] { TYPE };
  }                  
  
  public void started()
  {
    rebuildNavFile();
  }

////////////////////////////////////////////////////////////////
// BObject
////////////////////////////////////////////////////////////////

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("site.png");

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
}
