/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package appliance;

import javax.baja.sys.*;
import javax.baja.naming.*;
import javax.baja.agent.*;
import javax.baja.units.*;
import javax.baja.util.*;
import javax.baja.schedule.*;

/**
 * BAlarmConfig defines alarm params for a BGroup
 *
 * @author    Brian Frank
 * @creation  18 Nov 04
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */
public class BAlarmConfig
  extends BComponent
{          

  static final BUnit degrees;
  static 
  {
    UnitDatabase.getDefault();
    degrees = BUnit.getUnit("fahrenheit");
  }

  /*-
  class BAlarmConfig
  {
    properties
    {
      tempAlarmEnabled: boolean
        default {[ true ]}

      tempAlarmDeadband: double
        default {[ 5 ]}
        slotfacets {[ BFacets.make(BFacets.UNITS, degrees) ]}

      tempAlarmAckRequired: boolean
        default {[ true ]}

      equipAlarmEnabled: boolean
        default {[ true ]}

      eqiupAlarmAckRequired: boolean
        default {[ true ]}
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $appliance.BAlarmConfig(2140145949)1.0$ @*/
/* Generated Thu Nov 18 18:26:43 EST 2004 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "tempAlarmEnabled"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>tempAlarmEnabled</code> property.
   * @see appliance.BAlarmConfig#getTempAlarmEnabled
   * @see appliance.BAlarmConfig#setTempAlarmEnabled
   */
  public static final Property tempAlarmEnabled = newProperty(0, true,null);
  
  /**
   * Get the <code>tempAlarmEnabled</code> property.
   * @see appliance.BAlarmConfig#tempAlarmEnabled
   */
  public boolean getTempAlarmEnabled() { return getBoolean(tempAlarmEnabled); }
  
  /**
   * Set the <code>tempAlarmEnabled</code> property.
   * @see appliance.BAlarmConfig#tempAlarmEnabled
   */
  public void setTempAlarmEnabled(boolean v) { setBoolean(tempAlarmEnabled,v,null); }

////////////////////////////////////////////////////////////////
// Property "tempAlarmDeadband"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>tempAlarmDeadband</code> property.
   * @see appliance.BAlarmConfig#getTempAlarmDeadband
   * @see appliance.BAlarmConfig#setTempAlarmDeadband
   */
  public static final Property tempAlarmDeadband = newProperty(0, 5,BFacets.make(BFacets.UNITS, degrees) );
  
  /**
   * Get the <code>tempAlarmDeadband</code> property.
   * @see appliance.BAlarmConfig#tempAlarmDeadband
   */
  public double getTempAlarmDeadband() { return getDouble(tempAlarmDeadband); }
  
  /**
   * Set the <code>tempAlarmDeadband</code> property.
   * @see appliance.BAlarmConfig#tempAlarmDeadband
   */
  public void setTempAlarmDeadband(double v) { setDouble(tempAlarmDeadband,v,null); }

////////////////////////////////////////////////////////////////
// Property "tempAlarmAckRequired"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>tempAlarmAckRequired</code> property.
   * @see appliance.BAlarmConfig#getTempAlarmAckRequired
   * @see appliance.BAlarmConfig#setTempAlarmAckRequired
   */
  public static final Property tempAlarmAckRequired = newProperty(0, true,null);
  
  /**
   * Get the <code>tempAlarmAckRequired</code> property.
   * @see appliance.BAlarmConfig#tempAlarmAckRequired
   */
  public boolean getTempAlarmAckRequired() { return getBoolean(tempAlarmAckRequired); }
  
  /**
   * Set the <code>tempAlarmAckRequired</code> property.
   * @see appliance.BAlarmConfig#tempAlarmAckRequired
   */
  public void setTempAlarmAckRequired(boolean v) { setBoolean(tempAlarmAckRequired,v,null); }

////////////////////////////////////////////////////////////////
// Property "equipAlarmEnabled"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>equipAlarmEnabled</code> property.
   * @see appliance.BAlarmConfig#getEquipAlarmEnabled
   * @see appliance.BAlarmConfig#setEquipAlarmEnabled
   */
  public static final Property equipAlarmEnabled = newProperty(0, true,null);
  
  /**
   * Get the <code>equipAlarmEnabled</code> property.
   * @see appliance.BAlarmConfig#equipAlarmEnabled
   */
  public boolean getEquipAlarmEnabled() { return getBoolean(equipAlarmEnabled); }
  
  /**
   * Set the <code>equipAlarmEnabled</code> property.
   * @see appliance.BAlarmConfig#equipAlarmEnabled
   */
  public void setEquipAlarmEnabled(boolean v) { setBoolean(equipAlarmEnabled,v,null); }

////////////////////////////////////////////////////////////////
// Property "eqiupAlarmAckRequired"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>eqiupAlarmAckRequired</code> property.
   * @see appliance.BAlarmConfig#getEqiupAlarmAckRequired
   * @see appliance.BAlarmConfig#setEqiupAlarmAckRequired
   */
  public static final Property eqiupAlarmAckRequired = newProperty(0, true,null);
  
  /**
   * Get the <code>eqiupAlarmAckRequired</code> property.
   * @see appliance.BAlarmConfig#eqiupAlarmAckRequired
   */
  public boolean getEqiupAlarmAckRequired() { return getBoolean(eqiupAlarmAckRequired); }
  
  /**
   * Set the <code>eqiupAlarmAckRequired</code> property.
   * @see appliance.BAlarmConfig#eqiupAlarmAckRequired
   */
  public void setEqiupAlarmAckRequired(boolean v) { setBoolean(eqiupAlarmAckRequired,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BAlarmConfig.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Object
////////////////////////////////////////////////////////////////

  public BIcon getIcon() { return icon; }
  private static final BIcon icon = BIcon.std("alarm.png");
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
}
