////////////////////////////////////////////////////////////////
// Login
////////////////////////////////////////////////////////////////

// the Login class includes XML messaging and error reporting code
// copied from hx:javax.baja.hx.hx.js - this code should eventually
// be refactored into common code, or at least kept in sync
// periodically
var login = new Login();

function Login()
{
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  this.ie = navigator.appName.toLowerCase() == "microsoft internet explorer";
  this.failure = false;

  // Error
  this.err_LostConnection   = "Session disconnected";
  this.errorInvokeCode      = null;
  this.lastException        = null;
  this.lastExceptionDetails = null;
  this.lastExceptionMessage = null;
  
  // Login
  this.nonce                = null;
  
  this.handleNonceResponse = function(resp)
  {
    login.nonce = resp.responseText;
  }
  
  function getCookie(c_name)
  {
    var i,x,y,ARRcookies=document.cookie.split(";");
    for (i=0;i<ARRcookies.length;i++)
    {
      x=ARRcookies[i].substr(0,ARRcookies[i].indexOf("="));
      y=ARRcookies[i].substr(ARRcookies[i].indexOf("=")+1);
      x=x.replace(/^\s+|\s+$/g,"");
      if (x==c_name)
      {
        return unescape(y);
      }
    }
  }
  
  this.doLogin = function()
  {
    var scheme   = document.getElementById("scheme").value;
    var username = document.getElementById("username").value;
    var password = document.getElementById("password").value;
    
    var cookieElement = document.getElementById("cookiePostfix");
    var cookiePostfix = "";
    if (cookieElement != null)
    	cookiePostfix = cookieElement.value;
    
    var absPathElement = document.getElementById("absPathBase");
    var absPathBase = "/";
    if (absPathElement != null)
    	absPathBase = absPathElement.value;
   
    var token;
   
    if (scheme == "cookieDigest") 
    {
		ScramSha256Client.authenticate(absPathBase, username, password,{
			ok: function(value){
				var reset = getCookie("niagara_login_state" + cookiePostfix);
				var uri = getCookie("niagara_uri" + cookiePostfix);
				if (uri != null && uri != "")
				{
					if (reset == null || reset != "3")
					{
						document.cookie = 'niagara_uri' + cookiePostfix +'=; path=/; expires=Thu, 01 Jan 1970 00:00:01 GMT;';
						document.cookie = 'niagara_login_state' + cookiePostfix +'=; path=/; expires=Thu, 01 Jan 1970 00:00:01 GMT;';
					}
					location.assign(absPathBase+uri.slice(1));
				}
				else{
					location.assign(absPathBase);
				}
			},
			fail: function(error){
				// here we need to fail
				document.cookie="niagara_login_state" + cookiePostfix + "=1";
				location.assign(absPathBase+"login");
			}
		});
    	return false;
    } 
    else
    {
    	token = base64encode(username + ":" + password);
    	document.getElementById("token").value = token;
   
	    // Nuke these textfields just in case a custom template
	    // assigned 'name' attributes, which would send these
	    // values over the wire in plain text 
	    document.getElementById("username").value = "";
	    document.getElementById("password").value = ""; 
	    return true;
    }
  }
  
  this.doResetPassword = function()
  {
    var scheme   = document.getElementById("scheme").value;
    var username = document.getElementById("username").value;
    var oldPassword = document.getElementById("password").value;
    var newPassword1 = document.getElementById("password1").value;
    var newPassword2 = document.getElementById("password2").value;
    
    var cookieElement = document.getElementById("cookiePostfix");
    var cookiePostfix = "";
    if (cookieElement != null)
    	cookiePostfix = cookieElement.value;
    
    var absPathElement = document.getElementById("absPathBase");
    var absPathBase = "/";
    if (absPathElement != null)
    	absPathBase = absPathElement.value;

   
    var token;
    var resetToken;
   
    if(newPassword1!=newPassword2)
    {
      alert('Passwords do not match.');
      return false;
    }

    if(oldPassword==newPassword1)
    {
      alert('Passwords must be changed.');
      return false;
    }
    
    // Nuke these textfields just in case a custom template
    // assigned 'name' attributes, which would send these
    // values over the wire in plain text 
    document.getElementById("username").value = "";
    document.getElementById("password").value = "";
    document.getElementById("password1").value = ""; 
    document.getElementById("password2").value = "";
    
    if (scheme == "cookieDigest") 
    {
      token = base64encode(username);
      resetToken =  "reset_" + base64encode(newPassword1);
      ScramSha256Client.authenticate(absPathBase, username, oldPassword,{
        ok: function(value)
        {
          var token = base64encode(username);
          var resetToken =  "reset_" + base64encode(newPassword1);
          document.getElementById("token").value = token;
          document.getElementById("resetToken").value = resetToken;
          document.forms[0].submit();
        },
        fail: function(error)
        {
          // here we need to fail
          location.assign(absPathBase+"login");
        }
      });
      
      return false;
    } 
    else
    {
      token = base64encode(username + ":" + oldPassword);
    }  
    resetToken =  "reset_" + base64encode(newPassword1);

    document.getElementById("token").value = token;
    document.getElementById("resetToken").value = resetToken;
   
     
    return true; 
  }
      
    

////////////////////////////////////////////////////////////////
// Error
////////////////////////////////////////////////////////////////

  /**
   * Handle error.
   */
  this.doError = function(msg, details, exception)
  {

 // Make sure exception is valid
    if (exception == null) exception = new Object();
    
 // ONLY EFFECTS MOZILLA BROWSERS 
 //   If an ajax request is currently being processed and the user
 //   attempts to navigate else where, then this error is thrown
 //   (Mozilla).
    if (exception.name == 'NS_ERROR_NOT_AVAILABLE') return;
   
    //Issue 13517 - hook for profile to try and handle the error more gracefully
    try
    {
      if(login.errorInvokeCode != null)
      {
        login.lastException=exception;
        login.lastExceptionDetails=details;
        login.lastExceptionMessage=msg;
        if(eval(login.errorInvokeCode))
          return;
      }
    }  
    catch(err)
    {
    
    }
    finally
    {
      login.lastException=null;          
      login.lastExceptionDetails=null;
      login.lastExceptionMessage=null;
    }
    
    var fileName = "undefined";
    var lineNumber = "undefined";
    var stack = "undefined";
    try
    {
      fileName = exception.fileName;
      lineNumber = exception.lineNumber;
      stack = exception.stack;
    }
    catch (err)
    {
      // If this throws an exception, we got one of those
      // internal exception things in Mozilla
      stack = exception;
    }

    // Default message if not set
    if (msg == null)
      msg = exception.name + ": " + exception.message;

    while (document.body.childNodes.length > 0)
      document.body.removeChild(document.body.firstChild);

    // Force style so we don't get anything weird
    var style = document.body.style;
    style.color = "black";
    style.background = "white";
    style.font = "normal 11px Tahoma";
    style.padding = "10px";

    var html = "<div style='font:18px Tahoma; padding-bottom:5px;'>";
    html += "Cannot display page</div>";
    html += msg + "<br/><br/>";
    html += "<div style='color:blue; cursor:pointer; text-decoration:underline;'";
    html += "onclick='document.getElementById(\"details\").";
    html += "style.visibility=\"visible\";'>";
    html += "Show Details</div>";
    html += "<div id='details' style='visibility:hidden; margin-top:10px;'>";

    // Exception information
    html += "<table width='100%' cellspacing='0' cellpadding='3'";
    html += " style='border:1px solid #666;'>";
    html += "<tr>";
    html += " <td colspan='2' style='background:#ccc;'>";
    html += "  <b>" + exception.name + ": " + exception.message + "</b>";
    html += " </td>";
    html += "</tr>";

    html += "<tr>";
    html += " <td style='background:#ddd;'><b>File:</b></td>";
    html += " <td width='100%' style='background:#eee;'>" + fileName + "</td>";
    html += "</tr>";

    html += "<tr>";
    html += " <td style='background:#ddd;'><b>Line:</b></td>";
    html += " <td style='background:#eee;'>" + lineNumber + "</td>";
    html += "</tr>";

    html += "<tr>";
    html += " <td valign='top' style='background:#ddd;'><b>Stack:</b></td>";
    html += " <td style='background:#eee;'>" + stack + "</td>";
    html += "</tr>";
    html += "</table>";

    // Details if they exist
    if (details != null && details.length > 0)
    {
      html += "<div style='margin-top:10px; padding:5px; background:#eee; ";
      html += "border:1px solid #666;'>";
      html += details;
      html += "</div>";
    }

    html += "</div>";
    document.body.innerHTML = html;
    login.failure = true;
  }
}



function hideAddressBar() {
  setTimeout(function () {
    window.scrollTo(0, 1);
  }, 100);
}

function init()
{
  hideAddressBar();
  document.getElementById("username").focus();
}

function doLogin(arg)
{
  return login.doLogin()
}


function isStrongPassword(arg, pwdStrength)
{
  if (arg.length < pwdStrength.minimumLength)
	  return false;
  
  if (arg.replace(/[^0-9]/g, "").length < pwdStrength.minimumDigits)
	  return false;

  if (arg.replace(/[^A-Z]/g, "").length < pwdStrength.minimumUpper)
	  return false;

  if (arg.replace(/[^a-z]/g, "").length < pwdStrength.minimumLower)
	  return false;
  
  if (arg.replace(/[^!.@$#*()%~<>{}\[\]+`\-_=+\\|;:'\"?,]/g, "").length < pwdStrength.minimumSpecial)
	  return false;
  
  return true;
}

function checkPasswords(pwdStrength) {
  var un = document.getElementById('username'),
      pw = document.getElementById('password'),
      pw1 = document.getElementById('password1'),
      pw2 = document.getElementById('password2'),
      submitButton = document.getElementById('submitButton'),
      absPathElement = document.getElementById("absPathBase"),

      unValue = un.value,
      pwValue = pw.value,
      pw1Value = pw1.value,
      pw2Value = pw2.value,
      absPathBase = "/",
      
      pw1pass,
      pw2pass;
  
  if (absPathElement != null)
    	absPathBase = absPathElement.value;
  
  var passImg = absPathBase + 'login/pass.png',
      failImg = absPathBase + 'login/fail.png';
      
  
  
  pw1pass = (pwValue !== pw1Value) && isStrongPassword(pw1Value, pwdStrength);
  pw2pass = pw1Value === pw2Value;
  
  pw1.style.backgroundImage = 'url(' + (pw1pass ? passImg : failImg) + ')';
  pw2.style.backgroundImage = 'url(' + (pw2pass ? passImg : failImg) + ')';
  
  submitButton.disabled = !pw1pass || !pw2pass || !unValue.length;
}

var encodeTable =
[
  'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H',
  'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q',
  'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
  'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h',
  'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q',
  'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
  '0', '1', '2', '3', '4', '5', '6', '7', '8',
  '9', '+', '/', '='
];

function base64encode(inp)
{
  var out = ""; //This is the output
  var chr1, chr2, chr3 = ""; //These are the 3 bytes to be encoded
  var enc1, enc2, enc3, enc4 = ""; //These are the 4 encoded bytes
  var i = 0; //Position counter
  
  //Set up the loop here
  do
  { 
    chr1 = inp.charCodeAt(i++); //Grab the first byte
    chr2 = inp.charCodeAt(i++); //Grab the second byte
    chr3 = inp.charCodeAt(i++); //Grab the third byte
    
    //Here is the actual base64 encode part.
    //There really is only one way to do it.
    enc1 = chr1 >> 2;
    enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
    enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
    enc4 = chr3 & 63;
    
    if (isNaN(chr2))
    {
      enc3 = enc4 = 64;
    }
    else if (isNaN(chr3))
    {
      enc4 = 64;
    }
  
    //Lets spit out the 4 encoded bytes
    out = out + encodeTable[enc1] + encodeTable[enc2] + encodeTable[enc3] + encodeTable[enc4];
  
    // OK, now clean out the variables used.
    chr1 = chr2 = chr3 = "";
    enc1 = enc2 = enc3 = enc4 = "";
  
  } while (i < inp.length); //And finish off the loop
  
  //Now return the encoded values.
  return out;
}


