/*
 * Copyright 2006 Tridium, Inc. All Rights Reserved.
 */
package foo;

import javax.baja.sys.*;
import javax.baja.ui.*;
import javax.baja.ui.pane.*;
import javax.baja.workbench.*;
import javax.baja.workbench.fieldeditor.*;
import javax.baja.workbench.view.*;
import chotchkie.*;

/**
 * BExampleView.
 *
 * @author    Andy Frank       
 * @creation  25 Apr 06
 * @version   $Revision$ $Date$
 * @since     Niagara 3.0
 */
public class BExampleView
  extends BWbView
{ 

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(BExampleView.class);
    
////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////
    
  public BExampleView() {}

////////////////////////////////////////////////////////////////
// BWbView
////////////////////////////////////////////////////////////////
  
  protected void doLoadValue(BObject value, Context cx)
  {
    BFlair flair = (BFlair)value;    
    name  = new BTextField(flair.getNickName());    
    level = BWbFieldEditor.makeFor(flair.getLevel());
    level.loadValue(flair.getLevel(), cx);
    
    BGridPane grid = new BGridPane(2);
    grid.add(null, new BLabel("Current Name:"));
    grid.add(null, name);
    grid.add(null, new BLabel("Current Level:"));
    grid.add(null, level);
    setContent(grid);
    
    linkTo(name, BTextField.textModified, setModified);
    linkTo(level, BWbFieldEditor.setModified, setModified);
  }    

  protected BObject doSaveValue(BObject value, Context cx)
    throws Exception
  {
    BFlair flair = (BFlair)value;
    
    String newName = name.getText();
    BFlairEnum newLevel = (BFlairEnum)level.saveValue(flair.getLevel(), cx);
        
    flair.setNickName(newName);
    flair.setLevel(newLevel);
    return value;
  }
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  private BTextField name;
  private BWbFieldEditor level;
}


