//=============================================================================
// common attributes (required)
//=============================================================================

font-families {
  sansserif: Tahoma, DejaVu Sans Condensed, DejaVu Sans, Nimbus Sans L, Arial;
  monospaced: Courier New, DejaVu Sans Mono;
}

font: 11pt sansserif;
bold-font: bold 11pt sansserif;
large-font: 16pt sansserif;
large-bold-font: bold 16pt sansserif;
fixed-font: 12pt monospaced;
fixed-bold-font: bold 12pt monospaced;

color: #000;
background-color: #ccc;
auxiliary-color: #999;
outline: #000;
highlight: #FFF;
shadow: #707070;

.disabled {
	color: #666;
	background-color: #ccc;
	outline: #666;
	highlight: #FFF;
	shadow: #999;
}

.readonly {
  background-color: #ccc;
}

focus-color: #0a246a;
selection-color: #fff;
selection-background-color: #669; 

//window-color and window-background-color included to keep legacy widgets happy
//wherever possible, please use color and background-color instead
window-color: #000;
window-background-color: #eee;

drop-ok-color: #fff;
drop-ok-background-color: #21a121;

//=============================================================================
// widget-specific attributes
//=============================================================================

//================================
//   BUTTON AND BUTTON TYPES
//================================
button {
	font:bold 11pt sansserif;
	
	color: #000;
	background-color: #ccc;
	outline: #000; 
	highlight: #FFF; 
	shadow: #707070;

	.disabled {
		color: #666;
		background-color: #ccc;
		outline: #666; 
		highlight: #FFF;
		shadow: #999;
	}
	
	padding: 5 13 5 13;				//default: 5 13 5 13
	toolbar-padding: 3 3 3 3;			//default: 3 3 3 3
	menu-width: 11; 					//default: 11
	
	checkbox {
		font: 11pt sansserif;
		padding: 2 2 2 18;			//default: 2 2 2 18
		size: 13;				//default: 13
	}
	
	radio {
		font: 11pt sansserif;
		padding: 2 2 2 18;			//default: 2 2 2 18
		
		.disabled {
			color: #666;
			outline: #666; 
			highlight: #FFF;
			shadow: #999;
		}
	}

	spinner {
		width:13;				//default: 13
	}

	//=============== end ============
	
	
	
	//================================
	//   TOOLBAR (TOP BAR)
	//================================
	.toolbar {
		background-color: none;//#ccc;
		selection-background-color: #999;
		outline: #000;
		highlight: #FFF; 
		shadow: #707070;
	}
}
//=============== end ============

console {
	background-color: #eee;
}

//================================
//   DROPDOWN
//================================

drop-down {
	padding: 2;					//default: 2
	color: #000;
	background-color: #eee;
	outline: #000; 
	highlight: #fff; 
	shadow: #707070;
	
	.disabled {
		background-color: #ccc;
	}



	button {
		color: #000;
		background-color: #ccc;
		outline: #000; 
		highlight: #FFF; 
		shadow: #707070
	}
}
//=============== end ============

label {
	font: 11pt sansserif;
	//color:#000; 						//default: control-color enabled color
	
  .strong {
    font: bold 11pt sansserif;
  }
  
  .large {
    font: 13pt sansserif;
  }
  
  .error {
    color: #a00;
  }
  
  .warning {
    color: #ce5e04;
  }
  
  .message {
    color: #090;
  }
  
  .trace {
    color: #666;
  }
  
  .hyperlink {
    color: #00f;
    font: underline 11pt sansserif;
  }
  
  .emphasized {
    font: italic 11pt sansserif;
  }
}

list {
	background-color: #eee;
	color: #000;
	.disabled {
	  background-color: #ccc;
	}
	selection-color: #fff;
	selection-background-color: #669; 
}


//================================
//   MENU AND MENU ITEMS (ICONS)
//================================
menu {
	background-color: #ccc;
	outline: #000; 
	highlight: #FFf; 
	shadow: #707070;
	
	padding: 3;						//default: 3
}

menu-bar {
	font: 11pt sansserif;
	item-padding: 2 7; 					//default: 2 7
	bar-padding: 1; 					//default: 1

	color: #000;
	background-color: #ccc;
	outline: #000; 
	highlight: #FFf; 
	shadow: #707070;
}

menu-item {
	font: 11pt sansserif;
	color: #000;
	background-color: #ccc;
	padding: 2 14 2 22; 				//default: 2 14 2 22
	icon-indent: 2; 					//default: 2
	
	.disabled {
		highlight: #fff;
		shadow: #666;
	}

	selection-color: #fff;
	selection-background-color: #669;
	
	accelerator {
		font: 10pt sansserif; 				//default: menu-item font -1 point
		color: #0a246a; 				//default: selection-color background
	}
}
//============= end ==============

pane {
  .errorPanel { background-color: white; }
	.toolbar-container { background-color: #ccc; }
	.sidebar-header { background-color: #ccc; }
	
	grid-pane {
      band-color: #bebebe;
    
		.scrolled {
		  band-color: #e2e2e2;
		}
	}
  
	//================================
	//   SCROLL PANE AND IS PIECES
	//================================
	scroll-pane {
		padding: 0;						//default: 0 (and you want it that way)
		background-color: #eee;
	}
	
	//================================
	//   SPLIT PANE AND IS PIECES
	//================================
	split-pane {
		divider {
			//split-pane divider does not use outline
			background-color: #ccc;
			highlight: #fff; 
			shadow: #707070;
		}
	}
	
	tabbed-pane {
		font: 11pt sansserif;
		color: #000;
		background-color: #999;
		outline: #000;
		highlight: #fff;
		shadow: #707070;
		
		.selected {
      background-color: #ccc;
		}
	}
	
	.title {
		color: #fff;
		font: bold 11pt sansserif;
		background-color: #707070;
	}
	
	//================================
	//   TOOL-PANE - nav, palette, etc.
	//================================
	tool-pane {
		outline: #000;
		header {
			color: white;
			background-color: #707070;
			font: bold 11pt sansserif;
			selection-color: white;
			selection-background-color: #669;
		}
	}
}

//================================
//   PATHBAR(BELOW MENUT BAR)
//================================
path-bar {
	font: 11pt sansserif;
	color: #fff;
	background-color: #707070;
	outline: #000; 
	highlight: #ccc; 
	shadow: #333;
}
//============== end =============

progress-bar {
  background-color: #eee;
  color: #669;
}


//================================
//   SCROLL BAR AND IS PIECES
//================================
scroll-bar {
	width:15; 						//default: 15
	button {
		color:#000;
		background-color:#ccc;
		outline:#000; 
		highlight:#fff; 
		shadow:#999;

		.disabled {
			color:#707070;
			background-color:#ccc;
			outline:#000; 
			highlight:#fff; 
			shadow:#999;
		}
	}
	thumb {
		background-color:#ccc;
		outline:#000; 
		highlight:#fff; 
		shadow:#707070;
	}
	track {
		background-color:#999;
		outline:#000; 
		highlight:#ccc; 
		shadow:#707070;
	}
}

//============== end =============

separator {
	width:2;							//default: 2
	width-menu:8;					//default: 8
	width-toolbar:8;					//default: 8

	highlight:#fff;
	shadow:#707070;
}

slider {
	thumb {
		width:11;
		background-color:#ccc;
		outline:#000; 
		highlight:#ccc; 
		shadow:#707070;
		
		.disabled {
			background-color:#ccc;
			outline:#707070; 
			highlight:#ccc; 
			shadow:#999;
		}
	}
	track {
		width:17;
		background-color:#999;
		outline:#000; 
		highlight:#ccc; 
		shadow:#707070;

		.disabled {
			background-color:#999;
			outline:#707070; 
			highlight:#ccc; 
			shadow:#999;
		}
	}
}



//================================
//   TABLES
//================================
table {
	font: 11pt sansserif;
	grid-color: #ccc;
	band-color: #dcdcdc;
	background-color: #eee;
	
	header {
		font:bold 11pt sansserif;
		background-color:#ccc;
		outline:#000; 
		highlight:#fff; 
		shadow:#999;
	}
	
	.cell-table { 
    selection-color: #000;
    selection-background-color: #c0c0ff; 
  }
	
	tree-table {
		background-color:#fff;
		expander {
			width:9;						//default: 9, looks goofy with even nums
			height:9;					//default: 9, looks goofy with even nums
		}
		
    .category-browser { band-color: #ffffbb; }
	}
}

//============== end =============

//================================
//   TEXT EDITOR
//================================
text-editor {
	fixed-font:12pt monospaced;			//default: font fixed normal
									                //MUST be monospaced!
	background-color: #eee;
}

text-field {
	padding:3;					//default: 3
}

//============== end =============

toolbar {
	padding:1;						//default: 1
	gap:2;						//default: 2
	scroll-speed: 80;			//default: 35
	background-color:#ccc;
}



//================================
//   TREE (TREE PANE)
//================================
tree {
	font:11pt sansserif;
	color:#000;
	background-color:#eee;
	padding:2 4;					//default: 2 4
	
	expander {
		color: #000;
		width: 9;					//default: 9, looks goofy with even nums
		height: 9;					//default: 9, looks goofy with even nums
	}
	
	connector-color: #ccc;
	
	property-sheet {
		background-color: #ccc;
		highlight: #fff; 
		shadow: #707070;
		
		divider {
			color: #bbb;
		}

		expander {
			color: #000;
			width: 9;				//default: 9, looks goofy with even nums
			height: 9;				//default: 9, looks goofy with even nums
		}
	}
}

wire-sheet {
	color: #ddd;
	background-color: #eee;
	outline: #000;
	
	glyph {
		background-color: #ccc;
		outline: #000;
		font: 9pt sansserif; 
		
		title {
			title { font: bold 9pt sansserif; }
			subtitle { font: 9pt sansserif; }
			color: #000;
			background-color: #ccc;
			.cut {
				color: #6e6e6e; 
				background-color: #32969696;
			}
		}
		
		selection-color: #f00;
		selection-background-color: #000;
		
		.cut {
			background-color: #32969696;
		}
	}
	
	thumbnail {
		color: #328e06c6;
		background-color: #d2e6e6e6;
		outline: #000;
	}
}

//============== end =============
