/*
 * Copyright $(year) $(vendor), All Rights Reserved.
 */

package $(package).util;

import java.io.*;

import javax.baja.net.Http;
import javax.baja.sys.*;

import com.tridium.driver.util.DrUtil;
import com.tridium.ndriver.comm.http.*;
import com.tridium.ndriver.datatypes.BIpAddress;

import com.tridium.videoDriver.enums.*;
import com.tridium.videoDriver.videoStream.*;

import $(package).*;
import $(package).camera.*;
$(if.network.hasDvrSupport)
import $(package).dvr.*;
$(end.network.hasDvrSupport)
import $(package).datatypes.*;

/**
 *  $(basePrefix)VideoStreamUtil contains example utilities to establish a video stream 
 *
 * @author   $(author)
 * @creation $(date)
 */
public class $(basePrefix)VideoStreamUtil
{
  public static void streamToDestination(B$(basePrefix)Camera cam, BPlaybackParams playbackParams, IVideoDestination videoDestination)
  {
    $(if.network.hasDvrSupport)
    // TODO - sample code only
    // camera is video source - get id from camera
    streamToDestination(cam.get$(basePrefix)Dvr(), getCameraNbr(cam), playbackParams, videoDestination);
    $(end.network.hasDvrSupport)
  }
  
  $(if.network.hasDvrSupport)
  public static void streamToDestination(B$(basePrefix)Dvr dvr, BPlaybackParams playbackParams, IVideoDestination videoDestination)
  {
    // TODO - sample code only
    // dvr is video source and camera id is not used 
    streamToDestination(dvr, -1, playbackParams, videoDestination);
  }
  
  static void streamToDestination(B$(basePrefix)Dvr dvr, int id, BPlaybackParams playbackParams, IVideoDestination videoDestination)
  {
    $(if.network.hasHttpCommConfig) 
    /*
     * Sample implementation of streaming
     * to an IVideoDestination from an HTTP source
     */ 
    try
    {
      
      BIpAddress addr = ((B$(basePrefix)IpAddress)dvr.getAddress()).httpAddress();
      HttpComm hcom = ((B$(basePrefix)Network)DrUtil.getParent(dvr, B$(basePrefix)Network.TYPE)).hcomm();
      
      // Send start
      String uri = makeUri(playbackParams);
      NHttpRequest rqst = new NHttpRequest(addr, Http.METHOD_GET, uri);
      //rqst.addBasicAuthorization(dvr.getCredentials().getUsername(), dvr.getCredentials().getPassword().getString());
      rqst.setUsernamePassword(dvr.getCredentials());
      NHttpStream hstream = hcom.openStream(rqst);
      
      // Add responseHeaders to playbackParams videoFacets
      BFacets f = HttpUtil.responseHeaderToFacets(hstream);
      f = BFacets.make(playbackParams.getVideoFacets(), f);
      playbackParams.setHttpRspHeader(f);
      
      // Create videoStream and pass to destination
      $(basePrefix)VideoSteam vs = new $(basePrefix)VideoSteam(playbackParams, hstream.getInputStream(), hstream);
      videoDestination.receiveVideoStream(vs);
     
    }
    catch(Exception e)
    {
      throw new BajaRuntimeException("Unable to establish stream",e);    
    }
    $(end.network.hasHttpCommConfig)
  }
  $(end.network.hasDvrSupport)
  
  static int getCameraNbr(B$(basePrefix)Camera cam)
  {
    // TODO - sample code only
    B$(basePrefix)CameraDeviceId deviceId = (B$(basePrefix)CameraDeviceId)cam.getVideoDeviceId();
    return deviceId.getCameraId();
  }
  
  
  static void addCommonParametersToUrl(StringBuffer urlBuffer,
                                        BPlaybackParams playbackParams)
  {
    // TODO - sample code only
    BVideoCompressionEnum compression = playbackParams.getCompression();
    
    if (compression == BVideoCompressionEnum.high)
    {      
      // Indicates the desired Mpeg4 profile to use
      urlBuffer.append("&res=").append(playbackParams.getResolution().getTag());
      
      // Indicates the desired video format (mp4 stands for "mpeg4")
      urlBuffer.append("&format=mp4");
    }
    else
    {
      // Indicates the desired resolution
      urlBuffer.append("&res=").append(playbackParams.getResolution().getTag());
      
      // Indicates the desired video format
      urlBuffer.append("&format=jfif");
    }
  }
 /**
   * Returns the URL to the video stream as an array of bytes.
   */
  static String makeUri(BPlaybackParams playbackParams)
  {
    // TODO - sample code only
    StringBuffer urlBuffer = new StringBuffer();

    // set frames per second - pps to 30
    urlBuffer.append("&pps=").append(30);

    // Adds any parameters to the url that are common to both live and stored video 
    addCommonParametersToUrl(urlBuffer, playbackParams);

    // Returns url string
    return urlBuffer.toString();
  }
  
  
  $(if.network.hasHttpCommConfig) 
  // Create custom VideoStream to allow override of close
  private static class $(basePrefix)VideoSteam
    extends VideoStream
  {
    $(basePrefix)VideoSteam(BPlaybackParams playbackParams, InputStream in, NHttpStream hstream)
    {
      super(playbackParams,in);
      this.hstream = hstream;
    }
    
    public void closeVideoStream()
      throws IOException
    {
      hstream.close();
    }

    NHttpStream hstream;
  }
  $(end.network.hasHttpCommConfig) 
}
