/*
 * Copyright $(year) $(vendor), All Rights Reserved.
 */

package $(package).util;

import java.util.StringTokenizer;

import javax.baja.net.Http;
import javax.baja.sys.*;
import javax.baja.util.*;

import com.tridium.driver.util.*;

import com.tridium.ndriver.comm.http.*;
import com.tridium.ndriver.datatypes.BIpAddress;

/**
 *  HttpUtil sample utility class using http messaging.
 *
 * @author   $(author)
 * @creation $(date)
 */
public class $(basePrefix)HttpUtil
{
  /* Example remove */
  public static void enableDetection(HttpComm hcom, BIpAddress addr, int cameraNo, boolean on)
    throws Exception
  {
      // TODO example only - remove
    int ndx = cameraNo - 1;
    boolean change = false;
    
    // Check if act_actions set correctly
    int[] actActions = getActActions(hcom, addr);
    int desired = on ? 1 : 0;
    if(actActions[ndx]!=desired)
    {
      actActions[ndx]=desired;
      change = true;
    }
    
    if(change)
    {
      String uri = "/vmd.frm?foo=" + "&act_actions[0]=" + StringUtil.toString(actActions);
      get(hcom,addr,uri);
    }
  }

  /** Get array of int flags indication actActions setting. 1=true 0=false  */
  public static int[] getActActions(HttpComm hcom, BIpAddress addr)
    throws Exception
  {
    // TODO - sample code only
    String uri = "/variable.cgi?variable=act_actions[]";
    NHttpResponse resp = get(hcom,addr,uri);
    String respString = new String(resp.getData());
    
    return StringUtil.getIntArray(respString);
  }
  
  /** Get camera titles */
  public static String[] getCameraTitles(HttpComm hcom, BIpAddress addr)
    throws Exception
  {
    // TODO - sample code only
    //
    // Example code to demostrate use of http stack and messages 
    // 
    
    String uri = "/variable.cgi?variable=c_title[]";
    NHttpResponse resp = get(hcom,addr,uri);

    // Allocates a dynamic String array
    Array cameraTitlesArray = new Array(String.class);

    // Allocates a tokenizer to traverse the httpReplyText by commas
    String respString = new String(resp.getData());
    StringTokenizer st = new StringTokenizer(respString, ",");
    while (st.hasMoreTokens())
    {
      // Gets name of next camera
      String nextCameraName = st.nextToken().trim();

      // Strips leading quote
      if (nextCameraName.startsWith("\""))
        nextCameraName = nextCameraName.substring(1);

      // Strips trailing quote
      if (nextCameraName.endsWith("\""))
        nextCameraName = nextCameraName.substring(0, nextCameraName.length()-1);

      cameraTitlesArray.add( nextCameraName );
    }

    // Converts cameraTitlesArray to pure String[] array and returns it
    return (String[])cameraTitlesArray.trim();
  }

  /** Get dvrs current time -  time in seconds since midnight Jan 1,1970 */
  public static long getCurrentTimeSec(HttpComm hcom, BIpAddress addr)
    throws Exception
  {
    // TODO - sample code only
    String uri = "/variable.cgi?variable=current_julian";
    NHttpResponse resp = get(hcom,addr,uri);
    byte[] dat = resp.getData();
    String httpReplyText = new String(dat, 0, dat.length);

    // Converts the httpReplyText long time
    long time = Long.parseLong(httpReplyText);

    return time;
  }
  
  /** Get dvrs current time -  time in seconds since midnight Jan 1,1970 */
  public static BAbsTime getCurrentAbsTime(HttpComm hcom, BIpAddress addr)
    throws Exception
  {
    // TODO - sample code only
    long tmSec = $(basePrefix)HttpUtil.getCurrentTimeSec(hcom, addr);
    // NOTE: Niagara AX BAbsTime is millis since midnight Jan 1, 1970...the Dvr's
    // time is seconds since midnight Jan 1, 1970 .
    return BAbsTime.make(tmSec * 1000);
  }

 
  public static NHttpResponse get(HttpComm hcom, BIpAddress addr, String uri)
    throws Exception
  {
    String meth  = Http.METHOD_GET;
    NHttpRequest rqst = new NHttpRequest(addr, meth, uri);
    return hcom.sendRequest(rqst);
  }
  
 
}
