/*
 * Copyright $(year) $(vendor), All Rights Reserved.
 */

package $(package);

import javax.baja.license.Feature;
import javax.baja.sys.*;
import javax.baja.util.Lexicon;

import com.tridium.ndriver.comm.*;
import com.tridium.ndriver.comm.http.*;
import com.tridium.ndriver.datatypes.*;
import com.tridium.ndriver.poll.*;
import com.tridium.nvideo.*;

$(if.network.hasDvrSupport)
import $(package).dvr.*;
$(end.network.hasDvrSupport)
import $(package).camera.*;


/**
 * $(network.class) models a network of video devices (DVRs or Cameras)
 * 
 * @author   $(author)
 * @creation $(date)
 *
 */
public class $(network.class) extends BVideoNetwork
{
  
  /*-
    class $(network.class)
    {
      properties
      {
        poll :  BNPollScheduler
          default {[ new BNPollScheduler() ]}
          
        $(if.network.hasHttpCommConfig)
        httpConfig : BHttpCommConfig
          default {[ new BHttpCommConfig(null) ]}
        $(end.network.hasHttpCommConfig)
        
        $(if.network.hasTcpCommConfig)
        tcpConfig : BTcpCommConfig
          default {[ new BTcpCommConfig(null) ]}
        $(end.network.hasTcpCommConfig)
        
        $(if.network.hasUdpCommConfig)
        udpConfig : BUdpCommConfig
          default {[ new BUdpCommConfig(null) ]}
        $(end.network.hasUdpCommConfig)
        
        $(if.network.hasSerialCommConfig)
        serialConfig : BSerialCommConfig
          default {[ new BSerialCommConfig() ]}
        $(end.network.hasSerialCommConfig)  
        
     }
    }
   -*/
  
  ////////////////////////////////////////////////////////////////
  // Property "poll"
  ////////////////////////////////////////////////////////////////
    
    /**
     * Slot for the <code>poll</code> property.
     * @see com.xvendor.nfoo.B$(basePrefix)Network#getPoll
     * @see com.xvendor.nfoo.B$(basePrefix)Network#setPoll
     */
    public static final Property poll = newProperty(0, new BNPollScheduler(),null);
    
    /**
     * Get the <code>poll</code> property.
     * @see com.xvendor.nfoo.B$(basePrefix)Network#poll
     */
    public BNPollScheduler getPoll() { return (BNPollScheduler)get(poll); }
    
    /**
     * Set the <code>poll</code> property.
     * @see com.xvendor.nfoo.B$(basePrefix)Network#poll
     */
    public void setPoll(BNPollScheduler v) { set(poll,v,null); }

  $(if.network.hasHttpCommConfig)  
  ////////////////////////////////////////////////////////////////
  // Property "httpConfig"
  ////////////////////////////////////////////////////////////////
    
    /**
     * Slot for the <code>httpConfig</code> property.
     * @see com.xvendor.nfoo.B$(basePrefix)Network#getHttpConfig
     * @see com.xvendor.nfoo.B$(basePrefix)Network#setHttpConfig
     */
    public static final Property httpConfig = newProperty(0, new BHttpCommConfig(null),null);
    
    /**
     * Get the <code>httpConfig</code> property.
     * @see com.xvendor.nfoo.B$(basePrefix)Network#httpConfig
     */
    public BHttpCommConfig getHttpConfig() { return (BHttpCommConfig)get(httpConfig); }
    
    /**
     * Set the <code>httpConfig</code> property.
     * @see com.xvendor.nfoo.B$(basePrefix)Network#httpConfig
     */
    public void setHttpConfig(BHttpCommConfig v) { set(httpConfig,v,null); }
  $(end.network.hasHttpCommConfig)  
  
  $(if.network.hasTcpCommConfig)
  ////////////////////////////////////////////////////////////////
  // Property "tcpConfig"
  ////////////////////////////////////////////////////////////////
    
    /**
     * Slot for the <code>tcpConfig</code> property.
     * @see com.xvendor.nfoo.B$(basePrefix)Network#getTcpConfig
     * @see com.xvendor.nfoo.B$(basePrefix)Network#setTcpConfig
     */
    public static final Property tcpConfig = newProperty(0, new BTcpCommConfig(null),null);
    
    /**
     * Get the <code>tcpConfig</code> property.
     * @see com.xvendor.nfoo.B$(basePrefix)Network#tcpConfig
     */
    public BTcpCommConfig getTcpConfig() { return (BTcpCommConfig)get(tcpConfig); }
    
    /**
     * Set the <code>tcpConfig</code> property.
     * @see com.xvendor.nfoo.B$(basePrefix)Network#tcpConfig
     */
    public void setTcpConfig(BTcpCommConfig v) { set(tcpConfig,v,null); }

   $(end.network.hasTcpCommConfig)
   
   $(if.network.hasUdpCommConfig)
  ////////////////////////////////////////////////////////////////
  // Property "udpConfig"
  ////////////////////////////////////////////////////////////////
    
    /**
     * Slot for the <code>udpConfig</code> property.
     * @see com.xvendor.nfoo.B$(basePrefix)Network#getUdpConfig
     * @see com.xvendor.nfoo.B$(basePrefix)Network#setUdpConfig
     */
    public static final Property udpConfig = newProperty(0, new BUdpCommConfig(null),null);
    
    /**
     * Get the <code>udpConfig</code> property.
     * @see com.xvendor.nfoo.B$(basePrefix)Network#udpConfig
     */
    public BUdpCommConfig getUdpConfig() { return (BUdpCommConfig)get(udpConfig); }
    
    /**
     * Set the <code>udpConfig</code> property.
     * @see com.xvendor.nfoo.B$(basePrefix)Network#udpConfig
     */
    public void setUdpConfig(BUdpCommConfig v) { set(udpConfig,v,null); }

  $(end.network.hasUdpCommConfig)
  
  $(if.network.hasSerialCommConfig)
  ////////////////////////////////////////////////////////////////
  // Property "serialConfig"
  ////////////////////////////////////////////////////////////////
    
    /**
     * Slot for the <code>serialConfig</code> property.
     * @see com.xvendor.nfoo.B$(basePrefix)Network#getSerialConfig
     * @see com.xvendor.nfoo.B$(basePrefix)Network#setSerialConfig
     */
    public static final Property serialConfig = newProperty(0, new BSerialCommConfig(),null);
    
    /**
     * Get the <code>serialConfig</code> property.
     * @see com.xvendor.nfoo.B$(basePrefix)Network#serialConfig
     */
    public BSerialCommConfig getSerialConfig() { return (BSerialCommConfig)get(serialConfig); }
    
    /**
     * Set the <code>serialConfig</code> property.
     * @see com.xvendor.nfoo.B$(basePrefix)Network#serialConfig
     */
    public void setSerialConfig(BSerialCommConfig v) { set(serialConfig,v,null); }
  $(end.network.hasSerialCommConfig)
  
  ////////////////////////////////////////////////////////////////
  // Type
  ////////////////////////////////////////////////////////////////
    
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType($(network.class).class);

  /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /** Specify name for network resources. */
  public String getNetworkName() { return "$(network.type)"; }

  /** return device folder type  $(network.class)DvrFolder */
  public Type getDeviceFolderType()
  {
    $(if.network.hasDvrDeviceFolder)
    return B$(basePrefix)DvrFolder.TYPE;
    $(end.network.hasDvrDeviceFolder)
    
    $(if.network.hasCameraDeviceFolder)
    return B$(basePrefix)CameraFolder.TYPE;
    $(end.network.hasCameraDeviceFolder)
  }

  /** return device type */
  public Type getDeviceType()
  {
    $(if.network.hasDvrSupport)
    return B$(basePrefix)Dvr.TYPE;
    $(end.network.hasDvrSupport)
    
    $(if.network.hasCameraSupport)
    return B$(basePrefix)Camera.TYPE;
    $(end.network.hasCameraSupport)
  }
  
  public final Feature getLicenseFeature()
  {
    BComplex netParent = getParent();
    
    // Checks if the parent is BRemoteVideoSource. Note that this is
    // done in a fashion that keeps this module from explicitly depending
    // on the remoteVideo module (by comparing on string instead of
    // using instanceof operator)
    if (netParent!=null &&
        netParent.getClass().getName().
        equals("com.tridium.remoteVideo.BRemoteVideoSource"))
    {
      return Sys.getLicenseManager().getFeature("xvendor", "remoteVideo");
    }    
    else
    {
      return Sys.getLicenseManager().getFeature("xvendor", "nfoo");
    }
  }
  
////////////////////////////////////////////////////////////////
//Utilities
////////////////////////////////////////////////////////////////
  
  $(if.network.hasHttpCommConfig)
  /** Access the http comm stack */
  public HttpComm hcomm() 
  {
    return (HttpComm)getHttpConfig().comm();
  }
  $(end.network.hasHttpCommConfig)
  
  $(if.network.hasTcpCommConfig)
  /**Access the tcp comm stack */
  public NComm tcomm()
  {
    return (NComm)getTcpConfig().comm();
  }
  $(end.network.hasTcpCommConfig)
  
   $(if.network.hasUdpCommConfig)
  /** Access the udp comm stack */
  public NComm ucomm() 
  {
    return (NComm)getUdpConfig().comm();
  }
  $(end.network.hasUdpCommConfig)
  
  $(if.network.hasSerialCommConfig)
   /**Access the serial comm stack */
  public NComm scomm()
  {
    return (NComm)getSerialConfig().comm();
  }
  $(end.network.hasSerialCommConfig)  
  
  public static Lexicon LEX = Lexicon.make($(network.class).class);
}
