/*
 * Copyright $(year) $(vendor), All Rights Reserved.
 */

package $(package).camera;

import javax.baja.alarm.*;
import javax.baja.driver.point.*;
import javax.baja.sys.*;
import javax.baja.naming.*;

import com.tridium.driver.util.DrUtil;
import com.tridium.ndriver.comm.*;
import com.tridium.ndriver.comm.http.*;
import com.tridium.ndriver.datatypes.*;
import com.tridium.ndriver.util.*;
import com.tridium.nvideo.camera.*;
import com.tridium.videoDriver.alarm.*;
import com.tridium.videoDriver.enums.*;
import com.tridium.videoDriver.event.*;
import com.tridium.videoDriver.videoStream.*;
import com.tridium.videoDriver.videoStream.decoder.*;

import $(package).*;
$(if.network.hasDvrSupport)
import $(package).dvr.*;
$(end.network.hasDvrSupport)
import $(package).event.*;
$(if.camera.hasPanTiltSupport)
import $(package).messages.*;
$(end.camera.hasPanTiltSupport)
$(if.camera.hasFocusSupport)
import $(package).messages.*;
$(end.camera.hasFocusSupport)
import $(package).util.*;
import $(package).datatypes.*;

/**
 * B$(basePrefix)Camera models a video camera
 *
 * @author   $(author)
 * @creation $(date)
 *
 */
public class B$(basePrefix)Camera
  extends BVideoCamera
  implements BIVideoAlarmRecorder, BIVideoEventProvider
{

  public static final BEnumRange defaultPreset = BEnumRange.make(  
                                                   new int[]{1,2,3,4,5,6,7,8,9}, 
                                                   new String[]{SlotPath.escape("$31"),
                                                                SlotPath.escape("$32"),
                                                                SlotPath.escape("$33"),
                                                                SlotPath.escape("$34"),
                                                                SlotPath.escape("$35"),
                                                                SlotPath.escape("$36"),
                                                                SlotPath.escape("$37"),
                                                                SlotPath.escape("$38"),
                                                                SlotPath.escape("$39")});
  
  /** Make default B$(basePrefix)CameraDeviceId */
  public static final Property videoDeviceId = newProperty(0, new B$(basePrefix)CameraDeviceId(),SfUtil.incl(SfUtil.MGR_EDIT));
  
  /** Override storePreset action definition to specify enum for input argument */
  public static final Action storePreset = newAction(Flags.ASYNC|Flags.HIDDEN,BDynamicEnum.make(0, defaultPreset),null);
  /** Override moveToPreset action definition to specify enum for input argument */
  public static final Action moveToPreset = newAction(Flags.ASYNC|Flags.HIDDEN,BDynamicEnum.make(0, defaultPreset),null);
  
  private static BFacets sf = BFacets.make(BFacets.MIN,  BInteger.make(0),
                                           BFacets.MAX,  BInteger.make(15)); 
 
  /*-
   class B$(basePrefix)Camera
   {
     properties
     { 
       -- TODO example property showing use of SfUtil to include property in device manager view
       fastSpeed : int
         -- Defines exactly how fast is a 'fast' pan or tilt
         default{[10]}
         slotfacets{[ SfUtil.incl(SfUtil.MGR_EDIT_UNSEEN,sf) ]}
                        
       events : BPointDeviceExt
         -- Manages the events that the $(basePrefix) Camera may report to Niagara
         default {[ new B$(basePrefix)EventCameraExt() ]}
         
       eventRecaller :  BVideoEventRecall
         -- Manages list of events that are available for video playback
         flags{transient,hidden}
         default {[ new B$(basePrefix)VideoEventRecall() ]}
     }
     actions
     {
     }
   }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
/*@ $com.xvendor.$(basePrefix).camera.B$(basePrefix)Camera(2767960717)1.0$ @*/
/* Generated Fri Jun 29 12:39:35 EDT 2012 by Slot-o-Matic 2000 (c) Tridium, Inc. 2000 */

////////////////////////////////////////////////////////////////
// Property "fastSpeed"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>fastSpeed</code> property.
   * Defines exactly how fast is a 'fast' pan or tilt
   * @see com.xvendor.$(basePrefix).camera.B$(basePrefix)Camera#getFastSpeed
   * @see com.xvendor.$(basePrefix).camera.B$(basePrefix)Camera#setFastSpeed
   */
  public static final Property fastSpeed = newProperty(0, 10,SfUtil.incl(SfUtil.MGR_EDIT_UNSEEN,sf));
  
  /**
   * Get the <code>fastSpeed</code> property.
   * Defines exactly how fast is a 'fast' pan or tilt
   * @see com.xvendor.$(basePrefix).camera.B$(basePrefix)Camera#fastSpeed
   */
  public int getFastSpeed() { return getInt(fastSpeed); }
  
  /**
   * Set the <code>fastSpeed</code> property.
   * Defines exactly how fast is a 'fast' pan or tilt
   * @see com.xvendor.$(basePrefix).camera.B$(basePrefix)Camera#fastSpeed
   */
  public void setFastSpeed(int v) { setInt(fastSpeed,v,null); }

////////////////////////////////////////////////////////////////
// Property "events"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>events</code> property.
   * Manages the events that the $(basePrefix) Camera may report
   * to Niagara
   * @see com.xvendor.$(basePrefix).camera.B$(basePrefix)Camera#getEvents
   * @see com.xvendor.$(basePrefix).camera.B$(basePrefix)Camera#setEvents
   */
  public static final Property events = newProperty(0, new B$(basePrefix)EventCameraExt(),null);
  
  /**
   * Get the <code>events</code> property.
   * Manages the events that the $(basePrefix) Camera may report
   * to Niagara
   * @see com.xvendor.$(basePrefix).camera.B$(basePrefix)Camera#events
   */
  public BPointDeviceExt getEvents() { return (BPointDeviceExt)get(events); }
  
  /**
   * Set the <code>events</code> property.
   * Manages the events that the $(basePrefix) Camera may report
   * to Niagara
   * @see com.xvendor.$(basePrefix).camera.B$(basePrefix)Camera#events
   */
  public void setEvents(BPointDeviceExt v) { set(events,v,null); }

////////////////////////////////////////////////////////////////
// Property "eventRecaller"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>eventRecaller</code> property.
   * Manages list of events that are available for video
   * playback
   * @see com.xvendor.$(basePrefix).camera.B$(basePrefix)Camera#getEventRecaller
   * @see com.xvendor.$(basePrefix).camera.B$(basePrefix)Camera#setEventRecaller
   */
  public static final Property eventRecaller = newProperty(Flags.TRANSIENT|Flags.HIDDEN, new B$(basePrefix)VideoEventRecall(),null);
  
  /**
   * Get the <code>eventRecaller</code> property.
   * Manages list of events that are available for video
   * playback
   * @see com.xvendor.$(basePrefix).camera.B$(basePrefix)Camera#eventRecaller
   */
  public BVideoEventRecall getEventRecaller() { return (BVideoEventRecall)get(eventRecaller); }
  
  /**
   * Set the <code>eventRecaller</code> property.
   * Manages list of events that are available for video
   * playback
   * @see com.xvendor.$(basePrefix).camera.B$(basePrefix)Camera#eventRecaller
   */
  public void setEventRecaller(BVideoEventRecall v) { set(eventRecaller,v,null); }

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType(B$(basePrefix)Camera.class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
  /** Do nothing as ping is handled by dvr*/
  public void doPing() throws Exception {}
  
////////////////////////////////////////////////////////////////
// BNDevice
////////////////////////////////////////////////////////////////
  
  public Type getNetworkType()
  {
    return B$(basePrefix)Network.TYPE;
  }
  
////////////////////////////////////////////////////////////////
// BVideoCamera
////////////////////////////////////////////////////////////////
  /**
   * Gets the Action slot for the 'moveToPreset' action on
   * the BIVideoCamera or other entity that implements this
   * interface
   */
  public Action getMoveToPresetAction()
  {
    return moveToPreset;
  }
  
  /**
   * Gets the Action slot for the 'storePreset' action on
   * the BIVideoCamera or other entity that implements this
   * interface
   */
  public Action getStorePresetAction()
  {
    return storePreset;
  } 
  
  public  BAbsTime getCameraTime()
  {
    try
    {
      
      // TODO example code only - replace with code to get camera's current time
      $(if.network.hasHttpCommConfig)  
      //Uncomment the code below for an implementation of getCameraTime() using
      //an HTTP comm
      
      //return $(basePrefix)HttpUtil.getCurrentAbsTime(hcomm(), httpAddress());
      $(end.network.hasHttpCommConfig)
      
      //Replace this line with your custom implementation for retrieving camera time
      return BAbsTime.now();
    } 
    catch (Exception e)
    {
      return null;
    }
  }
  
  $(if.camera.hasPanTiltSupport)
  /** Send move command to camera. */
  public void onMove(BVideoPanTiltEnum panTiltAction)
  {
    $(if.network.hasUdpCommConfig)
    // TODO example code only - add code to move camera
    udpSend(new $(basePrefix)PanTiltReq(this, panTiltAction));
    $(end.network.hasUdpCommConfig)
  }
  $(end.camera.hasPanTiltSupport)
  $(if.camera.hasFocusSupport)
  /** Send focus command to camera. */
  public void onFocusControl(BVideoFocusEnum focusEnum)
  {
    // TODO add code to send focusControl
  }
  $(end.camera.hasFocusSupport)
  $(if.camera.hasIrisSupport)
  /** Send irisControl command to camera. */
  public void onIrisControl(BVideoIrisEnum irisEnum)
  {
    // TODO add code to send irisControl
  }
  $(end.camera.hasIrisSupport)
  $(if.camera.hasZoomSupport)
  /** Send zoom command to camera. */
  public void onZoom(BVideoZoomEnum zoomAction)
  {
    // TODO add code to send zoom command
  }
  $(end.camera.hasZoomSupport)
  $(if.camera.hasMoveToPresetSupport)
  /** Send moveToPreset command to camera. */
  public void doMoveToPreset(BValue presetPosition)
  {
    // TODO add code to send move camera to preset
  }
  $(end.camera.hasMoveToPresetSupport)
  $(if.camera.hasStorePresetsSupport)
  /** Send storePreset command to camera. */
  public void doStorePreset(BValue presetPosition)
  {
    // TODO add code to store preset 
  }
  $(end.camera.hasStorePresetsSupport)

////////////////////////////////////////////////////////////////
// BIVideoAlarmRecorder
////////////////////////////////////////////////////////////////

  public void startRecordingAlarm(BAlarmRecord alarmRecord)
  {
    // TODO  add code to command device to start recordin
  }
   
////////////////////////////////////////////////////////////////
// BIVideoSource
////////////////////////////////////////////////////////////////

  public IVideoDecoder makeVideoDecoder(BPlaybackParams playbackParams)
  {
    // TODO return custom VideoDecoder for this camera
    return new $(basePrefix)VideoDecoder();
  }
  
  
  public void streamToDestination(BPlaybackParams playbackParams, IVideoDestination videoDestination)
  {
    // TODO add code to initiate video stream

    // TODO sample code only - remove
    $(basePrefix)VideoStreamUtil.streamToDestination(this, playbackParams, videoDestination);
  }
  
  /**
   * NOTE: This method is called on the client-side.
   */
  public void initPlaybackParams(BPlaybackParams playbackParams, IVideoSession videoSession)
  {
   // TODO 
       
  } 
  
////////////////////////////////////////////////////////////////
// Utilities
////////////////////////////////////////////////////////////////
  
  //
  // Example utilities
  //
  $(if.network.hasHttpCommConfig)  
  /** Convenience method to get camera's http address */
  public BIpAddress httpAddress()
  {
    $(if.network.hasDvrSupport)
    B$(basePrefix)Dvr dvr = (B$(basePrefix)Dvr)getDvr();
    return dvr.httpAddress();
    $(end.network.hasDvrSupport)
    $(if.network.hasCameraSupport)
    return new B$(basePrefix)IpAddress().httpAddress();
    $(end.network.hasCameraSupport)
    
  }
  $(end.network.hasHttpCommConfig)
  
   $(if.network.hasUdpCommConfig)
  /** Convenience method to get camera's udp address */
  public BIpAddress udpAddress()
  {
    $(if.network.hasDvrSupport)
    B$(basePrefix)Dvr dvr = (B$(basePrefix)Dvr)getDvr();
    return dvr.udpAddress();
    $(end.network.hasDvrSupport)
    $(if.network.hasCameraSupport)
    return new B$(basePrefix)IpAddress().udpAddress();
    $(end.network.hasCameraSupport)
  }
  $(end.network.hasUdpCommConfig)
  
  $(if.network.hasDvrSupport)
  /**
   * Gets the B$(basePrefix)Dvr that this camera resides under in the
   * station.
   */
  public B$(basePrefix)Dvr get$(basePrefix)Dvr()
  {
    return (B$(basePrefix)Dvr)DrUtil.getParent(this, B$(basePrefix)Dvr.TYPE);
  }
  $(end.network.hasDvrSupport)  
  
  $(if.network.hasHttpCommConfig)
  /** Convenience method to access http comm stack */
  public HttpComm hcomm() throws Exception
  {
   return ((B$(basePrefix)Network)vnetwork()).hcomm();
  }
  $(end.network.hasHttpCommConfig)
  
  $(if.network.hasUdpCommConfig)
  /** Convenience method to access udp comm stack */
  public NComm ucomm() throws Exception
  {
   return ((B$(basePrefix)Network)vnetwork()).ucomm();
  }
  
  /** Send a udp message. */
  public void udpSend(NMessage req)
  {
    try
    {
      req.setAddress(udpAddress());
      ucomm().sendMessage(req);
    } 
    catch (Exception e)
    {
      // Turn exceptions into baja runtime
      throw new BajaRuntimeException(e);
    }
  }
  $(end.network.hasUdpCommConfig) 
}
