/**
 * Copyright $(year) $(vendor), Inc. All Rights Reserved.
 */
package $(package).point;

import javax.baja.sys.*;
$(if.notAutoPointDiscover)
import javax.baja.driver.point.BPointDeviceExt;
$(end.notAutoPointDiscover)
$(if.autoPointDiscover)
import com.tridium.ndriver.discover.*;
import com.tridium.ndriver.point.*;
$(end.autoPointDiscover)

import $(package).*;

/**
 * $(pointDeviceExt.class) is a container for $(moduleName) proxy points for.
 *
 * @author   $(author)
 * @creation $(date) 
 */
public class $(pointDeviceExt.class)
$(if.notAutoPointDiscover)
  extends BPointDeviceExt 
{            
$(end.notAutoPointDiscover)
$(if.autoPointDiscover)
  extends BNPointDeviceExt 
{            
  public static final Property discoveryPreferences = newProperty(0, new B$(basePrefix)PointDiscoveryPreferences(),null);
$(end.autoPointDiscover)

  /*-
    class $(pointDeviceExt.class)
    {
      properties
      {
      }
    }
   -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType($(pointDeviceExt.class).class); 

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////
  
  /**
   * Get the network cast to a $(network.class).
   * @return network as a $(network.class).
   */
  public final $(network.class) get$(network.type)()
  {
    return ($(network.class))getNetwork();
  }

  /**
   * Get the device cast to a $(device.class).
   * @return device as a $(device.class).
   */
  public final $(device.class) get$(device.type)()
  {
    return ($(device.class))getDevice();
  }

////////////////////////////////////////////////////////////////
// PointDeviceExt
////////////////////////////////////////////////////////////////
  
  /**
   * @return the Device type.
   */
  public Type getDeviceType()
  {
    return $(device.class).TYPE;
  }

  /**
   * @return the PointFolder type.
   */
  public Type getPointFolderType()
  {
    return $(pointFolder.class).TYPE;
  }
  
  /**
   * @return the ProxyExt type.
   */
  public Type getProxyExtType()
  {
    return $(proxyExt.class).TYPE;
  }
  
$(if.autoPointDiscover)
////////////////////////////////////////////////////////////////
//BINDiscoveryHost
////////////////////////////////////////////////////////////////

  /** Call back for discoveryJob to get an array of discovery objects.
   *  Override point for driver specific discovery. */
  public BINDiscoveryObject[] getDiscoveryObjects(BNDiscoveryPreferences prefs) 
      throws Exception
  {
     //
     // TODO  get array of discovery objects
     //
//    Array a = new Array(??.class);
//    for(??)
//     a.add(new B$(basePrefix)PointDiscoveryLeaf(??));
//    return (??[])a.trim();
    return null;
  }
$(end.autoPointDiscover)
}
