/*
 * Copyright $(year) $(vendor), All Rights Reserved.
 */

package $(package).ui;

import javax.baja.sys.*;
import javax.baja.util.*;
import javax.baja.gx.*;
import javax.baja.ui.*;
import javax.baja.job.*;
import javax.baja.driver.*;
import javax.baja.driver.ui.device.*;
import javax.baja.workbench.mgr.*;
import javax.baja.workbench.mgr.folder.*;
import com.tridium.util.ArrayUtil;
import $(package).*;
$(if.deviceManagerLearn)
import $(package).learn.*;
$(end.deviceManagerLearn)

/**
 * $(deviceManager.class) provides the user interface to manage 
 * $(moduleName) devices on a single network.
 *
 * @author    $(author)
 * @creation  $(date)
 */
public class $(deviceManager.class)
  extends BDeviceManager
{ 
  /*-
  class $(deviceManager.class)
  {
    properties
    {
    }
  }
 -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////

  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType($(deviceManager.class).class);  

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  public $(deviceManager.class)()
  {
  }


$(if.deviceManagerLearn)
  /**
   * Gets ancestor network object.
   */
  public $(network.class) getNetwork()
  {
    BObject owner = getCurrentValue();
    if (owner instanceof $(deviceFolder.class))
      return ($(network.class))(($(deviceFolder.class))owner).getNetwork();
    else if (owner instanceof $(network.class))
      return ($(network.class))owner;
    else
      return null;
  }

  public void doLoadValue(BObject obj, Context cx)
  {
     super.doLoadValue(obj,cx);
     // Sets the discovery data from the pan table entries
     updateLearnData();
  }

  /**
   * This method is called by the doLoadValue method and when the learn job completes.
   */
  void updateLearnData()
  {
    $(learnDevicesJob.class) learnJob = ($(learnDevicesJob.class))getLearn().getJob();
    if(learnJob != null)
      getLearn().updateRoots(learnJob.getLearnedDevices().getChildren($(learnDeviceEntry.class).class) );
  }

  public $(device.class)[] getSelectedDevices()
  {
    if(getModel()==null || getModel().getTable()==null)
    {
      return new $(device.class)[0];
    }
    else
    {
      BComponent[] selection = getModel().getTable().getSelectedComponents();
      $(device.class)[] devices = new $(device.class)[0];
      for (int i=0; i<selection.length; i++)
        if (selection[i].getType().is($(device.class).TYPE))
          devices=($(device.class)[])ArrayUtil.addOne(devices,($(device.class))selection[i]);
      return devices;
    }
  }

$(end.deviceManagerLearn)

  
////////////////////////////////////////////////////////////////
// Support
////////////////////////////////////////////////////////////////

  protected MgrModel makeModel() { return new Model(this); }
  protected MgrController makeController() { return new Controller(this); }
$(if.deviceManagerLearn)
  protected MgrLearn makeLearn() { return new Learn(this); }
$(end.deviceManagerLearn)
                                        
////////////////////////////////////////////////////////////////
// Model
////////////////////////////////////////////////////////////////
  
  class Model extends DeviceModel
  {
    Model(BDeviceManager manager) { super(manager); }
    
    protected MgrColumn[] makeColumns()
    {        
      return cols;   
    }                                   
  }                                 
                               
$(if.deviceManagerLearn)
/////////////////////////////////////////////////////////////
// Learn
//////////////////////////////////////////////////////////////
  /**
   * Override of base learn support object
   */
  class Learn
    extends MgrLearn
  {
    Learn(BDeviceManager manager) { super(manager); }

    /**
     * This is method is called to initialize the 
     * columns used for the discovery table.
     */
    protected MgrColumn[] makeColumns()
    {
      return new MgrColumn[]{
          //
          // TODO - add discovery column entries
          //
      };
    }

    public BImage getIcon(Object dis)
    {
      return stationIcon;
    }

    public MgrTypeInfo[] toTypes(Object discovery)
    {
      return MgrTypeInfo.makeArray( getNetwork().getDeviceType());
    }

    public void toRow(Object discovery, MgrEditRow row)
    {
      $(learnDeviceEntry.class) learnEntry = ($(learnDeviceEntry.class))discovery;
      //
      // TODO - add code to make changes to row based on discovery object
      //
    }
    /**
     * Allows the core to ask us if a discovered item is equivalent
     * to a given pre-existing item.
     */
    public boolean isExisting(Object dis, BComponent comp)
    {
      $(learnDeviceEntry.class) learnEntry = ($(learnDeviceEntry.class))dis;
      $(device.class) d = ($(device.class))comp;
      
      //
      // TODO - add code to check if learnEntry is for specified device
      //
      
      return false;
    }
    /**
     * This callback is automatically invoked when the
     * current job set via <code>setJob()</code> completes.
     */
    public void jobComplete(BJob job)
    {
      super.jobComplete(job);
      if (job instanceof $(learnDevicesJob.class))
      {
        updateLearnData();
      }
    }
  }
$(end.deviceManagerLearn)

////////////////////////////////////////////////////////////////
// Controller
////////////////////////////////////////////////////////////////

  class Controller extends DeviceController
  {             
    Controller(BDeviceManager mgr) { super(mgr); }
  }                 
                         
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  static Lexicon lex = Lexicon.make($(deviceManager.class).class); 
  static BImage stationIcon = BImage.make("module://icons/x16/device.png");
  
  // base class columns
  MgrColumn colName         = new MgrColumn.Name();
  MgrColumn colType         = new MgrColumn.Type();
  MgrColumn colDeviceExts   = new DeviceExtsColumn(new $(device.class)());
  MgrColumn colStatus       = new MgrColumn.Prop(BDevice.status);
  MgrColumn colEnabled      = new MgrColumn.Prop(BDevice.enabled, MgrColumn.EDITABLE | MgrColumn.UNSEEN);
  MgrColumn colHealth       = new MgrColumn.Prop(BDevice.health, 0);
  
  // $(device.type) specific columns
  // TODO - add custom colums definitions and include in cols[]
  
  MgrColumn[] cols = 
  { 
    colName, colType, colDeviceExts,
    colStatus, colEnabled, colHealth, 
  };
  
}
