/**
 * Copyright $(year) $(vendor), Inc. All Rights Reserved.
 */
package $(package);

import javax.baja.driver.util.BPollFrequency;
import javax.baja.status.BStatus;
import javax.baja.sys.*;

import com.tridium.ndriver.BNDevice;
import com.tridium.ndriver.poll.BINPollable;
import com.tridium.ndriver.util.SfUtil;

$(if.points)
import $(package).point.*;
$(end.points)


/**
 *  $(device.class) models a single device
 *
 *  @author   $(author)
 *  @creation $(date) 
 */
public class $(device.class)
  extends BNDevice
  implements BINPollable
{
  
  // Add facet to include following in auto manager view
  public static final Property status = newProperty(Flags.TRANSIENT|Flags.READONLY|Flags.SUMMARY|Flags.DEFAULT_ON_CLONE, BStatus.ok, SfUtil.incl(SfUtil.MGR_EDIT_READONLY));

  /*-
  class $(device.class)
  {
    properties
    {
      pollFrequency : BPollFrequency
        --How frequently the device is polled for data
        default {[ BPollFrequency.normal ]}
       
$(if.points)
      points : $(pointDeviceExt.class)
        default {[ new $(pointDeviceExt.class)() ]}
$(end.points)
      
    }
    actions
    {

    }
    topics
    {
      
    }
  }
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/

////////////////////////////////////////////////////////////////
// Property "pollFrequency"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>pollFrequency</code> property.
   * How frequently the device is polled for data
   * @see $(package).$(device.class)#getPollFrequency
   * @see $(package).$(device.class)#setPollFrequency
   */
  public static final Property pollFrequency = newProperty(0, BPollFrequency.normal,null);
  
  /**
   * Get the <code>pollFrequency</code> property.
   * How frequently the device is polled for data
   * @see $(package).$(device.class)#pollFrequency
   */
  public BPollFrequency getPollFrequency() { return (BPollFrequency)get(pollFrequency); }
  
  /**
   * Set the <code>pollFrequency</code> property.
   * How frequently the device is polled for data
   * @see $(package).$(device.class)#pollFrequency
   */
  public void setPollFrequency(BPollFrequency v) { set(pollFrequency,v,null); }

$(if.points)
////////////////////////////////////////////////////////////////
// Property "points"
////////////////////////////////////////////////////////////////
  
  /**
   * Slot for the <code>points</code> property.
   * @see $(package).$(device.class)#getPoints
   * @see $(package).$(device.class)#setPoints
   */
  public static final Property points = newProperty(0, new $(pointDeviceExt.class)(),null);
  
  /**
   * Get the <code>points</code> property.
   * @see $(package).$(device.class)#points
   */
  public $(pointDeviceExt.class) getPoints() { return ($(pointDeviceExt.class))get(points); }
  
  /**
   * Set the <code>points</code> property.
   * @see $(package).$(device.class)#points
   */
  public void setPoints($(pointDeviceExt.class) v) { set(points,v,null); }

$(end.points)

////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType($(device.class).class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
  
  
////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////
  
  /**
   * Returns the network type that the device runs on.
   * @return Type object representing the network
   */
  public Type getNetworkType() { return $(network.class).TYPE; }  
  
  
  /**
   * Override started 
   */
  public void started()
    throws Exception
  {
    super.started();
    
    // register device with poll scheduler 
    get$(network.type)().getPollScheduler().subscribe(this);
  }
  
  /**
   * Override stopped 
   */
  public void stopped()
    throws Exception
  {
    // unregister device with poll scheduler 
    get$(network.type)().getPollScheduler().unsubscribe(this);
    super.stopped();
  }
  
  
////////////////////////////////////////////////////////////////
// Implementation
////////////////////////////////////////////////////////////////
  /**
   * 
   */
  public void doPing() 
  { 
    // TODO - add ping implementation
    // if()
      pingOk();
    // else
    //  pingFail("not receiving response from device ");
  }
  

////////////////////////////////////////////////////////////////
// Polling support
////////////////////////////////////////////////////////////////

  /**
   * The poll() callback method called from BPollScheduler
   * when it is time to poll this object.
   */
  public void doPoll()
  {
    // TODO add poll support
  }
  
////////////////////////////////////////////////////////////////
// Utilities
////////////////////////////////////////////////////////////////
  /**
   * Get the network cast to a $(network.class).
   * @return network as a $(network.class).
   */
  public final $(network.class) get$(network.type)()
  {
    return ($(network.class))getNetwork();
  }


  
}
