/*
 * Copyright $(year) $(vendor), All Rights Reserved.
 */
package $(package).comm.req;

import javax.baja.sys.*;
import javax.baja.io.*;

import com.tridium.ddf.comm.*;
import com.tridium.ddf.comm.req.*;
import com.tridium.ddf.comm.rsp.*;

$(if.noDeviceMessage)
import com.tridium.ddf.discover.*;
import com.tridium.ddf.identify.*;
$(end.noDeviceMessage)

import $(package).identify.*;
import $(package).comm.rsp.*;
import $(package).identify.*;

public class B$(driverName)ReadRequest
  extends BDdfReadRequest
  $(if.noDeviceMessage)   
  implements BIDdfDiscoverRequest
  $(end.noDeviceMessage)
{
  /*-
  class B$(driverName)ReadRequest
  {
    $(if.noDeviceMessage)
    properties
    {
      discoverParameters : BDdfIdParams
         -- This provides the necessary data that the toByteArray method
         -- Needs in order to construct the byte array. Since this class
         -- Is the read request and also serves as the discovery request,
         -- Then this property's value will be a copy of the value of the
         -- Read Parameters property.
        default{[new B$(driverName)ReadParams()]}  
    }
    $(end.noDeviceMessage)
  }
  -*/

  public byte[] toByteArray()
  {
    // In the developer driver framework, all requests are automatically
    // assigned a deviceId when they are created. The developer driver
    // framework calls this method (function) after it creates the
    // request, therefore this particular request has already been
    // assigned a deviceId. The deviceId will be an instance of
    // B$(driverName)DeviceId - that is how the developer driver works!
    B$(driverName)DeviceId deviceId =
      (B$(driverName)DeviceId)getDeviceId();
    
    // Likewise, all read requests are automatically assigned a read
    // parameters structure. The readParameters will be an instance of
    // B$(driverName)ReadParams - that is how the developer driver
    // works!
    B$(driverName)ReadParams readParams
      = (B$(driverName)ReadParams)getReadParameters();
    
    // TODO: Construct a byte array or a byte array output stream to
    // construct the byte array that this method will return. Use the
    // data in both the 'deviceId' and the 'readParams' to initialize
    // the byte array or byte array output stream. The deviceId should
    // have all data necessary to identify the particular field-device.
    // The readParams should have all data necessary to identify which
    // point(s) to read within the field-device.
    
    // NOTE: All IDdfReadables (driver proxy points) that share the same
    // Read parameters structure will typically be automatically grouped
    // into a single request. Therefore, this request might retrieve
    // the values for multiple proxy points **if** the $(driverName)
    // protocol supports retrieving multiple data point values in a single
    // request-response transaction.
    
    // TODO: Return a byte array...good luck.
    return null;
  }

  /**
   * After transmitting this request, the BDdfCommunicator will pass frames that it receives
   * here. If you implement the getTag method then the ddf communicator will only pass data frames
   * whose tag's hashcode matches your request tag's hashcode. If your request returns null from
   * the getTag method then all received data frames will be passed here, until the request times
   * out or returns a BIDdfResponse from this method.
   *
   *  This request needs to take one of the following steps:
   *   1. NOT TYPICAL: Ignore the frame and return null.
   *   2. NOT TYPICAL: Collect the frame and return a BIDdfMultiFrameResponse. In which case, you need to implement your own collection
   *      mechanism. For example, this could be as simple as putting them all in a Vector in the BIDdfMultiFrameResponse.
   *   3. TYPICAL: Return a BIDdfResponse for the data frame and NOT TYPICAL:> any previously collected frames that you determine together make up a completed response.
   *   4. TYPICAL: Throw an DdfResponseException or subclass there-of to indicate the the frame
   *   forms a complete message but indicates an error condition in the device preventing
   *   a successful response.
   *
   *   WARNING: In scenario's 2 and 3, please copy the frame's bytes as the frame's byte array could be a direct reference to an internal
   *   buffer in the receiver.
   * @param iDdfDataFrame
   * @return
   */
  public BIDdfResponse processReceive(IDdfDataFrame receiveFrame)
    throws DdfResponseException
  {
    return new B$(driverName)ReadResponse(receiveFrame,
      (B$(driverName)ReadParams)getReadParameters());
  }
  
  $(if.noDeviceMessage)

  /**
   * The BDdfAutoDiscoveryJob will pass an inner instance
   * of itself to the setDiscoverer method. In there, you
   * need to save away the reference. In here, please return
   * the most recent reference that was passed to the
   * setDiscoverer method.
   */
  public IDdfDiscoverer getDiscoverer()
  {
    return discoverer;
  }
  
  /**
   * The BDdfAutoDiscoveryJob will pass an inner instance
   * of itself here. Please save away the reference. Other
   * than that, you should not need to concern yourself
   * with this.
   */
  public void setDiscoverer(IDdfDiscoverer discoverer)
  {
    this.discoverer=discoverer;
  }  
  
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  /**
   * The setDiscoverer method will be passed an instance of
   * IDdfDiscoverer. You need to retain the reference on
   * the instance and return it (whenever requested) from
   * the getDiscoverer method.
   */
  IDdfDiscoverer discoverer = null;  
  $(end.noDeviceMessage)
}