/*
 * Copyright $(year) $(vendor), All Rights Reserved.
 */
package $(package).identify;

import com.tridium.ddf.identify.*;

import javax.baja.sys.*;

import com.tridium.ddf.*;
import com.tridium.ddf.identify.*;

import $(package).comm.req.*;
import $(package).discover.*;

public class B$(driverName)PointDiscoverParams
  extends BDdfDiscoverParams
{
  // Hypothetical protocol example where a device can report about
  // data points that are connected to it based on a group index.
  public static final int MIN_GROUP_ID = 0;  // Hypothetical min group id = 0
  public static final int MAX_GROUP_ID = 10; // Hypothetical max group id = 10
  
  /*-
  class B$(driverName)PointDiscoverParams
  {
    properties
    {
      groupNumber : int
        -- This would work in a hypothetical protocol where a device
        -- is capable of reporting field-points by group index.
        default{[0]}
        slotfacets{[DdfFacets.combine(MGR_INCLUDE,
                    BFacets.make( BFacets.MIN, BInteger.make(MIN_GROUP_ID) ),
                    BFacets.make( BFacets.MAX, BInteger.make(MAX_GROUP_ID)) ) ]}
    
    }
  }
  -*/
  
  /**
   * Niagara AX requires a public, empty constructor, so that it can perform
   * Its own introspection operations.
   */
  public B$(driverName)PointDiscoverParams()
  {
    
  }
  
  /**
   * Full specified constructor
   */
  public B$(driverName)PointDiscoverParams(int groupNo)
  {
    setGroupNumber(groupNo);
  }  

  public BIDdfDiscoverParams getFirst()
  {
    // TODO: Return an instance of this class that encapsulates the data
    // that would be transmitted as the byte array for the point
    // discovery request in order to request the first known point or
    // group of points in the field-device. Good luck. The following
    // auto-generated return would work for the hypothetical example
    // that this auto-generated class illustrates.
    return new B$(driverName)PointDiscoverParams(MIN_GROUP_ID);
  }

  public BIDdfDiscoverParams getLast()
  {
    // TODO: Return an instance of this class that encapsulates the data
    // that would be transmitted as the byte array for the point
    // discovery request in order to request the last known point or
    // group of points in the field-device. Good luck!
    
    // NOTE: The following auto-generated return would work for the
    // hypothetical example that this auto-generated class illustrates.
    return new B$(driverName)PointDiscoverParams(MAX_GROUP_ID); // TODO:
  }

  public BIDdfDiscoverParams getNext()
  {
    // TODO: Analyze the current instance of this class and return another
    // instance of this class that encapsulates the data that would be
    // transmitted as the byte array for the point discovery request
    // in order to request the next known point or group of points
    // in the field-device. Good luck.
    
    // NOTE: The following auto-generated return would work for the
    // hypothetical example that this auto-generated class illustrates.
    int nextGroup = getGroupNumber() + 1;
    
    if (nextGroup > MAX_GROUP_ID)
      nextGroup = MAX_GROUP_ID;
    
    return new B$(driverName)PointDiscoverParams(nextGroup); // TODO:
    
  }

  public boolean isAfter(BIDdfDiscoverParams anotherPtDiscParams)
  {
    // TODO: Analyze the current instance as well as the given instance
    // of this class. Return true if the current instance of this class
    // encapsulates data that would be transmitted as the byte array
    // for a point discovery request that would request a point or
    // group of points that is after those which the given instance's
    // encapsulated data would request. Good luck.
    
    // NOTE: The following auto-generated/ return would work for the
    // hypothetical example that this auto- generated class illustrates.
    B$(driverName)PointDiscoverParams otherPtDiscParams = 
      (B$(driverName)PointDiscoverParams)anotherPtDiscParams;
    
    return this.getGroupNumber() > otherPtDiscParams.getGroupNumber(); // TODO:    
  }

  public Type getDiscoverRequestType()
  {
    return B$(driverName)PointDiscoverRequest.TYPE;
  }

  /**
   * This tells the developer driver framework that
   * instances of B$(driverName)DiscoveryLeaf will be
   * placed into the discovery list of the point
   * manager to represent each data point that the
   * driver discovers.
   */
  public Type getDiscoveryLeafType()
  {
    return B$(driverName)PointDiscoveryLeaf.TYPE;
  }

}