/*
 * Copyright $(year) $(vendor), All Rights Reserved.
 */
package $(package).comm;

import java.io.*;
import javax.baja.sys.*;
import javax.baja.io.*;

import com.tridium.basicdriver.serial.*;
import com.tridium.basicdriver.message.*;
import com.tridium.basicdriver.comm.*;
import $(package).messages.*;


/**
 * The $(commReceiver.class) class overrides CommReceiver
 * to act as the receive driver for the serial port.
 * It determines when a received message is complete, and
 * routes the received message to the Comm handler.
 *
 * $(commReceiver.class)
 
 * @author    $(author)
 * @creation  $(date)
 * @version   $Revision: 1$ $Date: 4/17/05 6:58:33 AM EDT$
 */
public class $(commReceiver.class)
  extends CommReceiver
{

 /**
  * Constructor
  */
  public $(commReceiver.class)()
  {
  }


  public void initReceiveState(Message msg) 
  {
    resetReceiveBuffer();
  }

  /**
   * Execution of the receive driver.  Continously called to
   * look for received characters on the serial comm line
   * and once a complete message is received, returns the 
   * message to the parent Comm for processing.
   */
	protected ReceivedMessage receive()
		throws Exception
	{
		// Initialize the state machine.
		state = IDLE;
		boolean done = false;
		int address = 0;
		int functionCode = 0;

		while (!done)
		{
			int charIn = getInputStream().read();
			boolean newChar= (charIn != -1);
			charIn = charIn & 0x00ff;
      
			// process received character
      // implement state machine to handle message protocol.
			if (newChar)
			{
				switch(state)
				{
					case IDLE:
						//break;
					case READ_DATA:
						if(charIn == 0x0d)
						{
							done = true;
						}

						else 
						{
							rcvBuffer.write((byte)charIn);
						}
						break;
				}
			}
		}
    
		if (msg == null)
			msg = new $(receivedMessage.class)(rcvBuffer.getBytes(), rcvBuffer.getLength());
		else
		{
			msg.setBytes(rcvBuffer.getBytes());
			msg.setLength(rcvBuffer.getLength());
//			System.out.println("received message = " + new String(rcvBuffer.getBytes(), 0, rcvBuffer.getLength()));
		}


		resetReceiveBuffer();
//		rcvBuffer.reset();
		return msg;
	}


	public synchronized void resetReceiveBuffer()
	{
		rcvBuffer.reset();
	}


////////////////////////////////////////////////////////////////
// Static values
////////////////////////////////////////////////////////////////

  // Process state constants
  private static final int IDLE         = 0;
  private static final int READ_DATA    = 1;

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

  private int state = IDLE;
  private ByteBuffer rcvBuffer = new ByteBuffer();
  private $(receivedMessage.class) msg = null;

} // end of class