/*
 * Copyright $(year) $(vendor), All Rights Reserved.
 */
package $(package);

import javax.baja.sys.*;
import javax.baja.status.*;
import javax.baja.security.*;
import javax.baja.util.*;
import javax.baja.driver.*;
$(if.serialDriver)
import com.tridium.basicdriver.*;
import $(package).messages.*;
$(end.serialDriver)
$(if.points)
import $(package).point.*;
$(end.points)

/**
 * $(device.class)
 *
 * @author    $(author)
 * @creation  $(date)
 * @version   $Revision: 3$ $Date: 4/12/06 11:23:55 AM EDT$
 */
public class $(device.class)
$(if.serialDriver)
  extends BBasicDevice
$(end.serialDriver)
$(if.notSerialDriver)
  extends BDevice
$(end.notSerialDriver)
{           

  /*-
  class $(device.class)
  {
    properties
    {
      address: String
        -- Address 
        default {[ "" ]}  
$(if.points)
      points: $(pointDeviceExt.class)
        -- Point container
        default {[ new $(pointDeviceExt.class)() ]}  
$(end.points)
    }           
    
    actions
    {
    }
  }
  
  -*/
/*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/

////////////////////////////////////////////////////////////////
// Property "address"
////////////////////////////////////////////////////////////////
  
  public static final Property address = newProperty(0, "",null);
  public String getAddress() { return getString(address); }
  public void setAddress(String v) { setString(address,v,null); }

$(if.points)
////////////////////////////////////////////////////////////////
// Property "points"
////////////////////////////////////////////////////////////////

  public static final Property points = newProperty(0, new $(pointDeviceExt.class)(),null);
  public $(pointDeviceExt.class) getPoints() { return ($(pointDeviceExt.class))get(address); }
  public void setPoints($(pointDeviceExt.class) v) { set(address,v,null); }
  
$(end.points)
////////////////////////////////////////////////////////////////
// Type
////////////////////////////////////////////////////////////////
  
  public Type getType() { return TYPE; }
  public static final Type TYPE = Sys.loadType($(device.class).class);

/*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Access
////////////////////////////////////////////////////////////////
  
  /**
   * Get the network cast to a $(network.class).
   */
  public final $(network.class) get$(network.type)()
  {
    return ($(network.class))getNetwork();
  }
     
////////////////////////////////////////////////////////////////
// Device
////////////////////////////////////////////////////////////////
  
  /**
   * Return the network type.
   */
  public Type getNetworkType()
  {
    return $(network.class).TYPE;
  }                
  
////////////////////////////////////////////////////////////////
// Lifecycle
////////////////////////////////////////////////////////////////
  
  /**
   * Callback when device is started.
   */
  public void started()
    throws Exception
  {         
    super.started();                             
  }                      
  
  /**
   * Callback when device is stopped.
   */
  public void stopped()
    throws Exception
  {
    super.stopped();                             
  }  

  /**
   * Callback when property is changed.
   */
  public void changed(Property prop, Context cx)
  {      
    super.changed(prop, cx);
    if (!isRunning()) return;  
  }                
      
////////////////////////////////////////////////////////////////
// Ping
////////////////////////////////////////////////////////////////
  
  /**
   * Post a ping request.
   */
  public IFuture postPing()
  {
    doPing(); 
    return null;
  }
  
  /**
   * Ping implementation.
   */
  public void doPing()
  {                     
$(if.notSerialDriver)
    // TODO
$(end.notSerialDriver)
$(if.serialDriver)
    $(network.class) network = ($(network.class))getNetwork();
    $(readRequest.class) req = null;
    $(readResponse.class) rsp = null;
  
    try
    {
      // T0DO modify to use readRequest to pass in specific attributes
      // required to determine if device is communicating.
      req = new $(readRequest.class)();
      rsp = ($(readResponse.class))(network.sendSync(req)); 
  
      if ( rsp != null )
          pingOk();
      else
          pingFail( "timeout" );
    }
  
    catch( Exception e )
    {
      pingFail( "caught exception" );
      e.printStackTrace();
    }
  
    finally
    {
        network = null;
    }
$(end.serialDriver)
  }              
   
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////

}
