

//////////////////////////////////////////////////////////////////////////////////////////
//
// ------------------------------ Mobile Device Size Functions -----------------------------------
//

if (!IE) {	
    // iPhone / iPod touch / iPad / Other...      
    // document.addEventListener("orientationchange", updatePlotLayoutDraw, false);
    window.addEventListener("orientationchange", 
                     function(){ setTimeout(updateTestOrient,500) }, 
                     false);
}                    

function getInnerWidth() {	
	var wdth = 320;
	
	if (window.innerWidth  || document.documentElement.clientWidth  || document.body.clientWidth) {
		wdth = window.innerWidth  || document.documentElement.clientWidth  || document.body.clientWidth;
	}
	
	return wdth;
} 

function getInnerHeight() {	
	var hght = 378;
	
	if (window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight) {
		hght = window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight;
	}
	
	return hght;
}

function updateTestOrient() {

  var portraitWidth   = 0; 			// 320;
  var portraitHeight  = 0; 			// 378; 
  var landscapeWidth  = 0; 			// 480;
  var landscapeHeight = 0;			// 230; 
  
  var portableDeviceCalcElem = document.getElementById("portableDeviceCalc" );   
   
  landscapeWidth  = portableDeviceCalcElem.getAttribute("landscapeWidthCalc" );	
  landscapeHeight = portableDeviceCalcElem.getAttribute("landscapeHeightCalc");
  portraitWidth   = portableDeviceCalcElem.getAttribute("portraitWidthCalc" );	
  portraitHeight  = portableDeviceCalcElem.getAttribute("portraitHeightCalc");
      
  var mobiForm = document.getElementById('mobiForm');
  if (mobiForm != null)
    {
    var testorientation = 0; 
    var orientText = "Portrait";
    
    if (window.orientation) testorientation = window.orientation;
    
    if ((testorientation == 90) || (testorientation == -90)) {
    	orientText = "Landscape";
    	if (document.getElementById('setHWPane')) 
        {       
          document.getElementById('setHWPane').style.width  = landscapeWidth  + "px";
          document.getElementById('setHWPane').style.height = landscapeHeight + "px";
        }
    } else {
    	orientText = "Portrait";
    	if (document.getElementById('setHWPane')) 
        {       
          document.getElementById('setHWPane').style.width  = portraitWidth  + "px";
          document.getElementById('setHWPane').style.height = portraitHeight + "px";
        }
    }
    	
    mobiForm.currentOrientation.value = orientText;
    
    	    
    }	
}
	                    
function editConfig()
{
    
   // Hide the mobiConfigPane DIV
   if (document.getElementById('mobiConfigPane')) 
   {       
       document.getElementById('mobiConfigPane').style.display = "none";
   } 
    	
   // Show the mobiInfoPane DIV
   if (document.getElementById('mobiInfoPane')) 
   {       
       document.getElementById('mobiInfoPane').style.display = "block";
   } 
   
   var mobiForm = document.getElementById('mobiForm');
   if (mobiForm != null)
   {
     mobiForm.addoredit.value = "EDIT";	
     mobiForm.useragent.value = navigator.userAgent;
   }
      
   // Hide the Height/Width DIV
   if (document.getElementById('setHWPane')) 
   {       
       document.getElementById('setHWPane').style.display = "none";
   } 
  	
}

function addConfig()
{
	
   // Hide the mobiConfigPane DIV
   if (document.getElementById('mobiConfigPane')) 
   {       
       document.getElementById('mobiConfigPane').style.display = "none";
   } 
    	
   // Show the mobiInfoPane DIV
   if (document.getElementById('mobiInfoPane')) 
   {       
       document.getElementById('mobiInfoPane').style.display = "block";       
   } 
   
   var mobiForm = document.getElementById('mobiForm');
   if (mobiForm != null)
   {
     mobiForm.addoredit.value = "ADD";
     mobiForm.useragent.value = navigator.userAgent;	
   }
      
}

function testConfig()
{
   var currentOrient = document.getElementById('currentOrient').getAttribute('content');
   
   if (currentOrient == "portrait") {
	   var portraitWidth = document.getElementsByName('portraitWidthValue')[0];
	   var portraitHeight = document.getElementsByName('portraitHeightValue')[0];
	   
	   portraitWidth.value = getInnerWidth();
	   portraitHeight.value = parseInt(getInnerHeight()) - 38;
   }
   else if (currentOrient == "landscape") {
	   var landscapeWidth = document.getElementsByName('landscapeWidthValue')[0];
	   var landscapeHeight = document.getElementsByName('landscapeHeightValue')[0];
	   
	   landscapeWidth.value = getInnerWidth();
	   landscapeHeight.value = parseInt(getInnerHeight()) - 38;
   }
   
   if ((getInnerWidth() >= 900 && getInnerHeight() >= 500) ||
   		(getInnerWidth() >= 500 && getInnerHeight() >= 900)) {
	   document.getElementsByName('largeGraphics')[1].checked = "Yes";
   }
   else {
	   document.getElementsByName('largeGraphics')[0].checked = "Yes"; 
   }
}

function calcSize() 
{
  var calcWidth  = 0;
  var calcHeight = 0;
  var orientElem = document.getElementById("currentOrient"); 
  var orientVal  = "portrait";
  
  if (getInnerWidth())  calcWidth  = getInnerWidth();
  if (getInnerHeight()) calcHeight = parseInt(getInnerHeight()) - 38;
  
  if (orientElem) 
  {
    orientVal  = orientElem.getAttribute("content"); 
    // if (!IE) window.console.log("calcSize, get currentOrient content = " + orientVal);	
  }     
        
  var portableDeviceCalcElem = document.getElementById("portableDeviceCalc" );      
  var mobiHWForm = document.getElementById('mobiForm');
      
  if (orientVal == "landscape") 
  {
         
    if (portableDeviceCalcElem) 
    {	
      portableDeviceCalcElem.setAttribute("landscapeWidthCalc" , calcWidth);	
      portableDeviceCalcElem.setAttribute("landscapeHeightCalc", calcHeight);
      mobiHWForm.landscapewidthcalc.value   = calcWidth; 
      mobiHWForm.landscapeheightcalc.value  = calcHeight;
      mobiHWForm.landscapewidthvalue.value  = calcWidth; 
      mobiHWForm.landscapeheightvalue.value = calcHeight;	        
    }
     
  } else {  // portrait
              
    if (portableDeviceCalcElem) 
    {	
      portableDeviceCalcElem.setAttribute("portraitWidthCalc" , calcWidth);	
      portableDeviceCalcElem.setAttribute("portraitHeightCalc", calcHeight);
      mobiHWForm.portraitwidthcalc.value  = calcWidth; 
      mobiHWForm.portraitheightcalc.value = calcHeight;	      
      mobiHWForm.portraitwidthvalue.value = calcWidth; 
      mobiHWForm.portraitheightvalue.value= calcHeight;	 	        
    } 	
  }
  
  // if (!IE) window.console.log("calcSize, Orient = " + orientVal + ",  Width = " + calcWidth  + ", Height = " + calcHeight );		
  
}

function setCalcSize() 
{
  var portraitWidth   = 0; 			// 320;
  var portraitHeight  = 0; 			// 378; 
  var landscapeWidth  = 0; 			// 480;
  var landscapeHeight = 0;			// 230; 
        
  var portableDeviceCalcElem = document.getElementById("portableDeviceCalc" );      
  var mobiHWForm = document.getElementById('mobiForm');
               
    if (portableDeviceCalcElem) 
    {	
      // landscapeWidth  = portableDeviceCalcElem.getAttribute("landscapeWidthCalc" );	
      // landscapeHeight = portableDeviceCalcElem.getAttribute("landscapeHeightCalc");
      // portraitWidth   = portableDeviceCalcElem.getAttribute("portraitWidthCalc" );	
      // portraitHeight  = portableDeviceCalcElem.getAttribute("portraitHeightCalc");
      
      landscapeWidth  = mobiHWForm.landscapewidthvalue.value;	
      landscapeHeight = mobiHWForm.landscapeheightvalue.value;
      portraitWidth   = mobiHWForm.portraitwidthvalue.value;	
      portraitHeight  = mobiHWForm.portraitheightvalue.value;
      
      mobiHWForm.landscapeWidthValue.value  = landscapeWidth; 
      mobiHWForm.landscapeHeightValue.value = landscapeHeight;	        
      mobiHWForm.portraitWidthValue.value   = portraitWidth; 
      mobiHWForm.portraitHeightValue.value  = portraitHeight;	 
    } 
  
   // Show the mobiInfoPane DIV
   if (document.getElementById('mobiInfoPane')) 
   {       
       document.getElementById('mobiInfoPane').style.display = "block";
   }

   // Hide the Height/Width DIV
   if (document.getElementById('setHWPane')) 
   {       
       document.getElementById('setHWPane').style.display = "none";
   }
   
  // if (!IE) window.console.log("setCalcSize, LW = " + landscapeWidth + ",  LH = " + landscapeHeight  + ", PW = " + portraitWidth + ", PH = " + portraitHeight );		
  
}

function saveHW()
{

   // if (!IE) window.console.log("saveHW");

   var portraitWidth   = 0; 			// 320;
   var portraitHeight  = 0; 			// 378; 
   var landscapeWidth  = 0; 			// 480;
   var landscapeHeight = 0;			// 230; 
   var mobiHWForm = document.getElementById('mobiForm');
   var currOrient = document.getElementById("currentOrient");
   var portraitSizeElem  = document.getElementById("portraitSize" );
   var landscapeSizeElem = document.getElementById("landscapeSize");
   var portableDeviceCalcElem = document.getElementById("portableDeviceCalc" ); 

   var orient = "portrait";
   
   if (currOrient) 
   {
     orient = currOrient.getAttribute("content");
   }
     
   if (mobiHWForm != null) {
      portraitWidth   = mobiHWForm.portraitwidthvalue.value; 
      portraitHeight  = mobiHWForm.portraitheightvalue.value;
      landscapeWidth  = mobiHWForm.landscapewidthvalue.value; 
      landscapeHeight = mobiHWForm.landscapeheightvalue.value;
      
      // if (!IE) window.console.log("saveHW, portrait  Width = " + portraitWidth  + ", portrait  Height = " + portraitHeight );
      // if (!IE) window.console.log("saveHW, landscape Width = " + landscapeWidth + ", landscape Height = " + landscapeHeight);
      
      if (orient == "landscape") 
      {
        if (document.getElementById('setHWPane')) 
        {       
          document.getElementById('setHWPane').style.width  = landscapeWidth  + "px";
          document.getElementById('setHWPane').style.height = landscapeHeight + "px";
        }
      
        if (portableDeviceCalcElem) 
        {	
          portableDeviceCalcElem.setAttribute("landscapeWidthCalc" , landscapeWidth );	
          portableDeviceCalcElem.setAttribute("landscapeHeightCalc", landscapeHeight);
        }  
                
        if (landscapeSizeElem) 
        {
          landscapeSizeElem.setAttribute("width" , landscapeWidth );	
          landscapeSizeElem.setAttribute("height", landscapeHeight);	
        }
        
      } else 
      {	
        if (document.getElementById('setHWPane')) 
        {       
          document.getElementById('setHWPane').style.width  = portraitWidth  + "px";
          document.getElementById('setHWPane').style.height = portraitHeight + "px";
        }
      
        if (portableDeviceCalcElem) 
        {	
          portableDeviceCalcElem.setAttribute("portraitWidthCalc" , portraitWidth);	
          portableDeviceCalcElem.setAttribute("portraitHeightCalc", portraitHeight);
        }  
        
        if (portraitSizeElem) 
        {	
          portraitSizeElem.setAttribute("width" , portraitWidth );	
          portraitSizeElem.setAttribute("height", portraitHeight);	
        }
    	
      }  
   }
   
   window.scrollTo(0,1);
    
}

// ------------------------ END Mobile Device Size Functions -------------------------------------