/*
 * Copyright 2011 Johnson Controls, Inc. All Rights Reserved.
 */

/**
 * jciPlot
 *
 * @author    Steve Michals
 * @creation  24 Jan 2011
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */

//////////////////////////////////////////////////////////////////////////////////////////
// Code for determining the current Mouse X/Y position
//////////////////////////////////////////////////////////////////////////////////////////

var IE = document.all?true:false;

if (!IE) document.captureEvents(Event.MOUSEMOVE);

document.onmousemove = getMouseXY;
var tempX = 0;
var tempY = 0;

function getMouseXY(e) {
  if (IE) { // grab the x-y pos.s if browser is IE
    tempX = event.clientX + document.body.scrollLeft;
    tempY = event.clientY + document.body.scrollTop;
  }
  else {  // grab the x-y pos.s if browser is NS
    tempX = e.pageX;
    tempY = e.pageY;
  }  

  if (tempX < 0){tempX = 0;}
  if (tempY < 0){tempY = 0;}

  return true;
}

function minuteSecond() {

  var now = new Date();
  var minsec = now.toTimeString();

  return " Time = " + minsec;	
}	

//////////////////////////////////////////////////////////////////////////////////////////
// jciPlot
//////////////////////////////////////////////////////////////////////////////////////////

var jcp = new jciPlot();
function jciPlot()
{

//////////////////////////////////////////////////////////////////////////////////////////
// Attributes
//////////////////////////////////////////////////////////////////////////////////////////

   this.plotData   = [];
   this.plotTime   = [];
   this.plotFlgSta = [];
   
   this.wdth = 768;  // was 400
   this.hght = 908;  // was 400
 
   this.canvasWidth  = 380;
   this.canvasHeight = 350;

   this.leftMargin   = 40;
   this.rightMargin  = 20;
   this.topMargin    = 20;
   this.bottomMargin = 40;
   this.nbrOfSamples = 20;  
   this.nbrOfTicks   = 20;
   this.tickWidth    = 8;
   this.xIncr        = 10;
   this.topAdjust    = 0;

   this.minimumRange = 0;
   this.maximumRange = 100; 
   
   this.currentPlotIndex  = 0;   
   this.currentFocusIndex = 0;

   this.chartCanvasName = '';
   this.chartDivName    = '';
   this.sliderDivName   = '';
   
   this.startingX = 0;
   this.endingX   = 0; 
   this.slideDirection  = 0;  // 0 = None, -1 = Left, 1 = Right

   this.focusPlotX = [];
   this.focusPlotY = [];
   this.previousFocus = -1; 
   
   this.discreteValuesText = [];
   this.isDiscrete         = false;
   this.startsAtZero       = false;
   this.numericUnits       = "";
   this.displayBarGraph    = false;
   
   this.currentHist = "";
   this.histTable   = "";
   this.isGraphDisplayed = true;
   // Save the pointer to the Slide Detector Object
   this.slideElement = null;
   
   // Fast Trend Timer Object
   this.fastTrendTimer  = "";
   this.fastTrendRateMs = 5000;
   
//////////////////////////////////////////////////////////////////////////////////////////

this.getChartCanvasName = function()  {return this.chartCanvasName ; }
this.setChartCanvasName = function(c) {this.chartCanvasName = c; }
this.getChartDivName    = function()  {return this.chartDivName; }
this.setChartDivName    = function(d) {this.chartDivName= d; }

this.getSliderDivName   = function()  {return this.sliderDivName; }
this.setSliderDivName   = function(d) {this.sliderDivName= d; }
this.getSlideDirection  = function()  {return this.slideDirection; }
this.setSlideDirection  = function(d) {this.slideDirection = d; }
this.getStartingX       = function()  {return this.startingX; }
this.setStartingX       = function(s) {this.startingX = s; }
this.getEndingX         = function()  {return this.endingX; }
this.setEndingX         = function(e) {this.endingX = e; }
  
this.getLeftMargin   = function()  {return this.leftMargin; }
this.setLeftMargin   = function(l) {this.leftMargin = l;   }
this.getRightMargin  = function()  {return this.rightMargin; }
this.setRightMargin  = function(r) {this.rightMargin = r;   }

this.getTopMargin    = function()  {return this.topMargin; }
this.setTopMargin    = function(t) {this.topMargin = t;   }
this.getBottomMargin = function()  {return this.bottomMargin; }
this.setBottomMargin = function(b) {this.bottomMargin = b;   }

this.getNbrOfSamples = function()  {return this.nbrOfSamples; }  
this.setNbrOfSamples = function(t) {this.nbrOfSamples= Math.round(t); 
				    // this.setCurrentPlotIndex( this.getCurrentPlotIndex() );	
                                    // if (!IE) window.console.log("setNbrOfSamples set to: " + this.nbrOfSamples);  
                                   } 
 
this.getNbrOfTicks   = function()  {return this.nbrOfTicks; }  
this.setNbrOfTicks   = function(t) {this.nbrOfTicks = Math.round(t); }  
this.getTickWidth    = function()  {return this.tickWidth; }  
this.setTickWidth    = function(t) {this.tickWidth = Math.round(t); }  

this.getxIncrement   = function()  {return this.xIncr; }  
this.setxIncrement   = function(x) {this.xIncr = Math.round(x); }  

this.getMinimumRange = function()  {return this.minimumRange; }
this.setMinimumRange = function(m) {this.minimumRange = Math.round(m); }
this.getMaximumRange = function()  {return this.maximumRange; }
this.setMaximumRange = function(m) {this.maximumRange = Math.round(m); }

this.getChartWidth   = function()  {return this.wdth; }
this.getChartHeight  = function()  {return this.hght; }
this.getCanvasWidth  = function()  {return this.canvasWidth;  };
this.getCanvasHeight = function()  {return this.canvasHeight; };

this.getCurrentPlotIndex = function()  {return this.currentPlotIndex; }
this.getCurrentFocusIndex = function() {return this.currentFocusIndex;}

this.getNumericUnits = function()  {return this.numericUnits; }
this.setNumericUnits = function(u) {this.numericUnits = u; }

this.getDisplayBarGraph = function()  {return this.displayBarGraph; }
this.setDisplayBarGraph = function(b) {this.displayBarGraph = b; }

this.setFastTrendRate = function(sec) {this.fastTrendRateMs = sec * 1000}

//////////////////////////////////////////////////////////////////////////////////////////
// setCurrentPlotIndex(t)  
//
//  - Set the Current Plot Index
////////////////////////////////////////////////////////////////////////////////////////// 
this.setCurrentPlotIndex = function(t) {

  var newIdx = t;
  var deviceWidth = this.getChartWidth();
  
  if (document.getElementById("portableDevice")) 
    {
    var portableDeviceElem = document.getElementById("portableDevice");  
    deviceWidth        = portableDeviceElem.getAttribute("width");
  }
  
  if (newIdx < 0) newIdx = 0;
  
  if (newIdx > this.plotData.length) {
   var nbrSamples = 20;
   	
   if (deviceWidth > 500) {
     nbrSamples = 30; 
   }
     
   if (deviceWidth > 700) {
     nbrSamples = 40; 
   }
     
   if (deviceWidth > 900) {
     nbrSamples = 50; 
   }
    	
   newIdx = this.plotData.length - nbrSamples;
  }  
  
  if (newIdx < 0) newIdx = 0;
  
  this.currentPlotIndex = newIdx;   
   
//  if (!IE) {
//    window.console.log("CurrentPlotIndex set to: "    + this.currentPlotIndex + 
//                                   ", newIdx = "      + newIdx +   
//                                   ", orig = "        + t +
//                                   ", data len = "    + this.plotData.length  + 
//                                   ", Nbr Samples = " + this.nbrOfSamples     + 
//                                   ", chartWidth = "  + this.getChartWidth()  +
//                                   ", deviceWidth = " + deviceWidth
//                                   );
//  }
  
  return newIdx;
  
  }
  
//////////////////////////////////////////////////////////////////////////////////////////
// setCurrentFocusIndex(t)  
//
//  - Set the Index of the Current Focus Value
////////////////////////////////////////////////////////////////////////////////////////// 
this.setCurrentFocusIndex = function(t) {

  var newIdx = t;
  
  if (newIdx < 0) newIdx = 0;
  
  if (newIdx >= this.getNbrOfSamples()) newIdx = this.getNbrOfSamples()-1;
  
  if ( (newIdx + this.getCurrentPlotIndex()) > (this.plotData.length - 1) ) {
    newIdx = this.plotData.length - 1 - this.getCurrentPlotIndex();
  }  	 
  
  this.currentFocusIndex = newIdx;   
    
  // window.console.log("Current Focus Index set to: " + this.currentFocusIndex);
  
  return newIdx;
  }
  
//////////////////////////////////////////////////////////////////////////////////////////
// setChartWidth(w)  
//
//  - Set the Width of the Chart
////////////////////////////////////////////////////////////////////////////////////////// 
this.setChartWidth   = function(w) {
  this.wdth = w; 

  var divName   = this.getChartDivName();
  // var divWidth  = null; 
  
  if (divName.length == 0) {
   // if (!IE) window.console.log("drawGrid NO Chart Div Name");
   return;
  }
  
  document.getElementById(divName).style.width = w + 'px';
  
  var canvasName   = this.getChartCanvasName();
  var canvasWidth  = w - 20;			// document.getElementById(canvasName).width;   
  document.getElementById(canvasName).width = canvasWidth;
  // Set the local canvasWidth
  this.canvasWidth = canvasWidth;

  var focusName  = "focusBar";
  var focusWidth = w - 20; 			// document.getElementById(focusName).width;
  document.getElementById(focusName).style.width = focusWidth  + 'px';
     
  var focusValuesDiv  = "focusBarValues";  	// this.getSliderDivName();
  var focusValuesWidth = w - 88;			// document.getElementById(sliderName).width;
  document.getElementById(focusValuesDiv).style.width = focusValuesWidth + 'px';
     
  // window.console.log("DIV, W = " + divWidth    + ", New = " + document.getElementById(divName).style.width + 
  //             " / CANVAS, W = " + canvasWidth + ", New = " + document.getElementById(canvasName).width    + 
  //             " / Slider, W = " + sliderWidth );

}

//////////////////////////////////////////////////////////////////////////////////////////
// setChartHeight(h)  
//
//  - Set the Height of the Chart
////////////////////////////////////////////////////////////////////////////////////////// 
this.setChartHeight  = function(h) {

  this.hght = h; 

  var divName   = this.getChartDivName();
  
  if (divName.length == 0) {
   // if (!IE) window.console.log("drawGrid NO Chart Div Name");
   return;
  }

  var divHeight = document.getElementById(divName).style.height;  // + 'px';
  document.getElementById(divName).style.height = h + 'px';

  var canvasName   = this.getChartCanvasName();
  var canvasHeight = h - 50; 			// document.getElementById(canvasName).height;  
  document.getElementById(canvasName).height = canvasHeight;  
  this.canvasHeight = canvasHeight; 

  // window.console.log("DIV, H = " + divHeight    + ", New = " + document.getElementById(divName).style.height + 
  //             " / CANVAS, H = " + canvasHeight + ", New = " + document.getElementById(canvasName).height );

}

//////////////////////////////////////////////////////////////////////////////////////////
// setDiscreteValuesText(idx)
//
//  - Set the Array of Disctete Values for Boolean or Enum Points
////////////////////////////////////////////////////////////////////////////////////////// 
this.setDiscreteValuesText = function(startsAtZero, vals) 
{
   if (startsAtZero == true) {
     this.startsAtZero = true;
   } else {
     this.startsAtZero = false;
   }	  
     	
   this.discreteValuesText = vals;	
   
   this.setNumericUnits("");
   
   // window.console.log("setDiscreteValuesText, vals = " + vals + ", VAR = " + this.discreteValuesText);
}

//////////////////////////////////////////////////////////////////////////////////////////
// getDiscreteValueText(idx)
//
//  - Get the Text value corresponding to an Discrete Value number
//    of the Disctete Value string array
////////////////////////////////////////////////////////////////////////////////////////// 
this.getDiscreteValueText = function(val) 
{
   var txt = ' ';
   
   if ( this.startsAtZero ) {
     if (val < this.discreteValuesText.length) {
       var nbr = Number(val);		
       txt = this.discreteValuesText[nbr];	
     }
   } else {
       var adjVal = val - 1;	
       if ( adjVal < this.discreteValuesText.length) { 
         txt = this.discreteValuesText[adjVal];
       }  		
   }	     
   
   return txt; 
}

//////////////////////////////////////////////////////////////////////////////////////////
// getDiscreteValueIndex(txt)
//
//  - Get the Array Index of a specific Disctete Value string
////////////////////////////////////////////////////////////////////////////////////////// 
this.getDiscreteValueIndex = function(txt) 
{
   var idx = 0;
   
   idx = this.discreteValuesText.indexOf(txt);	
   
   return idx; 
}

//////////////////////////////////////////////////////////////////////////////////////////
// focusPlotIndex(idx)
//
//  - Show a highlighted circle of the plot Value when mouse is clicked
////////////////////////////////////////////////////////////////////////////////////////// 
this.focusPlotIndex = function(idx) 
{

    // Show a highlight for the Focus Value

    // Set canvas info
    var canvasName = this.getChartCanvasName();
    var j  = document.getElementById( canvasName );   //.getContext('2d');
    var jg = j.getContext('2d');

    var x = 0;
    var y = 0;

    // "Erase" the previous Focus
    if ( (this.previousFocus != -1) && 
         (this.previousFocus != idx)) {

      // Just re-draw the entire Grid
      // since over-drawing with BG color 
      // to erase does not fully erase 
      // what was previously there
      this.drawGrid();  

      // window.console.log("focusPlotIndex: erase, idx = " + idx + ", prev= " + this.previousFocus + 
      //                   ", Focus X-pos = " + x + ", Focus Y-pos = " + y + ", line width = " + jg.lineWidth);

    }
    
    this.drawHighlight(jg, this.focusPlotX[idx], this.focusPlotY[idx]);

    // Display the focused value and its timestamp
    var offset = this.getCurrentPlotIndex() + idx;
   
    // document.ValueDisplay.plotIndex.value = idx;
    // document.ValueDisplay.plotTime.value  = plotTime[offset]; 
    // document.ValueDisplay.plotValue.value = plotData[offset]; 

    // Display the focus value/timestamp in the focus DIV
    var focusValue     = document.getElementById('focusValue');
    var focusTimeStamp = document.getElementById('focusTimeStamp');
  
    if (this.isDiscrete) {
      focusValue.innerHTML     = this.getDiscreteValueText( this.plotData[offset] );
      // window.console.log("showPlotDisplayValues: data = " + plotData[offset] );
    } else 
    {
      focusValue.innerHTML     = this.plotData[offset];	
    }	

    // focusValue.innerHTML     = plotData[offset]; 
    focusTimeStamp.innerHTML = this.plotTime[offset];    

    // window.console.log("focusPlotIndex: highlite, idx = " + idx + ", prev= " + this.previousFocus);
    //                   ", Focus X-pos = " + x + ", Focus Y-pos = " + y + ", line width = " + jg.lineWidth);

    this.previousFocus = idx; 
}

//////////////////////////////////////////////////////////////////////////////////////////
// drawHighlight 
//
//- Show the Highlight Marker when mouse is clicked
//  - jg - Canvas object
//  - xpos - X Position
//  - ypos - Y Position
////////////////////////////////////////////////////////////////////////////////////////// 
this.drawHighlight = function(jg, xpos, ypos)
{
/***
var compositeTypes = [
  'source-over','source-in','source-out','source-atop',
  'destination-over','destination-in','destination-out','destination-atop',
  'lighter','darker','copy','xor'
];
***/	
    jg.strokeStyle = "crimson";
    jg.fillStyle   = "crimson";
    jg.globalCompositeOperation = "source-over";
    // jg.fillRect(xpos, ypos, 12, 12);
    // Draw a Triangle above the x-y position
    jg.beginPath();
    jg.moveTo(xpos - 6, ypos - 12);
    jg.lineTo(xpos + 6, ypos - 12);
    jg.lineTo(xpos, ypos);
    jg.moveTo(xpos - 6, ypos - 12);
    jg.closePath();
    jg.stroke();
    jg.fill();
	
}
 
//////////////////////////////////////////////////////////////////////////////////////////
// showPlotDisplayValues 
//
//  - Show the TimeStamp and Value when mouse is clicked
////////////////////////////////////////////////////////////////////////////////////////// 
this.showPlotDisplayValues = function() 
{
    var idx    = 0;
    var offset = 0;
    
    if (arguments.length == 0) { 
      // alert("showPlotDisplayValues: time = " + timeval+ ", value = " + dataval + 
      //       ", X= " + document.Show.MouseX.value + ", Y= " + document.Show.MouseY.value); 
  
      // get the closest X-index from the mouse click
      // var idx    = this.xTicIndex(document.Show.MouseX.value, this.getCanvasWidth());
      idx    = this.xTicIndex(tempX, this.getCanvasWidth());
      offset = this.getCurrentPlotIndex() + idx;
    } else { 
      idx = arguments[0];
    }
    
    offset = this.getCurrentPlotIndex() + idx;
    // Save the clicked index on the graph for the moveLeft and moveRight methods.
    idx = this.setCurrentFocusIndex(idx);

    // Show a highlight for the Focus Value
    this.focusPlotIndex(idx);       

    // window.console.log("showPlotDisplayValues: X-pos = " + tempX + 
    //                   ", idx = " + idx + ", offset = " + offset + ", value = " + plotData[offset] ); 

  return; 
}

////////////////////////////////////////////////////////////////////////////////////////// 
// xTicIndex 
//
//  - Determine the closest X-pos/tic nbr when mouse clicked 
////////////////////////////////////////////////////////////////////////////////////////// 
this.xTicIndex = function(xClickPos, width) {

  var tickIndex    = 0;
  var nbrOfSamples = this.getNbrOfSamples();  // 20;
  var leftMargin   = this.getLeftMargin();    // 50;
  var rightMargin  = this.getRightMargin();   // 20;
  var gridWdth     = width - (leftMargin   + rightMargin);
  var tickSizeX    = this.getxIncrement();
  var halfTick     = Math.floor(tickSizeX / 2);

  // Adjust the leftMargin value to account for margins and boarders
  leftMargin = leftMargin + 12;

  // window.console.log("xTicIndex: W = " + width + ", LM = " + leftMargin + 
  //                   ", RM = " + rightMargin + ", GW = " + gridWdth); 

  if (xClickPos < leftMargin) tickIndex = 0;

  if (xClickPos >= width) tickIndex = nbrOfSamples+1;

  tickIndex = Math.floor( ((xClickPos-leftMargin) + halfTick) / tickSizeX);

  if (tickIndex < 0)            tickIndex = 0;
  if (tickIndex > nbrOfSamples+1) tickIndex = nbrOfSamples+1;

  // window.console.log("xTicIndex: tickIndex = " + tickIndex + ", xClickPos = " + xClickPos + 
  //                   ", halfTick = " + halfTick + ", tickSizeX = " + tickSizeX); 

  return tickIndex;
}

////////////////////////////////////////////////////////////////////////////////////////// 
// moveleft
// 
//  - reposition the focusValue DIV to show a value to the left 
//    of the current focusValue
////////////////////////////////////////////////////////////////////////////////////////// 
this.moveleft = function() {

  // move the X-index left by 1 unlsess already at far left
  var idx = this.getCurrentFocusIndex();
  idx     = this.setCurrentFocusIndex(idx-1);
  // idx    = this.getCurrentFocusIndex();

  // Show a highlight for the Focus Value
  this.focusPlotIndex(idx);       

  // window.console.log("moveleft: idx = " +idx+ ", offset = " +offset+ ", value = " + plotData[offset] + ", time = " + plotTime[offset] ); 

  return; 
}

////////////////////////////////////////////////////////////////////////////////////////// 
// moveright
// 
//  - reposition the focusValue DIV to show a value to the right 
//    of the current focusValue
////////////////////////////////////////////////////////////////////////////////////////// 
this.moveright = function() {

  // move the X-index right by 1 unlsess already at far right
  var idx = this.getCurrentFocusIndex();
  idx     = this.setCurrentFocusIndex(idx+1);
  // idx = this.getCurrentFocusIndex();

  // Show a highlight for the Focus Value
  this.focusPlotIndex(idx);       

  // window.console.log("moveright: idx = " + idx + ", offset = " + offset + ", value = " + plotData[offset] + ", time = " + plotTime[offset] ); 

  return; 
}

////////////////////////////////////////////////////////////////////////////////////////// 
// oddNumber 
//  - Return TRUE if Odd, FALSE if Even
////////////////////////////////////////////////////////////////////////////////////////// 
this.oddNumber = function(nbr) {

  if (nbr == 0) return false;

  if (nbr%2) {
    return true;
  } else {  
    return false;
  }

}

////////////////////////////////////////////////////////////////////////////////////////// 
// drawGrid 
//  - Updated for Discrete Values 
//  - Draw the Grid for the Graph and Plot the Values on the Graph
////////////////////////////////////////////////////////////////////////////////////////// 
this.drawGrid = function()
{

if (IE){
   // alert("Cannot display Canvas in IE!");
   return;
}
	

var divName   = this.getChartDivName();
if (divName.length == 0) {
   // if (!IE) window.console.log("drawGrid NO Chart Div Name");
   return;
}

var divHeight = document.getElementById(divName).style.height;  // + 'px';
var divWidth  = document.getElementById(divName).style.width;   // + 'px';

var canvasName   = this.getChartCanvasName();
if (canvasName.length == 0) {
   // if (!IE) window.console.log("drawGrid NO Chart Canvas Name");	
   return;
}

this.getPortableDeviceInfo();

var canvasHeight = document.getElementById(canvasName).height;  // + 'px';
var canvasWidth  = document.getElementById(canvasName).width;   // + 'px';

   // if (!IE) window.console.log("drawGrid DIV, W = " + divWidth + ", H = " + divHeight + " / CANVAS, W = " + canvasWidth + ", H = " + canvasHeight);

   // Draw markers for X-Axis / Y-Axis
   var wdth = this.getCanvasWidth();   // this.getChartWidth();  / 400;
   var hght = this.getCanvasHeight();  //  this.getChartHeight(); / 400;
 
   var leftMargin   = this.getLeftMargin();   // 50;
   var rightMargin  = this.getRightMargin();  // 20;
   var topMargin    = this.getTopMargin();    // 20;
   var bottomMargin = this.getBottomMargin(); // 40;

   var gridBottom   = hght - bottomMargin;
   var gridTop      = topMargin;
   var gridLeft     = leftMargin;
   var gridRight    = wdth - rightMargin; 
   var gridWdth     = wdth - (leftMargin   + rightMargin);
   var gridHght     = hght - (bottomMargin + topMargin  ); 
   
   var isDiscrete = false;
   
   var yMinValue    = this.getMinimumRange();  // -70.0;
   var yMaxValue    = this.getMaximumRange();  // 170.0;
   
   // Vertical Axis - Discrete Value calc for nbrOfTicksY
   var nbrOfTicksY = this.getNbrOfTicks();   // 20;
   if (this.discreteValuesText.length > 0) {
   	
     isDiscrete = true; 
     this.isDiscrete = true;
     	
     if (this.discreteValuesText.length < 20)	
       nbrOfTicksY = this.discreteValuesText.length;
       
     // window.console.log("drawGrid2, Discrete count = " + nbrOfTicksY);  
   } else {
     // Vertical Axis - Discrete Value calc for nbrOfTicksY	
     var yRangeDiff = yMaxValue - yMinValue;
     
     if (yRangeDiff < 20) {
     	nbrOfTicksY = Math.round(yRangeDiff);	
     }
     
     if (yRangeDiff < 2) {
     	nbrOfTicksY = 2;
     	yMaxValue   = yMinValue + 2;	
     }	
   }
   
   // Horizontial Axis
   var nbrOfTicksX = this.getNbrOfSamples();   // 20;
   var tickSizeX  = Math.round(gridWdth / nbrOfTicksX);   // 40;
   var tickSizeY  = Math.round(gridHght / nbrOfTicksY);   // 40;
   var tickWidth  = this.getTickWidth();     // 8;
   var xLabelAdj  = 2;    // was 4

   // Save the X-Increment
   this.setxIncrement(tickSizeX);

   // Adjust the Top and Right margins to "even-out" the grid
   var rightAdj = (tickSizeX * (nbrOfTicksX-1)) - gridWdth;
   var topAdj   = (tickSizeY * nbrOfTicksY) - gridHght; 
   // window.console.log("Grid W = " + gridWdth + ", rightAdj= " + rightAdj + ", X-tic = " + tickSizeX); 
   // window.console.log("Grid H = " + gridHght + ", topAdj  = " + topAdj   + ", Y-tic = " + tickSizeY);
   gridWdth    = gridWdth + rightAdj;
   rightMargin = rightMargin - rightAdj;
   gridRight   = wdth - rightMargin; 

   gridHght    = gridHght  + topAdj;
   topMargin   = topMargin - topAdj;   
   gridTop     = topMargin;
   // Save the topAdjust value for the plot method
   this.topAdjust = topAdj;
   // Reset the topMargin after the Adjustment
   // this.setTopMargin(topMargin);
  
   var yValueInc    = Math.round((yMaxValue-yMinValue) / nbrOfTicksY);  
   var yAdjMaxValue = (yValueInc * nbrOfTicksY) + yMinValue; 
   // Reset the Y-Maximum Value after Adjustment 
   this.setMaximumRange(yAdjMaxValue);  

   // window.console.log("drawGrid Y-Inc = " + yValueInc + ", new max = " + yAdjMaxValue);

   // Set canvas info
   var canvasName = this.getChartCanvasName();
   var j = document.getElementById( canvasName );   //.getContext('2d');

   // window.console.log("drawGrid, W = " + j.width + ", H = " + j.height);
   j.width  = wdth;  // 400;
   j.height = hght;  // 400;

   // var jg = j.getContext('2d');
   var jg = null; 
   if (!IE) jg = j.getContext('2d'); else return;

   // window.console.log("drawGrid context = " + jg);

   jg.lineWidth = 1;
   // jg.strokeRect(0, 0, this.getChartWidth(), this.getChartHeight() );
   jg.fillStyle = "white";
   jg.clearRect(0, 0, this.getCanvasWidth(), this.getCanvasHeight() );

   // window.console.log("drawGrid orig font = " + jg.font);
   jg.font = "normal 10px Helvetica";
   // window.console.log("drawGrid New  font = " + jg.font);

   //

   var i;
   // jg.setColor("black");
   jg.strokeStyle = "black";
   jg.fillStyle   = "white";

   for (i=0; i < nbrOfTicksY+1; i++)
     {

     //---------------------------------
     // Y-Axis - Typically Values (Vert)
     //---------------------------------
     var y_y1 = gridBottom - Math.round(tickSizeY*i);

     if (y_y1 < gridTop) 
     { 
        y_y1 = gridTop; 
     }

     // Y-Axis tic mark
     var y_x1 = leftMargin-tickWidth;
     this.drawLine(jg, y_x1, y_y1, leftMargin, y_y1);

     var yvalu = y_y1;           // y_y1-6;
     var lblWidth = leftMargin - tickWidth - xLabelAdj;
     jg.textAlign    = "right";      
     jg.textBaseline = "middle";
     jg.font = "normal 10px Helvetica sans-serif";     // "normal 10px 'Times New Roman', Times, serif";
     jg.fillStyle = "black";
     
    // Y-Axis Labels
     if (isDiscrete) {  // Discrete Value display - Boolean or Enum
       var yDiscreteLabel = " ";	
       if (i==0) {
       	 // show a blank for bottom tick mark 
         yDiscreteLabel = " ";  
       } else {
       	 // since the nbr of ticks is 1 more than the list size, subtract 1 here for proper label
       	 // if (i > this.discreteValuesText.length-1)
         yDiscreteLabel = this.discreteValuesText[i-1];
         yDiscreteLabel = yDiscreteLabel.substring(0,6);
         jg.fillText(yDiscreteLabel, lblWidth, yvalu);   
       }	
     } else {	// Numeric Value Display
       var yLabelValue = 0;

       if (i==0) {
         yLabelValue =  Math.round(yMinValue);
         jg.fillText(yLabelValue, lblWidth, yvalu);
       } else {
         yLabelValue = Math.round(yMinValue + (i*yValueInc));
         if (yLabelValue > yAdjMaxValue) yLabelValue = Math.round(yAdjMaxValue);
         
       // jg.fillText(yLabelValue, 35, yvalu); 
       jg.fillText(yLabelValue, lblWidth, yvalu); 
       // window.console.log("drawGrid Y Label = " + yLabelValue + ", y = " + yvalu);
       }
     }  
  

     // Draw the Y-Axis minor grid lines every-other tick (even tic marks)
     if ( !this.oddNumber(i)  ) 
     {    
       // Set the minor grid color
       jg.strokeStyle = "silver"; 

       // Draw the minor grid for Y-Axis
       this.drawLine(jg, leftMargin+1, y_y1, gridRight-1, y_y1);
       // Set the default color back to black
       jg.strokeStyle = "black";
     } else {
         if ( isDiscrete && (i>0) ) {
           // Set the minor grid color
           jg.strokeStyle = "silver"; 

           // Draw the minor grid for Y-Axis
           this.drawLine(jg, leftMargin+1, y_y1, gridRight-1, y_y1);
           // Set the default color back to black
           jg.strokeStyle = "black";
         }
     }
   } // FOR Y-Axis

   //---------------------------------------------
   // X-Axis - Typically Time Based Values (Horiz)
   //---------------------------------------------
   for (i=0; i < nbrOfTicksX; i++)
     {
     // X-Axis tic marks
     var x1 = Math.round((tickSizeX*i)+leftMargin);
     if (x1 > gridRight) x1 = gridRight;
     var y1 = hght-bottomMargin;
     this.drawLine(jg, x1, y1, x1, y1+tickWidth);

     // X-Axis Labels
     var adjVal = xLabelAdj;
      
     if (i >= 9) { 
       adjVal = adjVal + 5;
     } 

     var xval = x1-adjVal;
     var yval = y1 + 20;      // y1+12;
     jg.textAlign = "left";     
     jg.textBaseline = "middle";
     jg.font = "normal 10px 'Times New Roman', Times, serif"; // "normal 10px Helvetica sans-serif";     
     jg.fillStyle = "black";
     jg.fillText((i+1), xval, yval, 16); 
     // window.console.log("drawGrid X Label = " + i + ", x = " + xval + ", y = " + yval);

     // Draw the X-Axis minor grid lines every-other tick (even tic marks)
     if ( !this.oddNumber(i) ) 
     {
       // Set the minor grid color
       jg.strokeStyle = "silver"; 
       // Draw the minor grid for X-Axis
       this.drawLine(jg, x1, topMargin+1, x1, y1-1);

       // Set the default color back to black
       jg.strokeStyle = "black";
     }

     // Draw the left-most Time value
     if (i==0) { 
       jg.fillStyle = "blue";
       jg.fillText(this.plotTime[ this.getCurrentPlotIndex() ], xval, yval+12, 24);

       var middleX = Math.round(wdth / 2); // + tickSizeX;  
       jg.fillText("   ", middleX , yval+12, 24);  // was "- - -"
       // window.console.log("middle X Time Label X = " + middleX  + ", y = " + (yval+12));
       jg.fillStyle = "black";
       // Draw the Numeric Units Text (should be empty if Discrete)
       jg.font = "bold 10px 'Times New Roman', Times, serif";
       jg.fillText(this.getNumericUnits(), xval-30, yval+12, 24);
     } 
 
     jg.font = "normal 10px 'Times New Roman', Times, serif";
 
     // Draw the right-most Time value
     if (i==nbrOfTicksX-1) 
     {	
       var timeIdx = this.getCurrentPlotIndex() + nbrOfTicksX - 1;
       
       if (timeIdx > this.plotData.length) {
         timeIdx = this.plotData.length - 1;	
       }
       	 
       jg.textAlign = "right"; 
       jg.fillStyle = "blue";
       jg.fillText(this.plotTime[timeIdx], xval+12, yval+12, 24);
       jg.textAlign = "left";
       jg.fillStyle = "black"; 

       // window.console.log("Plot time values label, first = " + this.getCurrentPlotIndex() + ", time: " + plotTime[ this.getCurrentPlotIndex() ] +
       //                   ", last = " +  timeIdx  + ", time: " + plotTime[timeIdx] );

     }  


   } // FOR X-Axis

   // TEST TEST TEST - show current page orientation
   /*****
   var winOrient = window.orientation;
   var currentOrient = null;
   if (document.getElementById("currentOrient")) 
   {
     currentOrientElem  = document.getElementById("currentOrient");  
     currentOrient = currentOrientElem.getAttribute("content"); 
   }

   var orintText = "Current Orient: " + currentOrient + ", window.orientation: " + winOrient;
   jg.fillText(orintText, this.leftMargin, this.topMargin-12); 
   *****/
   // END TEST

   
   
   // Grid Outline
   // jg.fillStyle = "white";
   // jg.fillRect(leftMargin, topMargin, gridWdth, gridHght);

   jg.strokeRect(leftMargin, topMargin, gridWdth, gridHght);

   // this.plotValuesDiscrete(jg, this.getCurrentPlotIndex());
   this.plotValues(jg, this.getCurrentPlotIndex());

} // drawGrid  -  Updated

////////////////////////////////////////////////////////////////////////////////////////// 
// plotValues    
//
//  - Updated for Discrete Values
//  - Plot the Values on the Graph
////////////////////////////////////////////////////////////////////////////////////////// 
this.plotValues = function(jgObj, startingElement ) {

  var minVal = this.getMinimumRange(); 
  var maxVal = this.getMaximumRange(); 
  var topPx  = this.getTopMargin() - this.topAdjust;
  var botPx  = this.getCanvasHeight() - this.getBottomMargin();  // this.getChartHeight() - this.getBottomMargin();
  var xLeft  = this.getLeftMargin();
  var xIncr  = this.getxIncrement();
  var nbrOfElems = this.getNbrOfSamples();  
  var lastIndex  = 0;

  /*****
  window.console.log("PLOT: min= " + minVal + 
                         ", max= " + maxVal +
                         ", top= " + topPx  + 
                         ", bot= " + botPx  + 
                         ", left= " + xLeft  +
                         ", incr= " + xIncr);
  *****/

  var outOfRange = false;
  var nbrOfPx    = botPx - topPx; // topPx - botPx;
  var valRange   = maxVal - minVal;
  var valuePerPx = Math.abs(nbrOfPx / valRange);

  /*****
  window.console.log("PLOT:  min= " + minVal + 
                          ", max= " + maxVal + 
                          ", range = " + valRange + 
                          ", value per Px = " + valuePerPx ); 
  *****/
  
  // Draw the Line Graph
  //
  // Use the following calculation steps to determine the Y-pos in pixels
  //  1) calculate the Plot Value Pct of Total Value Range  
  //  2) multiply the Plot Value Pct times the Pixel Height
  //  3) subtract the Abs Pixel Height from Grid Bottom Pixel value
  //
  var oldx, oldy;
  var xPxVal = xLeft;
  var graphHeight  = botPx - topPx;
  var valueRange   = maxVal - minVal;
  var maxPlotElems = this.plotData.length;

  this.focusPlotX = [];
  this.focusPlotY = [];
	
  for (i=0; i < nbrOfElems; i++)
  {
    outOfRange = false;
    var idx = i + startingElement;
    
    if (idx < maxPlotElems) 
    {
      lastIndex = i; 
      var plotDataValue = 0;
      if (this.startsAtZero == true) 
      {
        if ( this.discreteValuesText.length == 2) 
          { // Boolean Values / or maybe a 2-state Enum starting at 0
          plotDataValue = Number( this.plotData[idx] ) + 1;
          } 
        else 
          {
          plotDataValue = this.plotData[idx] + 1;	
          } // Discrete length	 		  
      } else {
      	  if (this.isDiscrete) {
      	    // Enum value that srarts at 1 - use the actual value	
      	    plotDataValue   = this.plotData[idx];	
      	  } else {      	   	
      	    plotDataValue   = this.plotData[idx] - minVal;
      	  } 
      } 
      
      // var plotDataValue   = plotData[idx];
      // var pctOfRangeValue = (plotDataValue - minVal) / valueRange;
      var pctOfRangeValue = 0; 
      if (plotDataValue != 0) pctOfRangeValue = plotDataValue / valueRange;
      
      
      // var absPxValue  = Math.round( pctOfRangeValue * graphHeight );
      var absPxValue = ( (pctOfRangeValue * graphHeight) + 0.5) | 0;
      // window.console.log("PLOT: PxVal: " + absPxValue + ", AltPxVal = " + otherAbsPxValue);

      // yPxVal = graphHeight - absPxValue; 
      var yPxVal = botPx - absPxValue; 

      xPxVal = Math.round(xLeft + (xIncr*i));
      
      /****
      window.console.log("PLOT: i: " + i + 
                           ", val= " + this.plotData[i] + 
                           ", plotVal = " + plotDataValue + 
                           ", px = " + absPxValue + 
                           ", x= " + xPxVal + 
                           ", y= " + yPxVal ); 
      *****/
      
      if (yPxVal < topPx) {
        yPxVal = topPx;
        outOfRange = true;
      }

      if (yPxVal > botPx) {
        yPxVal = botPx;
        outOfRange = true;
      } 

      if (this.getDisplayBarGraph()) 
      {
      	// Display values in a BAR Graph
        if (outOfRange) { 
          jgObj.fillStyle = "red";
        } else {
          jgObj.fillStyle = "blue";
        }
        
        var halfWidth  = (this.getxIncrement() / 2) | 0;
        var rectWidth  = this.getxIncrement() - 1;
        var rectHeight = botPx - yPxVal;
        var rectXPos   = xPxVal - halfWidth;
        if (i==0) {
          rectWidth = halfWidth-1;
          rectXPos   = xPxVal;	
          // window.console.log("PLOT: i= " + i + ", xpos= " + rectXPos + ", W= " + rectWidth);
        }
        
        if (i==nbrOfElems-1) {
          rectWidth = halfWidth-1;	
          // window.console.log("PLOT: i= " + i + ", xpos= " + rectXPos + ", W= " + rectWidth);
        }
        	 
        // var startingY  = 
        jgObj.fillRect(rectXPos, yPxVal, rectWidth, rectHeight);
        // window.console.log("PLOT: i= " + i + ", val= " + plotDataValue + ", RECT: x= " + rectXPos + ", y= " + yPxVal + ", w= " + rectWidth + ", h= " + rectHeight);
        	
      } else {
      	// Display values in a LINE Graph
        if(i >= 1)
        {
          jgObj.strokeStyle = "blue";
          this.drawLine(jgObj, oldx, oldy, xPxVal, yPxVal);
          // window.console.log("PLOT: i: " + i + ", oldx= " + oldx + ", oldy= " + 
          //                   oldy + ", x= " + xPxVal + ", y= " + yPxVal ); 
        }

        if (outOfRange) { 
          jgObj.fillStyle = "red";
        } else {
          jgObj.fillStyle = "blue";
        }

        // Draw a small filled-in circle to highlight the data point   
        this.fillCircle(jgObj, xPxVal, yPxVal, 3);
      }
      
      this.focusPlotX[i] = xPxVal;
      this.focusPlotY[i] = yPxVal;

      // window.console.log("PLOT: i: " + i + ",  x= " + (xPxVal-3) + ", y= " + oldy + ", endAngle= " +  Math.PI*2 ); 
      // window.console.log("PLOT: i: " + i + ",  x= " + xPxVal + ", y= " + yPxVal +  ", idx= " + idx +
      //                   ", value= " +  plotData[idx] + ", pct = " + pctOfRangeValue); 

      jgObj.strokeStyle = "black";

      oldx = xPxVal;
      oldy = yPxVal;

    }  //  

  }  // FOR

  var rightIndex =  document.getElementById('rightIndex');
  var leftIndex  =  document.getElementById('leftIndex');
  leftIndex.innerHTML  = startingElement + 1; 
  rightIndex.innerHTML = startingElement + lastIndex + 1;

 
}  // plotValues   Updated for Discrete Values

//////////////////////////////////////////////////////////////////////////////////////////
// SlideDetector
//////////////////////////////////////////////////////////////////////////////////////////
this.SlideDetector = function(el) {

    // window.console.log("SlideDetector called for element: " + el.id);

    var elem = el;
    if (elem != null) {
      if( window.Touch ) { 
        elem.addEventListener('touchstart', this, false);
        elem.addEventListener('touchmove',  this, false);
        elem.addEventListener('touchend',   this, false);
      }  
    }
  }

  this.SlideDetector.prototype = {
    handleEvent: function(e) {
    switch(e.type) {
     case 'touchstart': this.onTouchStart(e); break;
     case 'touchmove':  this.onTouchMove(e);  break;
     case 'touchend':   this.onTouchEnd(e);   break;
     }
  },
 
  onTouchStart: function(e) {
    e.preventDefault();
    this.moved = false;  
    var strt =  e.touches[0].screenX;

    jcp.setStartingX(strt)
    jcp.setEndingX(0);
    // window.console.log("onTouchStart called, x = " + jcp.getStartingX() );
  },
 
  onTouchMove: function(e) {
    e.preventDefault();
    this.moved = true;
  },
 
  onTouchEnd: function(e) {   
    e.preventDefault();

    var endX = e.changedTouches[0].screenX;   
    var strt = jcp.getStartingX();
    jcp.setEndingX(endX);
    
    var slideDir = 0;
    if (strt > endX) slideDir =  1;     // Slide Left 
    if (strt < endX) slideDir = -1;     // Slide Right 
    
    // if (this.startingX > this.endingX) slideDir = -1;    // Slide Left 
    // if (this.startingX < this.endingX) slideDir = 1;     // Slide Right
    
    jcp.setSlideDirection(slideDir);
         
    // window.console.log("onTouchEnd called, x = " + jcp.getEndingX() + ", DIR = " + jcp.getSlideDirection());
    
    // var theTarget = document.getElementById('sliderBar'); 
    // var theEvent  = document.createEvent('MouseEvents');
    // theEvent.initEvent('click', true, false);
  
    // var focusTimeStamp = document.getElementById('focusTimeStamp');
    // var focusValue     = document.getElementById('focusValue');
    // focusTimeStamp = " ";
    // focusValue     = " ";
    // DEBUG display
    // if (slideDir == 0) focusValue.innerHTML     = " "; 
    // focusTimeStamp.innerHTML = "onTouchEnd,target id = " + theTarget.id + ", event = " + theEvent.type + ", dir = " + slideDir + ", start = " + strt + ", end = " + endX;    
   
    // theTarget.dispatchEvent(theEvent);
    
    // Set the local VAR for the touched X-position. 
    // This position is used by the showPlotDisplayValues() 
    // when there is only a touch and not a slide
    tempX = endX;
    
    jcp.slidegraph();
    }
  };

//////////////////////////////////////////////////////////////////////////////////////////
// slideGraph 
//////////////////////////////////////////////////////////////////////////////////////////
this.slidegraph = function() {
  
    var direction = "None";

    // alert("Slide graph = " + slideDirection );

    if (this.slideDirection > 0) direction = "Right"; 
    if (this.slideDirection < 0) direction = "Left"; 
    
    // window.console.log("slidegraph: " + direction + " (from: " + this.startingX + " to: " + this.endingX + ")" + minuteSecond());  

    // var result   = document.getElementById('sliderBar');

    if (this.slideDirection == 0) 
    {
    // result.innerHTML = "Slide Direction: None";
    // No slide detected, just a touch, so display value near the touch
    this.showPlotDisplayValues();
    return;
    }
    
    var newStartIndex = this.getCurrentPlotIndex(); 
    
    if (this.slideDirection > 0) {       
      newStartIndex = newStartIndex + this.getNbrOfSamples();     // direction = "Right"; 
      if (newStartIndex >= this.plotData.length) return;
      this.setCurrentPlotIndex(newStartIndex); 
    }  
      
    if (this.slideDirection < 0) { 
      newStartIndex = newStartIndex - this.getNbrOfSamples();     // direction = "Left";   
      if (newStartIndex < 0) newStartIndex = 0; 		    
      this.setCurrentPlotIndex(newStartIndex); 
    }
    
    // Redraw the Grid 
    this.drawGrid();    

    this.setCurrentFocusIndex(-1);
    this.previousFocus = -1;
  }

//////////////////////////////////////////////////////////////////////////////////////////
// loadSlideDetector 
//////////////////////////////////////////////////////////////////////////////////////////
this.loadSlideDetector = function(elementName) {
    
    // window.console.log("loadSlideDetector for: " + elementName);

  if (this.slideElement == null) {
  	
    var slideResult = document.getElementById(elementName);

    this.slideElement = new this.SlideDetector(slideResult);

    // slideResult.addEventListener('click', this, false);
    }

  }


this.drawHistoryTable = function()
{
	
    // Display the History Data in a Table
    var tableDataDiv = document.getElementById('jciTableDataPane');
    var reccnt = this.plotData.length;
    var lbl = "1 - " + reccnt;
    
    if (this.histTable.length == 0)
      {
      // Draw the Outer Table and the Table Headers	
      this.histTable = 
        "<table width='98%' cellspacing='0' class='table'>" +
        "  <tr>" +
        "    <th>" + lbl + "</th>" +
        "    <th>Timestamp</th>" + 
        //"    <th>Flags</th>" + 
        "    <th>Status</th>" + 
        "    <th>Value</th>" + 
        "  </tr>";
      // Draw all of the table rows
      for (i=0; i < this.plotData.length; i++)
        {
        var idx = i + 1;
        this.histTable = this.histTable +	
          "<tr>" +  
          "  <td>" + idx + "</td>" +   
          "  <td>" + this.plotTime[i] + "</td>" +  
          // "  <td>" + {start} + "</td>" + 
          "  <td>" + this.plotFlgSta[i] + "</td>" +
          "  <td>" + this.getPlotDataDisplayValue(i) + "</td>" + 
          "</tr>";	
        }	
      
      // Close off the table
      this.histTable = this.histTable +
        "</table>"; 
      }
      	
    tableDataDiv.innerHTML = this.histTable;    
	
}

this.getPlotDataDisplayValue = function(idx) 
{
  var disp = "";

  if (this.isDiscrete) 
  {
    disp = this.getDiscreteValueText(this.plotData[idx]); 	
  } else {
    disp = this.plotData[idx] + " " + this.getNumericUnits();	
  }		
  
  return disp;	
}	

this.showHistoryTable = function(histName)
{
   if (histName != this.currentHist)
   {
     this.currentHist = histName;
     this.histTable   = "";
   } 
   
   // Show the History Table DIV
   if (document.getElementById('jciTableDataPane')) 
   {       
       document.getElementById('jciTableDataPane').style.display = "block";
       document.getElementById('showHistoryGraphBtn').style.display = "block";

   } 

   // Hide the Graph DIV
   if (document.getElementById('jciLineChartPane')) 
   {       
       document.getElementById('jciLineChartPane').style.display = "none";
       document.getElementById('showHistoryTableBtn').style.display = "none";
       document.getElementById('historyInformation').style.display = "none";
   } 
 
   this.setFastTrend(false);
   this.drawHistoryTable();
   
   this.isGraphDisplayed = false;	
}

this.showHistoryGraph = function(histName)
{
   if (histName != this.currentHist)
   {
     this.currentHist = histName;
     this.histTable   = "";
   } 
    
   // Hide the History Table DIV
   if (document.getElementById('jciTableDataPane')) 
   {       
       document.getElementById('jciTableDataPane').style.display = "none";
       document.getElementById('showHistoryGraphBtn').style.display = "none";
       document.getElementById('historyInformation').style.display = "none";
   } 

   // Show the Graph DIV
   if (document.getElementById('jciLineChartPane')) 
   {       
       document.getElementById('jciLineChartPane').style.display = "block";
       document.getElementById('showHistoryTableBtn').style.display = "block";
   } 
   
   if (this.isElementExists("isLiveHistory"))
   {
     this.setFastTrend(true);
   } else 
   {
     this.setFastTrend(false);	
   }
  
   var showNewest = this.getRadioChecked("showNewest");
   var dispIndex = 0;
   if (showNewest == "true") {
     dispIndex = this.plotData.length + 1; 		//- jcp.getNbrOfSamples();
   }            
   this.setCurrentPlotIndex(dispIndex);
   this.drawGrid();
   
   this.isGraphDisplayed = true;		
}

this.showHistoryInfo = function()
{
    
   // Hide the History Table DIV
   if (document.getElementById('jciTableDataPane')) 
   {       
       document.getElementById('jciTableDataPane').style.display = "none";
       if (document.getElementById('jciLineChartPane')) { 
       	 document.getElementById('jciLineChartPane').style.display = "none";
         document.getElementById('showHistoryTableBtn').style.display = "none";
         }
   } 

   // Show the History Information DIV
   if (document.getElementById('historyInformation')) 
   {       
       document.getElementById('historyInformation').style.display = "block";
       if (document.getElementById('jciLineChartPane')) { 
         document.getElementById('showHistoryGraphBtn').style.display = "block";
         }
   } 
   
   this.setFastTrend(false);
   this.isGraphDisplayed = false;		
}
	
//////////////////////////////////////////////////////////////////////////////////////////
// Fast Trend Functions
//
//   setFastTrend
//   startFastTrendInterval
//   stopFastTrendInterval
//   refreshFastTrend 
//
//////////////////////////////////////////////////////////////////////////////////////////

this.isElementExists = function(elemName) {

  if (document.getElementById(elemName) ) 
  {
  	//window.console.log("isElementExists name: " + elemName);
  	return true;
  } else {
	return false;	
  }
}  
	
this.getRadioChecked = function(radioName) {

  var radioValue = "";
  
  // See if the Radio input exists 
  if (document.getElementsByName(radioName)) 
   { 
     // Loop through the Radio elements 	
     for (var i=0; i < document.getElementsByName(radioName).length; i++)
     {
       // see if this radio element is checked	
       if (document.getElementsByName(radioName)[i].checked)
       {
         radioValue = document.getElementsByName(radioName)[i].value;
         // window.console.log("getRadioChecked name: " + radioName + " value: " + radioValue);
       }
     } // FOR	      
       
   } // IF element exists
   	
  return radioValue;	
}


this.setFastTrend = function(enabled) {

  if (enabled == true) {
  
    if (document.getElementById("pauseLiveHistory")) 
    {
      var pauseElem = document.getElementById("pauseLiveHistory");  
      var paused    = pauseElem.getAttribute("value");
      if (paused == "live") {
        this.startFastTrendInterval();
        // window.console.log("setFastTrend ON"); 
      }
    } else {
      this.startFastTrendInterval();
      // window.console.log("setFastTrend ON"); 
    }
               
  } else {
    this.stopFastTrendInterval();
    // window.console.log("setFastTrend OFF"); 
  }
  
  // jcp.isElementExists('isLiveHistory'); 
  // jcp.getRadioChecked('barOrLine');
  // jcp.getRadioChecked('showNewest');  
  // jcp.getRadioChecked('pauseLive');

}

this.startFastTrendInterval = function() {
  
  if (this.fastTrendTimer=="") 
  {  
    this.fastTrendTimer = window.setInterval("jcp.refreshFastTrend()", this.fastTrendRateMs);
        
    // window.console.log("FastTrend START Interval: " + this.fastTrendTimer + " Interval: " + this.fastTrendRateMs);      
  }
  
}

this.stopFastTrendInterval = function() {
  
  // window.console.log("FastTrend STOP Interval: " + this.fastTrendTimer);
  
  if (this.fastTrendTimer != "") {
    // window.clearInterval(this.fastTrendTimer);
    this.fastTrendTimer = "";
  }
  
}

this.refreshFastTrend = function() {

  var sURL = window.location.href; 	//unescape(window.location.pathname);
  // window.location.replace( sURL );
  // window.location.reload(true);
  this.loadLiveHistoryData(sURL);

  // window.console.log("FastTrend Refreshed at: " + minuteSecond() + ", dataLen = " + this.plotData.length + ", loc = " + sURL);
  
}


this.loadLiveHistoryData = function(historyOrd)  // id = liveHistoryData
{
  var dataDiv = "liveHistoryData"; 
  	
  if (document.getElementById(dataDiv) == null)
  {   	
    alert("data div not found");
    return;
  }  
  
  if (window.XMLHttpRequest)
  { // code for IE7+, Firefox, Chrome, Opera, Safari
    xmlhttp=new XMLHttpRequest();
  } else {// code for IE6, IE5
    xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
  }
  
  xmlhttp.onreadystatechange = function()
    {
    if (xmlhttp.readyState==4 && xmlhttp.status==200)
      {
      var bigHtmlString = xmlhttp.responseText; 
      var dataString = "";
      var startIndex = 0;
      var endIndex   = 0;
      
      startIndex = bigHtmlString.indexOf("liveHistoryData");
      
      if (startIndex > -1) {
      	bigHtmlString = bigHtmlString.substring(startIndex, bigHtmlString.length);	
	
        startIndex = bigHtmlString.indexOf("<script");
        endIndex   = bigHtmlString.indexOf("</script>");
        // window.console.log("DATA Resp, length = " + bigHtmlString.length + ", start = " + startIndex + ", end = " + endIndex);
      
        if ( (startIndex > -1) && (endIndex > -1) ) {
      	  dataString = bigHtmlString.substring(startIndex, endIndex+9);
      	  // window.console.log("DATA = " + dataString);
        }
      	
        document.getElementById(dataDiv).innerHTML = dataString;  	// xmlhttp.responseText;
        dataString = dataString.substring(31, dataString.length-9);
        // window.console.log("eval DATA = " + dataString);
        
        eval(dataString);
        // window.console.log("after eval DATA = " + jcp.plotData[0] + "," + jcp.plotData[1]+ "," + jcp.plotData[2]);
        // plotData=plotData;
        var showNewest = jcp.getRadioChecked("showNewest");
        var dispIndex = 0;
        if (showNewest == "true") {
          dispIndex = jcp.plotData.length + 1; 		// - jcp.getNbrOfSamples();  
        }
        	        
        jcp.setCurrentPlotIndex(dispIndex);
        
        // window.console.log("after setCurrentPlotIndex DATA = " + plotData[0] + "," + plotData[1]+ "," + plotData[2]);
  	jcp.drawGrid();
        // window.console.log("after drawGrid DATA = " + jcp.plotData[0] + "," + jcp.plotData[1]+ "," + jcp.plotData[2]);
  	
        }
      }
    } 
    
  // xmlhttp.open("GET","http://localhost/file/test/"+str,true);
  xmlhttp.open("GET", historyOrd, true);
  xmlhttp.send(); 

} 

//////////////////////////////////////////////////////////////////////////////////////////	
//  
//////////////////////////////////////////////////////////////////////////////////////////	
 
this.getPortableDeviceInfo = function() {

  var portableDeviceElem = null;  
  var deviceOrient       = "nothing";
  var deviceWidth        = 0;
  var deviceHeight       = 0;
  var nbrOfSamples       = 20;
	
  if (document.getElementById("portableDevice")) 
    {
    portableDeviceElem = document.getElementById("portableDevice");  
    deviceOrient       = portableDeviceElem.getAttribute("orient");
    deviceWidth        = portableDeviceElem.getAttribute("width");
    deviceHeight       = portableDeviceElem.getAttribute("height");
  }
     
  if (deviceWidth > 500) {
    nbrOfSamples = 30; 
  }
     
  if (deviceWidth > 700) {
    nbrOfSamples = 40; 
  }
     
  if (deviceWidth > 900) {
    nbrOfSamples = 50; 
  }
       
  jcp.setNbrOfSamples(nbrOfSamples);     
       
//  if (!IE) {
//    window.console.log("getPortableDeviceInfo, orient = "   + deviceOrient + 
//                                             ", width = "   + deviceWidth  + 
//                                             ", height = "  + deviceHeight + 
//                                            ", samples = "  + nbrOfSamples);
//  }
  
}
 
//////////////////////////////////////////////////////////////////////////////////////////
// Drawing Functions
//////////////////////////////////////////////////////////////////////////////////////////

  /**
   * Draws a line between the two points using the
   * current pen and brush.
   */
  this.drawLine = function(g, x1, y1, x2, y2)
  {
    g.beginPath();
    g.moveTo(x1, y1);
    g.lineTo(x2, y2);
    g.closePath();
    g.stroke();
  }

  /**
   * Draws a filled circle at the x/y position and radius using the
   * current pen and brush.
   */
  this.fillCircle = function(g, x, y, radius)
  {
      // arc(x, y, radius, startAngle, endAngle, anticlockwise);
      g.beginPath();
      g.arc(x, y, radius, 0, Math.PI*2,true);  // draw circle
      g.closePath();
      g.fill();

  }

  /**
   * Draws a circle at the x/y position and radius using the
   * current pen and brush.
   */
  this.drawCircle = function(g, x, y, radius)
  {
      // arc(x, y, radius, startAngle, endAngle, anticlockwise);
      g.beginPath();
      g.arc(x, y, radius, 0, Math.PI*2,true);  // draw circle
      g.closePath();
      g.stroke();
  }

//////////////////////////////////////////////////////////////////////////////////////////

} // END of jciPlot
