/*
 * Copyright 2010 Johnson Controls, Inc. All Rights Reserved.
 */

/**
 * jciHx
 *
 * @author    Steve Michals
 * @creation  16 Apr 2010
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */

/////////////////////////////////////////////////////////////
// TRACE 
/////////////////////////////////////////////////////////////

function trace( msg ) {

    if ( typeof(jsTrace) != 'undefined' ) {
        jsTrace.send(msg);
    } else {
        window.console.log(msg);
    }
}

function inspectValues (obj)
{
	var message = '';
	
	if (obj)
		for (var i in obj)
		{
			if ((obj[i] instanceof Function) || (obj[i] == null) ||
					(i.toUpperCase() == i))
				continue;
			
			message += i + ': ' + obj[i] + '\n';
		}
	else
		message = 'Object is null';
	
	trace(message);
}

////////////////////////////////////////////////////////////////
// getCookie
////////////////////////////////////////////////////////////////
function getCookie(NameOfCookie)
  {
    // First we check to see if there is a cookie stored.
    // Otherwise the length of document.cookie would be zero.

    if (document.cookie.length > 0) 
      { 

      // Second we check to see if the cookie's name is stored in the
      // "document.cookie" object for the page.

      // Since more than one cookie can be set on a
      // single page it is possible that our cookie
      // is not present, even though the "document.cookie" object
      // is not just an empty text.
      // If our cookie name is not present the value -1 is stored
      // in the variable called "begin".

      begin = document.cookie.indexOf(NameOfCookie+"="); 
      if (begin != -1) // Note: != means "is not equal to"
        { 
          // Our cookie was set. 
          // The value stored in the cookie is returned from the function.

          begin += NameOfCookie.length+1; 
          end = document.cookie.indexOf(";", begin);
          if (end == -1) end = document.cookie.length;
          return unescape(document.cookie.substring(begin, end)); } 
        }
        
    return null; 

    // Our cookie was not set. 
    // The value "null" is returned from the function.

}
  
////////////////////////////////////////////////////////////////
// setCookie
////////////////////////////////////////////////////////////////
function setCookie(cookieName, value, expdays)
{
  var expdate = new Date();

  expdate.setDate(expdate.getDate() + expdays);

  var cookieValue = escape(value) + ((expdays==null) ? "" : "; expires="+expdate.toUTCString());
  
  document.cookie = cookieName + "=" + cookieValue;
}

////////////////////////////////////////////////////////////////
// DOM Extensions
////////////////////////////////////////////////////////////////

/**
 * Convenience for <code>document.getElementById(id)</code>.
 */
function $(id)
{
  return document.getElementById(id);
}

////////////////////////////////////////////////////////////////
// jciHx
////////////////////////////////////////////////////////////////

var jci = new jciHx();
function jciHx()
{
////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////
// updateDuration
////////////////////////////////////////////////////////////////
 this.updateDuration = function(event) 
 {   
  var targ;              
  var e = window.event;  
  if (e.target)          
    targ = e.target;     
  else                   
    if (e.srcElement) targ = e.srcElement;  
    
  var select = targ; 
  var disabled = (select.selectedIndex < 7); 
       
  var plus = document.getElementById('plusid'); 
  if (plus.setAttribute != null) { 
     if (disabled)  
        plus.setAttribute('disabled','disabled'); 
     else  
        plus.removeAttribute('disabled');  
     }  
  var bighr = document.getElementById('bighourid'); 
  if (bighr.setAttribute != null) { 
     if (disabled)  
        bighr.setAttribute('disabled','disabled'); 
     else  
        bighr.removeAttribute('disabled');  
     }  
  var min = document.getElementById('minuteid'); 
  if (min.setAttribute != null) { 
     if (disabled)  
        min.setAttribute('disabled','disabled'); 
     else  
        min.removeAttribute('disabled');  
     }  
  var sec = document.getElementById('secondid'); 
  if (sec.setAttribute != null) { 
     if (disabled)  
        sec.setAttribute('disabled','disabled'); 
     else  
        sec.removeAttribute('disabled');  
     }  
  var millis = document.getElementById('millisid'); 
  if (millis.setAttribute != null) { 
     if (disabled)  
        millis.setAttribute('disabled','disabled'); 
     else  
        millis.removeAttribute('disabled');  
     }  
       
  } 
  
  ////////////////////////////////////////////////////////////////
  // cancelCommand
  ////////////////////////////////////////////////////////////////
  this.cancelCommand = function()
  {
    // trace("jci.cancelCommand and Reload");
    window.location.reload(true); 
  }

  ////////////////////////////////////////////////////////////////
  // pointCommand
  ////////////////////////////////////////////////////////////////
  this.pointCommand = function(pt, act)
  {
    // trace("jciHx.pointCommand, pt = " + pt + ", action: " + act);
    // Hide the Command Buttons
    if (document.getElementById('commandBtns')) {
	  document.getElementById('commandBtns').style.display = "none";  	
    }
    
    //
    // SAM - 8/25/10 Fix for Boolean "inactiveCommand" where the "Custom" duration params 
    // do not get enabled. This is due to the form having the custom duration inputs in both
    // the "active" and "inactive" command div's. If command is active, the duration will be enabled.
    // If the command is inactive, remove the Active form which contains the first set of duration params
    //     
    if (act == "inactiveCommand") {
    	// remove the "activeCommand" form
    	var actCmd = document.getElementById("activeCommand"); 
    	actCmd.parentNode.removeChild(actCmd);
    }
        
    
    // Show the Specific Action Command where the id = act + 'Command' i.e. 'overrideCommand'
    if (document.getElementById(act)) {
  	  document.getElementById(act).style.display = "block"; 
    }
    
  }
 
  //////////////////////////////////////////////////////////////////////////////
  // isNumeric   
  //   If the element's string matches the regular expression it is all numbers
  //////////////////////////////////////////////////////////////////////////////
  this.isNumeric = function(elem, helperMsg) {
	var numericExpression = /^[0-9]+$/;
	if(elem.value.match(numericExpression)){
		return true;
	}else{
		alert(helperMsg);
		elem.focus();
		return false;
    }
  }
 
 
  ////////////////////////////////////////////////////////////////
  // checkSampleSize
  ////////////////////////////////////////////////////////////////
 
  this.checkSampleSize = function(elem) {
  
    // alert("checkSampleSize = " + elem.value + ", int = " + parseInt(elem.value));
  
    // if ( isNaN( parseInt(elem.value) ) ) 
    if ( !jci.isNumeric(elem, "Please enter a number between 50-500") ) 
    {    
      elem.value = 120;
      elem.focus();
      return false;
    } 
      
    if (parseInt(elem.value) < 50) 
    {
      alert("Please enter a number between 50-500");
      elem.value = 50;
      elem.focus();
      return false;       
    } 
            
    if (parseInt(elem.value) > 500) {
       alert("Please enter a number between 50-500");
       elem.value = 500; 
       elem.focus();
       return false;
    }
    
    return true;
  }
  
  ////////////////////////////////////////////////////////////////
  // toggleZoom  Updated to show/hide div's
  ////////////////////////////////////////////////////////////////
 
  this.toggleZoom = function()
  {
    // alert("jci.toggleZoomNew"); 
    
    // Viewport meta tag 
    var viewprt = document.getElementById("viewport"); 
    var attr    = viewprt.getAttribute("content");
    
    // pxviewsize meta tag
    var pxvwszelem  = document.getElementById("pxviewsize");   
    var pxvwsz      = pxvwszelem.getAttribute("content");

    // zoom meta tag
    var zoomelem = document.getElementById("zoom");   
    var zoom     = zoomelem.getAttribute("content");
    
    var orient = null;
    if (window.orientation) orient = window.orientation;
           
    // trace("jci.toggleZoom, viewport content BEFORE = " + attr); 
    // alert("jci.toggleZoom, pxviewsz content BEFORE = " + pxvwsz + ", zoom = " + zoom); 
     
    var pxsz = 0;
    
    if (zoom == null) {
       zoom = "off";
       // trace("jci.toggleZoom, no zoom attr found, dw= " + dw + ", dh= " + dh);
    }
    
    if (pxvwsz != null) {
       pxsz = pxvwsz;
       // trace("jci.toggleZoom, px view size = " + pxsz + ", dw = " + dw + ", dh = " + dh + ", iw = " + iw + ", ih = " + ih);
    } else {
       pxsz = hx.getScreenWidth();
       // trace("jci.toggleZoom, no pxsz, W=" + pxsz + ", H=" + hx.getScreenHeight());
    }   
          
    if (zoom != null) 
    {                
       if (zoom == "on")                
       { // Toggle to OFF
         
         // Show the ZoomIn DIV
         if (document.getElementById('zoomin')) {       
            document.getElementById('zoomin').style.display = "block";
         } 

         // Hide the ZoomOut DIV
         if (document.getElementById('zoomout')) {       
            document.getElementById('zoomout').style.display = "none";
         } 

         // Set the zoom meta tag to OFF
         zoomelem.setAttribute("content", "off");

         // Set the viewport meta tag for proper iPhone zooming 
         viewprt.setAttribute("content", "width=device-width; initial-scale=1.0, maximum-scale=1.0; user-scalable=no"); 
         
         // Simplify to only reloading the screen which will set to Defaults
         window.location.reload(true);
          
       } else {  
         // Toggle to ON

         // Hide the Zoom In div
         if (document.getElementById('zoomin')) {       
            document.getElementById('zoomin').style.display = "none";
         } 

         // Show the Zoom Out div
         if (document.getElementById('zoomout')) {       
            document.getElementById('zoomout').style.display = "block";
         } 

         // Set the zoom meta tag to ON
         zoomelem.setAttribute("content", "on");
 
         // Set the viewport meta tag for proper iPhone zooming 
         if (pxsz > 480) {
            var viewattr = "width=" + pxsz + "; minimum-scale=0.25; maximum-scale=3.0; user-scalable=yes";
            viewprt.setAttribute("content", viewattr);
            window.resizeTo(dw, dh);
         } else {
            if (pxsz > 320) {
               viewprt.setAttribute("content", "width=480; minimum-scale=0.25; maximum-scale=3.0; user-scalable=yes"); 
            } else { 
               viewprt.setAttribute("content", "width=device-width; minimum-scale=0.25; maximum-scale=3.0; user-scalable=yes"); 
            }
         }
       }  
    }
                        
    // VIEWPORT SETTINGS
    //   To keep screen from changing size when rotating:
    //      content= "width=device-width; initial-scale=1.0, maximum-scale=1.0; user-scalable=0"  
    //   To allow for screen Scaling: 
    //      content= "width=device-width; user-scalable=yes"
  }
 
/***************************************************************************/
/*  Show Alarm Details (was in alarm.js)   */
/***************************************************************************/

  this.showAlarmDetails = function(name)
  {
    var body = "showAlarmDetails,"+name;
    
    document.cookie = "alarmDetails=" + escape(name);
    
    // trace( "showAlarmDetails, body = " + body);
    // trace( "showAlarmDetails,  loc = " + window.location);
    // trace( "showAlarmDetails, cookie = " + getCookie("alarmDetails"));
    
    var msg = new Message();
    msg.setHeader("Content-Type", "application/x-niagara-hx-update");    
    msg.send(window.location, body, this.doInvokeDetail);
  }
 
  this.doInvokeDetail = function(resp)
  {
  var text = resp.responseText;
  var detailsLoc = window.location + "/alarmrecord";
  
  // Replace the windows.location that points to the Alarm Console to the HxAlarms object.
  // This happens when you click the Alarm button in a Graphic and then click "Details" in the Alarm Summary.
  detailsLoc = detailsLoc.replace("Services/AlarmService/AlarmConsole", "fxApp/HxAlarms");
 
  // alert( "doInvokeDetail, assigning to window: " + detailsLoc);
   
  if (text == "null") 
    {
      // trace( "doInvokeDetail, assigning to window: " + detailsLoc);
      
      window.location.assign(detailsLoc);
      
      return;
    }
    
    if (text == "") 
    {
      // trace( "doInvokeDetail, assign to window: " + detailsLoc);
      
      window.location.assign(detailsLoc);
      
      return;
    }
    
    return;
  }
  
  this.showEquipmentInfo = function(detailsName)
  {

    // Show the Equipment Details DIV
    if (document.getElementById(detailsName)) 
      {     
   	  var showInfo = "show" + detailsName; 	
   	  var hideInfo = "hide" + detailsName;
   	  
	  document.getElementById(detailsName).style.display = "block";
	  document.getElementById(showInfo).style.display = "none";
	  document.getElementById(hideInfo).style.display = "block";
      } 
  }

  this.hideEquipmentInfo = function(detailsName)
  {

    // Hide the Equipment Details DIV
    if (document.getElementById(detailsName)) 
      {       
   	  var showInfo = "show" + detailsName; 	
   	  var hideInfo = "hide" + detailsName;
   	  
	  document.getElementById(detailsName).style.display = "none";
	  document.getElementById(showInfo).style.display = "block";
	  document.getElementById(hideInfo).style.display = "none";
      } 
  } 
  
} // END of jciHx 


