//
// Copyright 2010, Tridium, Inc. All Rights Reserved.
//

/**
 * @fileOverview Utility methods for the Mobile Px App.
 *
 * @author Gareth Johnson
 * @version 0.0.1.0
 */

//JsLint options (see http://www.jslint.com )
/*jslint rhino: true, onevar: false, plusplus: true, white: true, undef: false, nomen: false, eqeqeq: true, bitwise: true, regexp: true, newcap: true, immed: true, strict: false, indent: 2, vars: true, continue: true */

/*global $, baja, BaseBajaObj, window, niagara*/ 

/**
 * @namespace Niagara Util Px
 */ 
niagara.util.namespace("niagara.util.px");

/**
 * @namespace Niagara Px Util
 */  
niagara.util.px.mobile = (function pxMobileUtil(baja) {
   // Use ECMAScript 5 Strict Mode
  "use strict";
  
  niagara.util.require(
    "$.mobile",
    "niagara.util.mobile.dialogs"
  );
  
  var dialogs = niagara.util.mobile.dialogs,
      util = niagara.util;
    
  /**
   * Utility method for asking the user whether they want to save before 
   * invoking the specified function
   *
   * @name niagara.util.px.mobile.saveModifyQuestion
   * @function
   *
   * @param widget
   * @param {Function} yesNoFunc
   * @param {Function} cancelFunc
   */
  function saveModifyQuestion(widget, yesNoFunc, cancelFunc) {
    var root = widget.getRootContainer();
    cancelFunc = cancelFunc || baja.noop;
    
    if (root.isWidgetTreeModified()) {
      dialogs.confirmAbandonChanges({
        viewName: root.getPxPage().getDisplayName(),
        yes: function (cb) {
          root.saveWidgets(function () {
            yesNoFunc(/*modified*/true);
            cb.ok();
          });
        },
        no: function (cb) {
          root.clearWidgetTreeModified();
          yesNoFunc(/*modified*/true);
          cb.ok();
        },
        cancel: function(cb) {
          cancelFunc();
          cb.ok();
        }
      });
      return true;
    }
    else {    
      // Simply refresh the web page
      yesNoFunc(/*modified*/false);
      return false;
    }
  }
  
  /**
   * Hyperlink to the given ORD and confirm with user if any 
   * changes need to be saved.
   *
   * @name niagara.util.px.mobile.hyperlink
   * @function
   *
   * @param widget
   * @param {baja.Ord} ord the ORD to hyperlink too
   */
  function hyperlink(widget, ord) {  
    if (ord === baja.Ord.DEFAULT) {
      return false;
    }
    
    // TODO: this is still a bit too sloopy. The problem comes down to
    // whether BajaScript is aware of all the ORDs in question
    
    // Attempt to create a relative ORD if needed
    if (ord.toString().match(/^slot/)) {
      // Create the ORD we're going to hyperlink too
      ord = baja.Ord.make({
        base: widget.getRootContainer().getPxPage().getViewOrd(),
        child: ord
      });
    }
        
    saveModifyQuestion(widget, function hyplink() {
      util.mobile.linkToOrd(ord);
    });
        
    return true;
  }
    
  return {
    saveModifyQuestion: saveModifyQuestion,
    hyperlink: hyperlink
  };
}(baja));
