//Theme Frost

//=============================================================================
// definitions - define like so:
//      #define foo = lightpurple;
// then reference like so:
//      background-color: $foo;
// NSS will expand it out as if you had written:
//      background-color: lightpurple;
//
// definitions must be at the top of the NSS file!
//
// gotcha: there can be no space between a function and the opening (
//=============================================================================

#define glassMenu = 
	lineargradient(
		stop(2%, #333) stop(3%, #ffffff) stop(4%, #E2E2E2) 
		 stop(100%, #F2F2F2) 
		angle(90) );
		
#define frostGrad = 
	lineargradient(
		stop(20%, #3c98c9) stop(90%, #1e5e8a) 
		angle(270) );
    
#define topMenu = 
	lineargradient(
		stop(0%, #ffffff) stop(100%, #e7e7e7) 
		angle(90) );
						
#define blueGradient = 
	lineargradient(
		stop(0%, #356aa0) stop(100%, #5085bb) 
		angle(90) );
						
#define windowGradient = 
	lineargradient(
		stop(0%, #f4f8fd) stop(70%, #ffffff) 
		angle(270) );

//=============================================================================
// common attributes (required)
//=============================================================================

font-families {
  sansserif: Arial, DejaVu Sans Condensed, DejaVu Sans, Nimbus Sans L, Tahoma;
  monospaced: Courier New, DejaVu Sans Mono;
}

font: 12pt sansserif;
bold-font: bold 12pt sansserif;
large-font: 16pt sansserif;
large-bold-font: bold 16pt sansserif;
fixed-font: 12pt monospaced;
fixed-bold-font: bold 12pt monospaced;

color: #000;
background-color: #f9f9f9;
auxiliary-color: #a4a098;
outline: #000; 
highlight: #FFF; 
shadow: #707070;

//window-color and window-background-color included to keep legacy widgets happy
//wherever possible, please use color and background-color instead
window-color: #000;
window-background-color: #fff;

drop-ok-color: #fff;
drop-ok-background-color: #21a121;

.disabled {
	color: #666;
	background-color: #d4d0c8;
	outline: #666;
	highlight: #FFF; 
	shadow: #999;
}

.readonly {
  background-color: #d4d0c8;
}

label {
  font: 12pt sansserif;
  //color:#000;             //default: control-color enabled color  

  .strong {
    font: bold 12pt sansserif;
  }
  
  .large {
    font: 14pt sansserif;
  }
  
  .error {
    color: #a00;
  }
  
  .warning {
    color: #ce5e04;
  }
  
  .message {
    color: #090;
  }
  
  .trace {
    color: #666;
  }
  
  .emphasized {
    font: italic 12pt sansserif;
  }

  .hyperlink {
    color: #00c;
    font: underline 12pt sansserif;
  }
  
}

focus-color: #0a246a;

selection-color: #fff;
selection-background-color: #2977a9;

//=============================================================================
// widget-specific attributes
//=============================================================================



//================================
//   TOOLBAR (ICONS)
//================================
button {
  font: bold 12pt sansserif;
	
	.toolbar {
		#commands-back 			{ background-image: 'module://icons/x24/toolbar/btn_back.png'; }
		//#commands-closeTab 	{ background-image: 'module://icons/x24/toolbar/'; }
		#commands-copy 			{ background-image: 'module://icons/x24/toolbar/btn_copy.png'; }
		#commands-cut 			{ background-image: 'module://icons/x24/toolbar/btn_cut.png'; }
		#commands-delete 		{ background-image: 'module://icons/x24/toolbar/btn_delete.png'; }
		#commands-duplicate 	{ background-image: 'module://icons/x24/toolbar/btn_duplicate.png'; }
		#commands-export 		{ background-image: 'module://icons/x24/toolbar/btn_export.png'; }
		#commands-find 			{ background-image: 'module://icons/x24/toolbar/btn_search.png'; }
		#commands-findNext 		{ background-image: 'module://icons/x24/toolbar/btn_searchNext.png'; }
		#commands-findPrev 		{ background-image: 'module://icons/x24/toolbar/btn_searchPrev.png'; }
		#commands-forward 		{ background-image: 'module://icons/x24/toolbar/btn_next.png'; }
		#commands-home 			{ background-image: 'module://icons/x24/toolbar/btn_home.png'; }
		#commands-open 			{ background-image: 'module://icons/x24/toolbar/btn_open.png'; }
		#commands-paste 		{ background-image: 'module://icons/x24/toolbar/btn_paste.png'; }
		#commands-recentOrds 	{ background-image: 'module://icons/x24/toolbar/btn_recentOrds.png'; }
		#commands-redo 			{ background-image: 'module://icons/x24/toolbar/btn_redo.png'; }
		#commands-refresh 		{ background-image: 'module://icons/x24/toolbar/btn_refresh.png'; }
		#commands-refreshtabs	{ background-image: 'module://icons/x24/toolbar/btn_refreshTabs.png'; }
		#commands-save 			{ background-image: 'module://icons/x24/toolbar/btn_save.png'; }
		#commands-saveBog		{ background-image: 'module://icons/x24/toolbar/btn_saveBog.png'; }
		#commands-sessionInfo   { background-image: 'module://icons/x24/toolbar/btn_info.png'; }
		#commands-sideBarMenu 	{ background-image: 'module://icons/x24/toolbar/btn_sidebar.png'; }
		#commands-undo 			{ background-image: 'module://icons/x24/toolbar/btn_undo.png'; }
		#commands-upLevel 		{ background-image: 'module://icons/x24/toolbar/btn_up.png'; }
		
		// Wire Sheet
		#commands-zoomIn 		{ background-image: 'module://icons/x24/toolbar/btn_zoomIn.png'; }
		#commands-zoomOut 		{ background-image: 'module://icons/x24/toolbar/btn_zoomOut.png'; }
		#commands-zoomReset 	{ background-image: 'module://icons/x24/toolbar/btn_zoomReset.png'; }
		#commands-deleteLinks { background-image: 'module://icons/x24/toolbar/btn_deleteLinks.png'; }
		
		// Slot Sheet
		#slotsheet-commands-add { background-image: 'module://icons/x24/toolbar/btn_add.png'; }
		#slotsheet-commands-rename { background-image: 'module://icons/x24/toolbar/btn_rename.png'; }
		#commands-configFlags { background-image: 'module://icons/x24/toolbar/btn_flag.png'; }
		#commands-reorder { background-image: 'module://icons/x24/toolbar/btn_reorder.png'; }
		
		// PX edit mode
		#commands-px-editMode { background-image: 'module://icons/x24/toolbar/btn_edit.png'; }
		#commands-align-left { background-image: 'module://icons/x24/toolbar/btn_alignLeft.png'; }
		#commands-align-center { background-image: 'module://icons/x24/toolbar/btn_alignCenter.png'; }
		#commands-align-right { background-image: 'module://icons/x24/toolbar/btn_alignRight.png'; }
	 	#commands-align-top { background-image: 'module://icons/x24/toolbar/btn_alignTop.png'; }
		#commands-align-middle  { background-image: 'module://icons/x24/toolbar/btn_alignMiddle.png'; }
		#commands-align-bottom { background-image: 'module://icons/x24/toolbar/btn_alignBottom.png'; }
		#commands-bringToFront { background-image: 'module://icons/x24/toolbar/btn_zorderToFront.png'; }
		#commands-sendToBack { background-image: 'module://icons/x24/toolbar/btn_zorderToBack.png'; }
		#commands-normalTool { background-image: 'module://icons/x24/toolbar/btn_pointer.png'; }
		#commands-addPolygonTool { background-image: 'module://icons/x24/toolbar/btn_polygon.png'; }
		#commands-addPathTool { background-image: 'module://icons/x24/toolbar/btn_path.png'; }
		#commands-addPointTool { background-image: 'module://icons/x24/toolbar/btn_add.png'; }
		#commands-deletePointTool { background-image: 'module://icons/x24/toolbar/btn_subtract.png'; }
		
		// + and -
		//#commands-add
		//#commands-remove
		
		// PX bound ORDs sidebar
		//#boundOrds-relativize
		//#boundOrds-replace

		background-color: none;
		selection-background-color: white;
		outline: #ADADAD;
		highlight: #EDEDED; 
		shadow: #9E9E9E;
	}
	
	 
  //override the bold font applied to regular buttons
  checkbox {
    font: 12pt sansserif;
  }
  
  radio {
    font: 12pt sansserif;
  }
}
//=============== end ============


//================================
//   MENU AND MENU ITEMS (TOP BAR)
//================================
menu {
	background-color: #ffffff;
	outline: #999; 
	highlight: #FFf; 
	shadow: #707070;

	padding: 3;						//default: 3
}

menu-bar {
	font: 12pt sansserif;
	item-padding: 2 7; 				//default: 2 7
	bar-padding: 1;					//default: 1
	
	color: #666;
	background-color: $topMenu;
	outline: #999;
	highlight: #FFf;
	shadow: #707070;
}

menu-item {
	font: 12pt sansserif;
	color: #000;
	background-color: #ffffff;
	padding: 2 14 4 22; 				//default: 2 14 2 22
	icon-indent: 2; 					//default: 2
	
	.disabled {
		highlight: none;
		shadow: #666;
	}

	accelerator {
		font: 10pt sansserif; 			//default: menu-item font -1 point
		color: #333;
	}
}
//=============== end ============


//================================
//   PATHBAR(BELOW MENU BAR)
//================================
path-bar {
	color: #f8f8ff;
	font: bold 12pt sansserif;
	background-color: $frostGrad;
	outline: #919191; 
	highlight: #ccc; 
	shadow: #999;
}
//=============== end ============



pane {
	background-color: none;
	.toolbar-container {
		//background-color: #fbfbfb;
		background-color: $glassMenu;
	}
	
	.sidebar-header {
		background-color: $frostGrad;
	}
	
	grid-pane {
      band-color: #bebebe;

		.scrolled {
		  band-color: #e2e2e2;
		}
	  
  }
	
	//================================
	//   SCROLL PANE AND IS PIECES
	//================================
	scroll-pane {
		padding: 0;						//default: 0 (and you want it that way)
		background-color: #fff;
	}
	
	//================================
	//   SPLIT PANE AND IS PIECES
	//================================
	split-pane {
		divider {
			background-color: #f9f9f9;
			outline: #000; 
			highlight: #fff; 
			shadow: #707070;
		}
	}
	
	tabbed-pane {
		background-color: $frostGrad;
		.selected {
		  background-color: #eee;
		}
	}
	
	// title above certain tables like station properties
	.title {
		color: #fff;
		font: bold 12pt sansserif;
		background-color: $frostGrad;
	}
	
	//================================
	//   TOOL-PANE - nav, palette, etc.
	//================================
	tool-pane {
		outline: #333;
		font: bold 12pt sansserif;
		header {
			background-color: $glassMenu;
		}
	}
}

progress-bar {
  background-color: #fff;
  color: $frostGrad;
}


//=============== end ============

//================================
//   SCROLL BAR AND IS PIECES
//================================
scroll-bar {
	width: 15; 						//default: 15
	button {
		color: #000;
		background-color: #d4d0c8;
		outline: #000; 
		highlight: #fff; 
		shadow: #a4a098;
		
		.disabled {
			color: #707070;
			background-color: #d4d0c8;
			outline: #000; 
			highlight: #fff; 
			shadow: #a4a098;
		}
	}
	thumb {
		background-color: #eee;
		outline: #000; 
		highlight: #fff; 
		shadow: #707070;
	}
	track {
		background-color: #a4a098;
		outline: #000; 
		highlight: #d4d0c8; 
		shadow: #707070;
	}
}

//=============== end ============

separator {
	width:2;							//default: 2
	width-menu:8;					//default: 8
	width-toolbar:8;					//default: 8

	highlight: #cecece;
	shadow: #fff;
}

table {
	background-color: #fff;
  .cell-table { 
    selection-color: #000;
    selection-background-color: #c0c0ff; 
  }
	
	tree-table {
	  connector-color: #ccc;
	  expander {
	    color: #999;
	  }
	  .category-browser { band-color: #ffffbb; }
	}
}

text-editor {
	selection-color: white;
	selection-background-color: #2977a9;
}

console {
  background-color: #fff;
}

//================================
//   TREE (TREE PANE)
//================================
tree {
	font: 12pt sansserif;
	color: #000;
	background-color: #fff;
	connector-color: #ccc;			//default: ccc
	padding: 4 4;					//default: 2 4
	
	expander {
		color: #000;
		width: 9;					//default: 9, looks goofy with even nums
		height: 9;					//default: 9, looks goofy with even nums
	}
	
	property-sheet {
		background-color: #fff;
		color: #333;
		highlight: #fff; 
		shadow: #707070;
		
		header {
			background-color: #ccc;
			color: #333;
		}
		
		divider {
			color: #EDEDED;
		}

		expander {
			color: #000;			//default: 000
			width: 9;				//default: 9, looks goofy with even nums
			height: 9;				//default: 9, looks goofy with even nums
		}
	}
}

toolbar {
	scroll-speed: 120;
}

wire-sheet {
	color: #ddd;
	background-color: #eee;
	outline: #000;
	
	// note: font SIZES are ignored by the wiresheet. font FACES and STYLES are used.
	glyph {
		background-color: white;
		outline: #999;
		font: 9pt Tahoma; 
		
		title {
			title { font: bold 9pt Tahoma; }
			subtitle { font: 9pt Tahoma; }
			color: #222;
			background-color: $glassMenu;
			.cut {
				color: #6e6e6e; 
				background-color: #32969696;
			}
		}
		
		selection-color: #f00;
		selection-background-color: #000;
		
		.cut {
			background-color: #32969696;
		}
	}
	
	thumbnail {
		color: #328e06c6;
		background-color: #d2e6e6e6;
		outline: #000;
	}
}
//=============== end ============
