/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview Tutorials Profile.
 *
 * @author Gareth Johnson
 */
 
//JsLint options (see http://www.jslint.com )
/*jslint rhino: true, onevar: false, plusplus: true, white: true, undef: false, nomen: false, eqeqeq: true, 
bitwise: true, regexp: true, newcap: true, immed: true, strict: false, indent: 2, vars: true, continue: true */

/*global $, dialogs*/ 

(function profile() {
  // Use ECMAScript 5 Strict Mode
  "use strict";

  $(function () {
  
    var exampleContent = "<ul>" +
                           "<li><p><a href='/module/testBajaScript/com/tridium/bajascript/tutorials/rc/maps.html'>Google Maps</a>: A BajaScript Google Maps Mashup.</p></li>" +
                           "<li><p><a href='/module/testBajaScript/com/tridium/bajascript/tutorials/rc/bs-impress.html'>impress.js</a>: A BajaScript demo slideshow (best viewed in Chrome).</p></li>" +
                         "</ul>";
  
    // Show the examples dialog when the examples button is clicked
    $("#examples").click(function (event) {        
      dialogs.cancel({
        title: "BajaScript Examples",
        content: exampleContent
      });                   
      return false;
    });
    
    // Write the copyright text out dynamically
    $("#copyrightLink").html("Copyright &#169; " + new Date().getFullYear() + " Tridium, Inc.");
  });

}());