//
// Copyright 2010, Tridium, Inc. All Rights Reserved.
//

// JsLint options (see http://www.jslint.com )
/*jslint rhino: true, onevar: false, plusplus: false, white: true, undef: true, nomen: true, eqeqeq: true, bitwise: true, regexp: false, newcap: true, immed: true, strict: false, indent: 2 */

// Globals for JsLint to ignore 
/*global test, baja, BaseBajaObj, errTest, describe, it, verify*/

var virtTest = { version: 1.0 };

(function virtTest() {
  "use strict";
  
  describe("virtuals", function testVirtuals() {
    
    it("valid name", function testValidName() {
      // good names
      verify(baja.VirtualPath.isValidName("a"));
      verify(baja.VirtualPath.isValidName("A"));
      verify(baja.VirtualPath.isValidName("z"));
      verify(baja.VirtualPath.isValidName("zeta"));
      verify(baja.VirtualPath.isValidName("Z"));
      verify(baja.VirtualPath.isValidName("abc"));
      verify(baja.VirtualPath.isValidName("abc_ABC"));
      verify(baja.VirtualPath.isValidName("a0"));
      verify(baja.VirtualPath.isValidName("a_0_"));
      verify(baja.VirtualPath.isValidName("z9"));
      verify(baja.VirtualPath.isValidName("a.~`!@#%^&*()_-+=\\}]{[\"';<,>.?00"));
      verify(baja.VirtualPath.isValidName("a.~`!@#%^&*()_-+=\\}]{[\"';<,>.?aa"));
      verify(baja.VirtualPath.isValidName("a.~`!@#%^&*()_-+=\\}]{[\"';<,>.?ff"));
      verify(baja.VirtualPath.isValidName("a.~`!@#%^&*()_-+=\\}]{[\"';<,>.?AA"));
      verify(baja.VirtualPath.isValidName("a.~`!@#%^&*()_-+=\\}]{[\"';<,>.?FF"));
      verify(baja.VirtualPath.isValidName("a.~`!@#%^&*()_-+=\\}]{[\"';<,>.?AA"));
      verify(baja.VirtualPath.isValidName("a.~`!@#%^&*()_-+=\\}]{[\"';<,>.?FF"));
      verify(baja.VirtualPath.isValidName("a.~`!@#%^&*()_-+=\\}]{[\"';<,>.?u01AB"));
      verify(baja.VirtualPath.isValidName("a.~`!@#%^&*()_-+=\\}]{[\"';<,>.?u0000"));
      verify(baja.VirtualPath.isValidName(".~`!@#%^&*()_-+=\\}]{[\"';<,>.?20"));
      verify(baja.VirtualPath.isValidName(".~`!@#%^&*()_-+=\\}]{[\"';<,>.?20xx"));
      verify(baja.VirtualPath.isValidName(".~`!@#%^&*()_-+=\\}]{[\"';<,>.?u01AB"));
      verify(baja.VirtualPath.isValidName("9"));
      verify(baja.VirtualPath.isValidName("2bad"));
      verify(baja.VirtualPath.isValidName("_"));
      verify(baja.VirtualPath.isValidName(".."));
      verify(baja.VirtualPath.isValidName("a.."));
      verify(baja.VirtualPath.isValidName("a..0"));
      verify(baja.VirtualPath.isValidName("a..0x"));
      verify(baja.VirtualPath.isValidName("a..0g"));
      verify(baja.VirtualPath.isValidName("a..u"));
      verify(baja.VirtualPath.isValidName("a..u0"));
      verify(baja.VirtualPath.isValidName("a..u00"));
      verify(baja.VirtualPath.isValidName("a..u000"));
      verify(baja.VirtualPath.isValidName("a..u000g"));
      verify(baja.VirtualPath.isValidName("a..u000.."));
      verify(baja.VirtualPath.isValidName("a..u000.."));
    
      // bad names
      verify(!baja.VirtualPath.isValidName("")); // blank names are not allowed in virtual paths
      verify(!baja.VirtualPath.isValidName("/"));
      verify(!baja.VirtualPath.isValidName("a/"));
      verify(!baja.VirtualPath.isValidName("a/0"));
      verify(!baja.VirtualPath.isValidName("a/0x"));
      verify(!baja.VirtualPath.isValidName("a/0g"));
      verify(!baja.VirtualPath.isValidName("a/u"));
      verify(!baja.VirtualPath.isValidName("a/u0"));
      verify(!baja.VirtualPath.isValidName("a/u00"));
      verify(!baja.VirtualPath.isValidName("a/u000"));
      verify(!baja.VirtualPath.isValidName("a/u000g"));
      verify(!baja.VirtualPath.isValidName("a/u000/"));
      verify(!baja.VirtualPath.isValidName("a/u000/b"));
      verify(!baja.VirtualPath.isValidName("|"));
      verify(!baja.VirtualPath.isValidName("a|"));
      verify(!baja.VirtualPath.isValidName("a|0"));
      verify(!baja.VirtualPath.isValidName("a|0x"));
      verify(!baja.VirtualPath.isValidName("a|0g"));
      verify(!baja.VirtualPath.isValidName("a|u"));
      verify(!baja.VirtualPath.isValidName("a|u0"));
      verify(!baja.VirtualPath.isValidName("a|u00"));
      verify(!baja.VirtualPath.isValidName("a|u000"));
      verify(!baja.VirtualPath.isValidName("a|u000g"));
      verify(!baja.VirtualPath.isValidName("a|u000|"));
      verify(!baja.VirtualPath.isValidName("a|u000|b"));
      verify(!baja.VirtualPath.isValidName("$"));
      verify(!baja.VirtualPath.isValidName("a$"));
      verify(!baja.VirtualPath.isValidName("a$0"));
      verify(!baja.VirtualPath.isValidName("a$0x"));
      verify(!baja.VirtualPath.isValidName("a$0g"));
      verify(!baja.VirtualPath.isValidName("a$u"));
      verify(!baja.VirtualPath.isValidName("a$u0"));
      verify(!baja.VirtualPath.isValidName("a$u00"));
      verify(!baja.VirtualPath.isValidName("a$u000"));
      verify(!baja.VirtualPath.isValidName("a$u000g"));
      verify(!baja.VirtualPath.isValidName("a$u000$"));
      verify(!baja.VirtualPath.isValidName("a$u000$b"));
      verify(!baja.VirtualPath.isValidName(":"));
      verify(!baja.VirtualPath.isValidName("a:"));
      verify(!baja.VirtualPath.isValidName("a:0"));
      verify(!baja.VirtualPath.isValidName("a:0x"));
      verify(!baja.VirtualPath.isValidName("a:0g"));
      verify(!baja.VirtualPath.isValidName("a:u"));
      verify(!baja.VirtualPath.isValidName("a:u0"));
      verify(!baja.VirtualPath.isValidName("a:u00"));
      verify(!baja.VirtualPath.isValidName("a:u000"));
      verify(!baja.VirtualPath.isValidName("a:u000g"));
      verify(!baja.VirtualPath.isValidName("a:u000:"));
      verify(!baja.VirtualPath.isValidName("a:u000:b"));
      verify(!baja.VirtualPath.isValidName("../"));
      verify(!baja.VirtualPath.isValidName("a../"));
      verify(!baja.VirtualPath.isValidName("a../0"));
      verify(!baja.VirtualPath.isValidName("a../0x"));
      verify(!baja.VirtualPath.isValidName("a../0g"));
      verify(!baja.VirtualPath.isValidName("a../u"));
      verify(!baja.VirtualPath.isValidName("a../u0"));
      verify(!baja.VirtualPath.isValidName("a../u00"));
      verify(!baja.VirtualPath.isValidName("a../u000"));
      verify(!baja.VirtualPath.isValidName("a../u000g"));
      verify(!baja.VirtualPath.isValidName("a../u000../"));
      verify(!baja.VirtualPath.isValidName("a../u000../"));
    });
  });

}());