//
// Copyright 2010, Tridium, Inc. All Rights Reserved.
//

//JsLint options (see http://www.jslint.com )
/*jslint rhino: true, onevar: false, plusplus: true, white: true, undef: false, nomen: false, eqeqeq: true, bitwise: true, regexp: true, newcap: true, immed: true, strict: false, indent: 2, vars: true, continue: true */

// Globals for JsLint to ignore 
/*global baja, XMLHttpRequest, errTest, describe, it, verify, verifyEq*/

var bsonTest = { version: 1.0 };

(function testBson() { 

  "use strict";
      
  describe("bson", function testBuildingJavaScriptObjectNotation() {
  
    describe("encoding", function testEncoding() {
  
      it("encode 1", function testBsonEncode1() {     
        // Test encoding a bare component
        var c = new baja.Component();
        var bson = baja.bson.encodeValue(c);    
        verifyEq(JSON.stringify(bson), '{"nm":"p","t":"baja:Component"}');
      });
      
      it("encode 2", function testBsonEncode2() {
        
        // Test Component tree
        var c = new baja.Component();    
        var c2 = new baja.Component();
        c.add({
          slot: "testProp",
          value: c2
        });
        
        c.add({
          slot: "stringProp", 
          value: "a nice String!"
        });
        
        c.add({
          slot: "doubleProp", 
          value: 12.2
        });
        
        c.add({
          slot: "intProp", 
          value: baja.Integer.make(18)
        });
        
        c2.add({
          slot: "stringProp2", 
          value: "another string"
        });
                
        var bson = baja.bson.encodeValue(c);    
            
        verifyEq('{"nm":"p","t":"baja:Component","s":[{"nm":"p","n":"testProp","t":"baja:Component",' + 
        '"s":[{"nm":"p","n":"stringProp2","t":"baja:String","v":"another string"}]},{"nm":"p",' + 
        '"n":"stringProp","t":"baja:String","v":"a nice String!"},{"nm":"p","n":"doubleProp",' + 
        '"t":"baja:Double","v":"12.2"},{"nm":"p","n":"intProp","t":"baja:Integer","v":"18"}]}', JSON.stringify(bson));
      });
      
      it("encode 3", function testBsonEncode3() { 
        var facets = baja.Facets.make(["key1", "key2"], ["value1", "value2"]);
        var bson = baja.bson.encodeValue(facets);
        verifyEq('{"nm":"p","t":"baja:Facets","v":"key1=s:value1|key2=s:value2"}', JSON.stringify(bson));
      });
      
      it("encode 4", function testBsonEncode4() { 
        var bson = baja.bson.encodeValue("This is a great test man!");
        verifyEq('{"nm":"p","t":"baja:String","v":"This is a great test man!"}', JSON.stringify(bson));
      });
    
    });
    
    it("scan for unknown types", function testScanForUnknownTypes() {
      // Some made up BSON we're going to scan for Types
      var bson = {
        nm: "p",
        t: "myModule:MyType",
        s: [{
          nm: "p",
          t: "myModule:MyOtherType",
          v: "thisAndThat"        
        },
        {
          nm: "p",
          t: "baja:Component",
          s: [{
            nm: "p",
            t: "myModule:MySuperType"
          },
          {
            nm: "p",
            t: "baja:String",
            v: "I love BS"
          }
          ]
        },
        {
          nm: "p",
          t: "myModule:MyOtherType",
          v: "thisAndThat"        
        }
        ]
      };
    
      // Scan for Types
      var ts = baja.bson.scanForUnknownTypes(bson);
      
      // Helper function
      function has(typeSpec) {
        var r = false, i;
        for (i = 0; i < ts.length; ++i) {
          if (ts[i] === typeSpec) {
            r = true;
            break;
          }
        }
        return r;
      }
      
      verifyEq(ts.length, 3);
      verify(has("myModule:MyType"));
      verify(has("myModule:MyOtherType"));
      verify(has("myModule:MySuperType"));
    }); 
  });  

}());