/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * Fake Browser Environment for running JavaScript in Rhino. This is the
 * BARE MINIMUM for getting Jasmine to work and some of the most basic
 * browser-like functionality - for real browser testing look into
 * Phantom or env.js.
 *
 * @author Logan Byam
 * @version 1.0.0.0
 */

//JsLint options (see http://www.jslint.com )
/*jslint rhino: true, onevar: false, plusplus: true, white: true, undef: false, nomen: false, eqeqeq: true, bitwise: true, regexp: true, newcap: true, immed: true, strict: false, indent: 2, vars: true, continue: true */

// Globals for JsLint to ignore 
/*global test, bajaJsPrint, window: true, location: true, error: true, boxFrameSender, java, System*/

var rhinoFakeBrowser = { version: 1.0 },
    document,
    window,
    location,
    console,
    setTimeout,
    clearTimeout,
    setInterval,
    clearInterval,
    scope = this;  
        
(function setupFakeBrowser() { 
  "use strict";

  // Initialize DOM
  (function initializeDomGlobals() { 
    window = {};
    location = {};
    window.location = {};
  
    window.document = document = {};

    document.getElementsByTagName = function() {};
    document.getElementById = function() {};
    document.body = {};
  }());
  
  // JavaScript Console
  console = (function jsConsole() {
    var buf = '',
        doPrint = (typeof bajaJsPrint !== 'undefined') ? bajaJsPrint :
                  (typeof System !== 'undefined') ? System.out.println :
                  function () {};
                  
    function print(msg) {
      var lastNewLine = msg.lastIndexOf('\n'),
          toPrint,
          toBuffer;
      if (lastNewLine >= 0) {
        toPrint = buf + msg.substring(0, lastNewLine);
        buf = '';
        toBuffer = msg.substring(lastNewLine + 1);
      }
      else {
        toBuffer = msg;
      }
      
      if (toPrint) {
        doPrint(toPrint);
      }
      
      buf += toBuffer;
    }
    
    function log(msg) {
      print(msg + '\n');
    }
    
    function error(msg) {
      log('!!! ' + msg);
    }
    
    return {
      print: print,
      log: log,
      error: error
    };
  }());
   
  // Intialize Timer API that uses the TimerThreadPoolExecutor
  (function initializeTimers() {
    var executor = test.getExecutor(),
        counter = 1,
        ids = {},
        Runnable = java.lang.Runnable;

    setTimeout = function (fn, delay) {
      var id = counter++,
          future = executor.schedule(new Runnable({run: fn}), delay);
      
      ids[id] = future;
      
      return id;
    };

    clearTimeout = function (id) {
      if (ids[id]) {
        ids[id].cancel(/*mayInterruptIfRunning*/false);
        delete ids[id];
      }
    };

    setInterval = function (fn, delay) {
      var id = counter++,
          future = executor.schedulePeriodically(new Runnable({run: fn}), delay);
      
      ids[id] = future;
      
      return id;
    };

    clearInterval = clearTimeout;
  }());
}());