/*  
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */

/**
 * RichView JavaScript support.
 *
 * @author    Andy Frank
 * @creation  28 Apr 05
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */

////////////////////////////////////////////////////////////////
// RichViewSupport
////////////////////////////////////////////////////////////////

var rich = new RichViewSupport();
function RichViewSupport()
{
  var contentType = "application/x-niagara-hx-RichView-";
  var headerId    = "x-niagara-hx-richview-id";
  
////////////////////////////////////////////////////////////////
// GET
////////////////////////////////////////////////////////////////

  /**
   * Invoke a GET request.
   */
  this.get = function(id, body)
  {
    if (body == null) body = "";
    var msg = new Message();
    msg.setHeader(headerId, id);
    msg.setHeader("Content-Type", contentType + "get");
    msg.send(window.location, body, this.doGet);
  }
  
  /**
   * Handle GET response.
   */
  this.doGet = function(resp)
  {
    try
    {
      var text = resp.responseText;
      var index = text.indexOf("@");
      var id = text.substring(0, index);
      text = text.substring(index+1);
      
      // Check for javascript
      var js = null;
      var start = text.indexOf("<script type='text/javascript'>");
      if (start != -1)
      {
        var end = text.indexOf("</script>");
        js = text.substring(start+31, end);
        
        // Remove script from text so it is not executed 
        // when added to dom. TODO - Some issues wit that?
        //var a = text.substring(0, start);
        //var b = text.substring(end+9);
        //text = a + b;
      }      
      
      // Do not try to replace content if resp
      // was purely javascript
      if (js == null || start > 0)
      {
        // Create a new element to hold markup
        var child = document.createElement("div");
        child.innerHTML = text;
        
        // TODO - This should become the default behavoir!
        if (StringUtil.startsWith(id, "__"))
        {
          // Remove existing content
          var elem = document.getElementById(id);
          for (var i=0; i<elem.childNodes.length; i++)
            elem.removeChild(elem.firstChild);
        }
        else
        {
          // Hide existing content
          var elem = document.getElementById(id);
          for (var i=0; i<elem.childNodes.length; i++)
            elem.childNodes[i].style.display = "none";
        }
                
        // Append new content
        elem.appendChild(child);
      }
            
      // Evaluate javascript after markup has been added to the DOM
      if (js != null) eval(js);
    }
    catch (err) 
    { 
      text = text.replace(new RegExp("<", "gi"), "&lt;");
      text = text.replace(new RegExp(">", "gi"), "&gt;");
      var details = "id=" + id + "<br/><br/>" + text;      
      hx.doError("rich.doGet()", details, err);
    }    
  }
  
  /**
   * Hide our dynamic content, and reshow the existing 
   * content.  This method assumes get() has previously
   * been called for this element id.  
   */  
  this.hide = function(id)
  {
    // Remove dynamic content
    var elem = document.getElementById(id);
      elem.removeChild(elem.lastChild);
    
    // Show exisiting content
    for (var i=0; i<elem.childNodes.length; i++)
      elem.childNodes[i].style.display = "block";
  }
}


