 /*
* Copyright 2007 Tridium, Inc. All Rights Reserved.
*/

/**
* HxPx
*/

////////////////////////////////////////////////////////////////
// Px
////////////////////////////////////////////////////////////////
var px = new Px();
// global instance
function Px() {

 this.setStyle = function(id, style) {
  var elem = document.getElementById(id);
  if(elem != null)
  {
   var elemStyle = elem.style;
   for(var property in style) {
    try {
     if(property in elemStyle)
      elemStyle[property] = style[property];
    }
    catch(err) {
     err.description="Invalid value '"+style[property]+"' for style "+id+"."+property+". "+err.description;
    }
   }
  } else {
   //alert(id+' not found.');
  }
 }
  
 this.setProperties = function(id, style) {
  var elem = document.getElementById(id);
  for(var property in style) {
   try {
    elem[property] = style[property];
   }
   catch(err) {
    err.description="Invalid value '"+style[property]+"' for property "+id+"."+property+". "+err.description;
   }
  }
 }

 this.setEvents = function(id, style) {
  try {
   var elem = document.getElementById(id);
   for(var property in style) {
    try {
     eval("elem." + property + "=function(event){if (!event) var event = window.event;" + style[property] + "};");
    }
    catch(err) {
     err.description="Invalid value for event "+id+"."+property;
    }
   }
  }
  catch(err) {
   err.description="Error setting events for "+id;
  }
 }
  
 // Move an object from on location in the DOM to another 
 this.move = function(id, dest) {
  try {
   document.getElementById(dest).appendChild(document.getElementById(id));
  }
  catch(err) {
   err.description="Error moving "+id+" to "+dest+". "+err.description;
  }
 }
 
 // Get the screen height
 // @depricated Use hx.getScreenHeight() instead
 this.getHeight = function() {
  var myWidth = 0, myHeight = 0;
  if( typeof( window.innerWidth ) == 'number' ) {
   //Non-IE
   myWidth = window.innerWidth;
   myHeight = window.innerHeight;
  }
   else if( document.documentElement && ( document.documentElement.clientWidth || document.documentElement.clientHeight ) ) {
   //IE 6+ in 'standards compliant mode'
   myWidth = document.documentElement.clientWidth;
   myHeight = document.documentElement.clientHeight;
  }
   else if( document.body && ( document.body.clientWidth || document.body.clientHeight ) ) {
   //IE 4 compatible
   myWidth = document.body.clientWidth;
   myHeight = document.body.clientHeight;
  }
  return myHeight;
 }
  
 // Blink a DOM element
 this.blink = function (elem, ie) {
  //blink based on current blink state for new elem coming in update
  if(ie) elem.runtimeStyle.visibility = this.blinkIt;
  else elem.style.visibility = this.blinkIt;
  this.blinkers.push(elem);
  if(this.blinkers.length == 1) {
   setInterval( function () {
    var blinkIt; for (var i = 0; i < px.blinkers.length; i++) {
     try {
      if( i == 0) {
      if(ie) px.blinkIt = (px.blinkers[i].currentStyle.visibility == "visible") ? "hidden" : "visible"; else px.blinkIt = (px.blinkers[i].style.visibility == "visible") ? "hidden" : "visible"; }
      if(ie) px.blinkers[i].runtimeStyle.visibility = px.blinkIt; else px.blinkers[i].style.visibility = px.blinkIt; }
     catch(error) //on update, elem is refreshed and no long valid, get rid of entry and move on
     {
      for (var j = i; j < px.blinkers.length - 1; j++) {
      px.blinkers[j] = px.blinkers[j + 1] }
      px.blinkers.pop(); i--; }
    }
   }
   , 400);
  }
 }
 this.blinkers = new Array();
 this.blinkIt = "visible";
 
 // Get browser information
 this.getBrowser = function () {
  var ua, s, i;
  var browser = new Object();
  browser.isIE = false;
  browser.isNS = false;
  browser.version = null;
  ua = navigator.userAgent;
  s = "MSIE";
  if ((i = ua.indexOf(s)) >= 0) {
   browser.isIE = true;
   browser.version = parseFloat(ua.substr(i + s.length));
   return browser;
  }
   s = "Netscape6/";
   if ((i = ua.indexOf(s)) >= 0) {
   browser.isNS = true;
   browser.version = parseFloat(ua.substr(i + s.length));
   return browser;
  }
   // Treat any other "Gecko" browser as NS 6.1.
   s = "Gecko";
   if ((i = ua.indexOf(s)) >= 0) {
   browser.isNS = true;
   browser.version = 6.1;
   return browser;
  }
 }
 this.browser = this.getBrowser();
  
 ////////////////////////////////////////////////////////////////
 // HxPxSplitPane
 ////////////////////////////////////////////////////////////////
 
 this.splitPane = new SplitPane();
 function SplitPane() {
  this.dragObj = new Object();
  this.valueObj = new Object();
  
  // Init dragging the split divider
  this.doStartDrag = function (event, id, valueId) {
   var el;
   var x, y;
   px.splitPane.dragObj.elNode = document.getElementById(id);
   if(valueId!=null) 
    px.splitPane.valueObj.elNode = document.getElementById(valueId);
   else
    px.splitPane.valueObj = null;
   // Get cursor position with respect to the page.
   if (px.browser.isIE) {
    x = window.event.clientX + document.documentElement.scrollLeft + document.body.scrollLeft;
    y = window.event.clientY + document.documentElement.scrollTop + document.body.scrollTop;
   }
   if (px.browser.isNS) {
    x = event.clientX + window.scrollX;
    y = event.clientY + window.scrollY;
   }
   // Save starting positions of cursor and element.
   px.splitPane.dragObj.cursorStartX = x;
   px.splitPane.dragObj.cursorStartY = y;
   px.splitPane.dragObj.elStartLeft = parseInt(px.splitPane.dragObj.elNode.style.left, 10);
   px.splitPane.dragObj.elStartTop = parseInt(px.splitPane.dragObj.elNode.style.top, 10);
   if (isNaN(px.splitPane.dragObj.elStartLeft)) px.splitPane.dragObj.elStartLeft = 0;
   if (isNaN(px.splitPane.dragObj.elStartTop)) px.splitPane.dragObj.elStartTop = 0;
   // Capture mousemove and mouseup events on the page.
   if (px.browser.isIE) {
    document.attachEvent("onmousemove", px.splitPane.doDrag);
    document.attachEvent("onmouseup", px.splitPane.doStopDrag);
    window.event.cancelBubble = true;
    window.event.returnValue = false;
   }
   if (px.browser.isNS) {
    document.addEventListener("mousemove", px.splitPane.doDrag, true);
    document.addEventListener("mouseup", px.splitPane.doStopDrag, true);
    event.preventDefault();
   }
  }
  
  // Drag the split divider  
  this.doDrag = function (event) {
   var x, y;
   // Get cursor position with respect to the page.
   if (px.browser.isIE) {
    x = window.event.clientX + document.documentElement.scrollLeft + document.body.scrollLeft;
    y = window.event.clientY + document.documentElement.scrollTop + document.body.scrollTop;
   }
   if (px.browser.isNS) {
    x = event.clientX + window.scrollX;
    y = event.clientY + window.scrollY;
   }
   // Move drag element by the same amount the cursor has moved.
   var maxPosition = parseInt(px.splitPane.dragObj.elNode["dividerMax"]);
   var orient = px.splitPane.dragObj.elNode["dividerOrient"];
   if(orient == "horiz") {
    var position = (px.splitPane.dragObj.elStartLeft + x - px.splitPane.dragObj.cursorStartX);
    position = Math.min(maxPosition, position);
    position = Math.max(0, position);
    px.splitPane.dragObj.elNode.style.left = position + "px";
   }
   else {
    var position = (px.splitPane.dragObj.elStartTop + y - px.splitPane.dragObj.cursorStartY);
    position = Math.min(maxPosition, position);
    position = Math.max(0, position);
    px.splitPane.dragObj.elNode.style.top = position + "px";
   }
   
   //hx.setFormValue(px.splitPane.dragObj.elNode.id + '.position', parseInt((position / maxPosition) * 100));
   if (px.browser.isIE) {
    window.event.cancelBubble = true;
    window.event.returnValue = false;
   }
   if (px.browser.isNS) event.preventDefault();
  }

  // Stop dragging the split divider  
  this.doStopDrag = function (event) {
   var mousePos = px.splitPane.getMouseCoords(event || window.event);
   var x, y;
   if (px.browser.isIE) {
    x = window.event.clientX + document.documentElement.scrollLeft + document.body.scrollLeft;
    y = window.event.clientY + document.documentElement.scrollTop + document.body.scrollTop;
   }
   if (px.browser.isNS) {
    x = event.clientX + window.scrollX;
    y = event.clientY + window.scrollY;
   }
   
   var maxPosition = parseInt(px.splitPane.dragObj.elNode["dividerMax"]);
   var orient = px.splitPane.dragObj.elNode["dividerOrient"];
   if(orient == "horiz") {
    var position = (px.splitPane.dragObj.elStartLeft + x - px.splitPane.dragObj.cursorStartX);
    position = Math.min(maxPosition, position);
    position = Math.max(0, position);
    px.splitPane.dragObj.elNode.style.left = position + "px";
    if(px.splitPane.valueObj!=null)
     px.splitPane.valueObj.elNode.style.left = position + "px";
   }
   else {
    var position = (px.splitPane.dragObj.elStartTop + y - px.splitPane.dragObj.cursorStartY);
    position = Math.min(maxPosition, position);
    position = Math.max(0, position);
    px.splitPane.dragObj.elNode.style.top = position + "px";
    if(px.splitPane.valueObj!=null)
     px.splitPane.valueObj.elNode.style.top = position + "px";
   }   
   hx.setFormValue(px.splitPane.dragObj.elNode.id + '.position', parseInt((position / maxPosition) * 100));
   
   px.splitPane.dragObj.elNode = null;
   // Stop capturing mousemove and mouseup events.
   if (px.browser.isIE) {
    document.detachEvent("onmousemove", px.splitPane.doDrag);
    document.detachEvent("onmouseup", px.splitPane.doStopDrag);
   }
   if (px.browser.isNS) {
    document.removeEventListener("mousemove", px.splitPane.doDrag, true);
    document.removeEventListener("mouseup", px.splitPane.doStopDrag, true);
   }
   hx.poll();
  }
  
  this.getMouseCoords = function (event) {
   if(event.pageX || event.pageY) {
    return {
     x : event.pageX, y : event.pageY};
   }
   return {
    x : event.clientX + document.body.scrollLeft - document.body.clientLeft, y : event.clientY + document.body.scrollTop - document.body.clientTop };
  }
 }
 
////////////////////////////////////////////////////////////////
// Resizing Utilities - @since Niagara 3.6   
//////////////////////////////////////////////////////////////// 
 
  this.resizeTimeout = null;
  
  /**
   *  @since Niagara 3.6   
   */
  this.resize = function( scope)
  {
    if(this.resizeTimeout == null)
      this.resizeTimeout = setTimeout("px.doResize('" + scope + "');", 500);
    else
    {
      clearTimeout(this.resizeTimeout);
      this.resizeTimeout = setTimeout("px.doResize('" + scope + "');", 500);
    }
  }
  
  /**
   *  @since Niagara 3.6   
   */
  this.doResize = function(scope)
  {
    px.resizeTimeout=null;
    document.body.style.overflow='hidden';
    
    var newWidth = hx.getScreenWidth();
    var newHeight = hx.getScreenHeight();
    var updateNow = newWidth != hx.screenWidth || newHeight != hx.screenHeight;
    document.body.style.overflow='auto';
    
    if(updateNow)
    {
      hx.setFormValue(scope, 0);
      hx.screenHeight=newHeight;
      hx.screenWidth=newWidth;
      hx.poll();
    }    
  }
  
  /**
   *  @since Niagara 3.6   
   */
  this.fixResize = function()
  {
    var elem = document.body;
    if(elem.offsetHeight == elem.scrollHeight && elem.offsetWidth == elem.scrollWidth)
      elem.style.overflow='hidden';
    else
       elem.style.overflow='auto';
  }
  
  ////////////////////////////////////////////////////////////////
  //BPicture Scaling Utilities - @since Niagara 3.8   
  ////////////////////////////////////////////////////////////////

  function calculateImageDimensions(imgSrc, handleDims) {
    var img = new Image();
    
    img.onload = function () {
      handleDims(this.width, this.height);
      img.onload = null;
      img = null;
    };
    
    img.src = imgSrc; 
  }
  

  function getImageLayoutCSS(scale, 
                             picWidth, picHeight, 
                             imgWidth, imgHeight,
                             halign, valign) {
    var imgRatio,
        width, height, marginTop, marginLeft;

    switch(scale) {
      case 'none':
        width = imgWidth;
        height = imgHeight;
        break;
      case 'fit':
        width = picWidth;
        height = picHeight;
        break;
      case 'fitHeight':
        width = imgWidth;
        height = picHeight;
        break;
      case 'fitWidth':
        width = picWidth;
        height = imgHeight;
        break;
      case 'fitRatio':
        //scale image down only enough to fit within picture borders
        imgRatio = Math.min(picWidth / imgWidth, picHeight / imgHeight);
        width = imgWidth * imgRatio;
        height = imgHeight * imgRatio;
        break;
    }

    switch (halign) {
      case 'left': marginLeft = 0; break;
      case 'center': marginLeft = (picWidth - width) / 2; break;
      case 'right': case 'fill': marginLeft = (picWidth - width); break;
    }
    
    switch (valign) {
      case 'top': marginTop = 0; break;
      case 'center': marginTop = (picHeight - height) / 2; break;
      case 'bottom': case 'fill': marginTop = (picHeight - height); break;
    }
    
    return { 
      width: width, 
      height: height, 
      marginTop: marginTop + 'px',
      marginLeft: marginLeft + 'px'
    };
  }
  
  /**
   * Updates the src and layout of the Picture's <code>&lt;img&gt;</code> tag.
   * Called whenever there is an update to the Picture's <code>image</code> or
   * <code>scale</code> properties.
   * @since Niagara 3.8
   */
  this.updatePictureImage = function updatePictureImage(imgSrc, imgId,
    scale, picWidth, picHeight, halign, valign) {
    
    var imgDom = document.getElementById(imgId),
        imgStyle = imgDom && imgDom.style;
    
    if (!imgStyle) {
      return;
    }
    
    if (!imgSrc) {
      /* 
       * no image to show. 
       */
      imgStyle.display = 'none';
    } else {
      /* 
       * layout according to size and scale. 
       */
      calculateImageDimensions(imgSrc, function (imgWidth, imgHeight) {
        var css = getImageLayoutCSS(scale, picWidth, picHeight,
              imgWidth, imgHeight, halign, valign);
        
        imgDom.src = imgSrc;
        imgDom.width = css.width;
        imgDom.height = css.height;
        imgStyle.marginTop = css.marginTop;
        imgStyle.marginLeft = css.marginLeft;

        //NCCB-5908: webkit strikes again with poor SVG rescaling. the hide()
        //and offset() force a browser reflow as a workaround for the following
        //bug:
        //https://code.google.com/p/chromium/issues/detail?id=269446
        if (imgSrc.toLowerCase().lastIndexOf('.svg') === imgSrc.length - 4) {
          imgStyle.display = 'none';
          imgDom.offsetHeight;
        }
        
        imgStyle.display = 'block';
      });
    }
  }

}