/*
 * Copyright 2006 Tridium, Inc. All Rights Reserved.
 */

/**
 * ColorChooser.
 *
 * @author    Andy Frank
 * @creation  24 Feb 06
 * @version   $Revision$ $Date$
 * @since     Baja 1.0
 */

////////////////////////////////////////////////////////////////
// ColorChooser
////////////////////////////////////////////////////////////////

var colorChooser = new ColorChooser(); // global instance
function ColorChooser()
{ 
  /**
   * Show the color chooser.
   */
  this.show = function(handler)
  {
    // Reset default color
    this.selected = "#ff0000";
    
    this.handler = handler;
    var body = "";
    body += "<table>";
    body += "<tr>";
    body += "<td>";
    body += makeDefaultPalette();
    body += "</td>";
    body += "<td valign='top'>";
    body += makeSwatch();
    body += "</td>";
    body += "</tr>";
    body += "</table>";
    hx.showDialog(chrome(body));
  }
  
  /**
   * Commit color selection by calling handler.
   */
  this.commit = function()
  {
    if (colorChooser.handler != null)
      colorChooser.handler(colorChooser.selected);
  }
  
////////////////////////////////////////////////////////////////
// Methods
////////////////////////////////////////////////////////////////

  /**
   * Add chrome for the dialog around body.
   */
  function chrome(body)
  {
    var c = "<table border='0' align='center' height='100%'>";
    c += "<tr><td valign='middle'>";
    c += "<div class='control-bg dialog-outerBorder'>";
    c += "<div class='dialog-innerBorder'>";
    
    // Titlebar
    c += "<div class='dialog-header'>Color Chooser</div>";
    
    // Padding
    c += "<div class='dialog-content'>";
    
    // Content
    c += body;
    
    // Buttons
    c += "<div style='padding-top:10px; text-align:center;'>";
    c += "<input type='button' class='button' value='Ok' ";
    c += "onclick='hx.closeDialog(null, null); colorChooser.commit();' />";
    c += " <input type='button' class='button' value='Cancel' ";
    c += "onclick='hx.closeDialog(null, null);' />";
    c += "</div>";
      
    // End padding
    c += "</div>";
    
    // End dialog
    c += "</div>"; // inner border
    c += "</div>"; // outer border
    c += "</td></tr>";
    c += "</table>";
    
    return c;
  }
  
  /**
   * Create default palette.
   */
  function makeDefaultPalette()
  {         
    var p = "<div style='position:relative; background:black; ";      
    p += "width:137px; height:137px;'>";
    
    var cols = 8;
    var rows = 8;
    
    for (var r=0; r<rows; r++)
      for (var c=0; c<cols; c++)
      {
        var i = (r * 8)  + c;
        var x = (c * 17) + 1;
        var y = (r * 17) + 1;
        
        var val = def[i];
        
        p += "<div style='position:absolute; ";
        p += "left:" + x + "px; top:" + y + "px; ";
        p += "width:16px; height:16px; cursor:pointer; ";
        p += "background:" + val + ";'";
        p += "onclick='colorChooser.update(\"" + val + "\");'>";
        p += "</div>";
      }
    
    p += "</div>";
    return p;
  }
  
  /**
   * Make the current selected swatch.
   */
  function makeSwatch()
  {
    var s = "<div id='colorChooserSwatch' ";
    s += "style='width:48px; height:48px; background:#f00;";
    s += " border: 1px solid black;' ></div>";
    return s;
  }
  
  /**
   * Update selected color.
   */
  this.update = function(val)
  {
    colorChooser.selected = val;
    hx.$("colorChooserSwatch").style.background = val;
  }

////////////////////////////////////////////////////////////////
// Attributes
////////////////////////////////////////////////////////////////
  
  this.selected = "#ff0000";
  
  var def = new Array();
  
  // Red
  def.push("#ff0000");
  def.push("#400000");
  def.push("#800000");
  def.push("#c00000");      
  def.push("#ff4040");
  def.push("#ff8080");
  def.push("#ffc0c0");      
  def.push("#000000");
        
  // Orange
  def.push("#ff8000");
  def.push("#402000");
  def.push("#804000");
  def.push("#bf6000");      
  def.push("#ffa040");
  def.push("#ffc080");                      
  def.push("#ffdfbf");      
  def.push("#202020");
  
  // Yellow
  def.push("#ffff00");
  def.push("#404000");
  def.push("#808000");
  def.push("#c0c000");      
  def.push("#ffff40");
  def.push("#ffff80");                      
  def.push("#ffffc0");      
  def.push("#404040");
  
  // Green
  def.push("#00ff00");
  def.push("#004000");
  def.push("#008000");
  def.push("#00c000");
  def.push("#40ff40");
  def.push("#80ff80");
  def.push("#c0ffc0");      
  def.push("#606060");
  
  // Cyan
  def.push("#00ffff");
  def.push("#004040");
  def.push("#008080");
  def.push("#00c0c0");
  def.push("#40ffff");
  def.push("#80ffff");
  def.push("#c0ffff");      
  def.push("#808080");
  
  // Aqua ?
  /*
  def.push("#0080ff");
  def.push("#002040");
  def.push("#004080");
  def.push("#0060bf");
  def.push("#40a0ff");
  def.push("#80c0ff");
  def.push("#bfdfff");      
  def.push("#b0b0b0");
  */
  
  // Blue
  def.push("#0000ff");
  def.push("#000040");
  def.push("#000080");
  def.push("#0000c0");
  def.push("#4040ff");
  def.push("#8080ff");
  def.push("#c0c0ff");      
  def.push("#c0c0c0");
  
  // Purple
  def.push("#8000ff");
  def.push("#1e0040");
  def.push("#3c0080");
  def.push("#5a00c0");
  def.push("#9a41ff");
  def.push("#bb80ff");
  def.push("#ddbfff");
  def.push("#e0e0e0");
  
  // Magenta
  def.push("#ff00ff");
  def.push("#400040");
  def.push("#800080");
  def.push("#c000c0");
  def.push("#ff40ff");
  def.push("#ff80ff");
  def.push("#ffc0ff");
  def.push("#ffffff");
}

