/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.util;

import com.tridium.html.util.ColorCodec;
import com.tridium.html.util.Declarator;
import com.tridium.html.util.HtmlNode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class HtmlTag
extends HtmlNode {
    private int lineNo;
    private String name;
    private Map attribs;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.name);
        if (this.attribs.size() > 0) {
            stringBuffer.append(" (");
            Iterator iterator = this.attribs.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)this.attribs.get(string);
                stringBuffer.append(string).append(", ");
                stringBuffer.append(string2).append("; ");
            }
            stringBuffer.append(")");
        }
        stringBuffer.append(" [" + (this.lineNo + 1) + ']');
        return stringBuffer.toString();
    }

    public void applyStyleSheetDefaults(ArrayList arrayList) {
        if (arrayList == null) {
            return;
        }
        int n = 0;
        while (n < arrayList.size()) {
            Declarator declarator = (Declarator)arrayList.get(n);
            String string = this.getAttribute(declarator.getName());
            if (string == null) {
                this.attribs.put(declarator.getName(), declarator.getValue());
            }
            ++n;
        }
    }

    public String getTagName() {
        return this.name;
    }

    public int getLineNumber() {
        return this.lineNo;
    }

    public boolean hasAttribute(String string) {
        return this.attribs.containsKey(string);
    }

    public String getAttribute(String string) {
        return (String)this.attribs.get(string);
    }

    public Color getColorAttribute(String string, Color color) {
        String string2 = this.getAttribute(string);
        return string2 == null ? color : ColorCodec.decode(string2, Color.white);
    }

    public int getIntegerAttribute(String string, int n) {
        String string2 = this.getAttribute(string);
        return string2 == null ? n : Integer.parseInt(string2);
    }

    public HtmlTag(String string, Map map, int n) {
        this.name = string;
        this.attribs = map;
        this.lineNo = n;
    }
}

