/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.util;

import com.tridium.html.util.HtmlNode;
import com.tridium.html.util.HtmlRoot;
import com.tridium.html.util.HtmlTag;
import com.tridium.html.util.HtmlText;
import com.tridium.html.util.HtmlTokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.baja.log.Log;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HtmlParser
extends HtmlTokenizer {
    private static final Log log = Log.getLog((String)"html");
    private static Map noEndTag = new HashMap();
    private static Map ignorableEndTag;
    private HtmlNode root;
    private HtmlNode currentTag;
    private ArrayList tagStack;

    public HtmlRoot getParseRoot() {
        return (HtmlRoot)this.root;
    }

    public void handleText(String string) {
        if (string.length() > 0) {
            this.add(new HtmlText(string));
        }
    }

    public void handleComment(String string) {
    }

    public void handleStartTag(int n, String string, Map map) {
        HtmlTag htmlTag = new HtmlTag(string, map, n);
        int n2 = 0;
        HtmlNode htmlNode = this.currentTag;
        while (htmlNode != null && !this.validParent(htmlNode, htmlTag)) {
            ++n2;
            htmlNode = htmlNode.getParent();
        }
        if (htmlNode == null) {
            log.warning("Cannot find valid parent for '<" + string + ">' (line " + (n + 1) + ").");
        } else if (n2 > 0) {
            log.warning("Missing end tag before '<" + string + ">' (line " + (n + 1) + ").");
            int n3 = 0;
            while (n3 < n2) {
                this.moveToParent();
                ++n3;
            }
        }
        this.add(htmlTag);
        if (!noEndTag.containsKey(string) && !ignorableEndTag.containsKey(string)) {
            this.moveToChild();
        }
    }

    public void handleEndTag(int n, String string) {
        if (ignorableEndTag.containsKey(string)) {
            return;
        }
        if (this.tagStack.size() == 0) {
            log.warning("Unmatched '</" + string + ">' (line " + (n + 1) + ").");
        } else {
            String string2;
            boolean bl = false;
            int n2 = 0;
            HtmlNode htmlNode = this.currentTag;
            while (htmlNode != null) {
                ++n2;
                if (htmlNode instanceof HtmlTag && (string2 = ((HtmlTag)htmlNode).getTagName()).equals(string)) {
                    bl = true;
                    break;
                }
                htmlNode = htmlNode.getParent();
            }
            if (bl) {
                int n3 = 0;
                while (n3 < n2) {
                    this.moveToParent();
                    ++n3;
                }
            } else {
                string2 = ((HtmlTag)this.currentTag).getTagName();
                if (!string2.equals("P")) {
                    log.warning("WARNING: Unmatched '</" + string + ">' (line " + (n + 1) + ").");
                }
            }
        }
    }

    private final void add(HtmlNode htmlNode) {
        this.currentTag.add(htmlNode);
    }

    private final void moveToChild() {
        this.currentTag = this.currentTag.get(this.currentTag.size() - 1);
        this.tagStack.add(this.currentTag);
    }

    private final void moveToParent() {
        this.currentTag = this.currentTag.getParent();
        this.tagStack.remove(this.tagStack.size() - 1);
    }

    private final boolean validParent(HtmlNode htmlNode, HtmlTag htmlTag) {
        String string = htmlTag.getTagName();
        if (string.equals("TD") || string.equals("TH")) {
            if (htmlNode == null) {
                return false;
            }
            if (!(htmlNode instanceof HtmlTag)) {
                return false;
            }
            return ((HtmlTag)htmlNode).getTagName().equals("TR");
        }
        if (string.equals("TR")) {
            if (htmlNode == null) {
                return false;
            }
            if (!(htmlNode instanceof HtmlTag)) {
                return false;
            }
            return ((HtmlTag)htmlNode).getTagName().equals("TABLE");
        }
        return true;
    }

    private final /* synthetic */ void this() {
        this.currentTag = this.root = new HtmlRoot();
        this.tagStack = new ArrayList();
    }

    public HtmlParser() {
        this.this();
    }

    static {
        noEndTag.put("BR", null);
        noEndTag.put("HR", null);
        noEndTag.put("IMG", null);
        noEndTag.put("LINK", null);
        ignorableEndTag = new HashMap();
        ignorableEndTag.put("DD", null);
        ignorableEndTag.put("DT", null);
        ignorableEndTag.put("LI", null);
    }
}

