/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.canvas.glyph;

import com.tridium.html.canvas.glyph.Letter;
import com.tridium.html.canvas.glyph.SelectionPoint;
import com.tridium.html.canvas.glyph.SelectionRange;
import com.tridium.html.canvas.glyph.StyleRun;
import com.tridium.ui.theme.Theme;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;

class TextRow {
    private static final Color HIGHLIGHT;
    private int x;
    private int y;
    private int index;
    private boolean visible;
    private boolean hardReturn;
    private StyleRun[] runs;
    private int[] runX;
    private int[] runLetter;
    private int ascent;
    private int height;
    private int width;
    private int numLetters;
    private String text;
    private SelectionPoint startSel;
    private SelectionPoint finishSel;

    SelectionRange selectWord(SelectionPoint selectionPoint) {
        int n = this.getLetterForRun(selectionPoint.run) + selectionPoint.letter.getCharIndex();
        boolean bl = selectionPoint.letter.isLeadingEdge();
        if (Character.isWhitespace(this.text.charAt(n))) {
            if (!bl) {
                int n2 = n - 1;
                while (n2 >= 0 && Character.isWhitespace(this.text.charAt(n2))) {
                    --n2;
                }
                int n3 = ++n2 - 1;
                while (n3 >= 0 && !Character.isWhitespace(this.text.charAt(n3))) {
                    --n3;
                }
                return this.createWordSelection(++n3, n2);
            }
            int n4 = n + 1;
            int n5 = this.text.length();
            while (n4 < n5 && Character.isWhitespace(this.text.charAt(n4))) {
                ++n4;
            }
            int n6 = n4 + 1;
            while (n6 < n5 && !Character.isWhitespace(this.text.charAt(n6))) {
                ++n6;
            }
            return this.createWordSelection(n4, n6);
        }
        int n7 = n - 1;
        while (n7 >= 0 && !Character.isWhitespace(this.text.charAt(n7))) {
            --n7;
        }
        int n8 = n + 1;
        int n9 = this.text.length();
        while (n8 < n9 && !Character.isWhitespace(this.text.charAt(n8))) {
            ++n8;
        }
        return this.createWordSelection(n7 + 1, n8);
    }

    void paint(Graphics2D graphics2D, SelectionRange selectionRange) {
        Rectangle rectangle;
        if (!this.visible) {
            return;
        }
        if (!selectionRange.isEmpty() && (rectangle = this.getHighlightRectangle(selectionRange)) != null) {
            graphics2D.setColor(HIGHLIGHT);
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        int n = 0;
        while (n < this.runs.length) {
            this.runs[n].paint(graphics2D, this.x + this.runX[n], this.y + this.ascent);
            ++n;
        }
    }

    Rectangle getHighlightRectangle(SelectionRange selectionRange) {
        if (this.startSel.compareTo(selectionRange.end) >= 0 || this.finishSel.compareTo(selectionRange.begin) <= 0) {
            return null;
        }
        if (this.startSel.compareTo(selectionRange.begin) > 0 && this.finishSel.compareTo(selectionRange.end) < 0) {
            return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        int n = 0;
        if (this.startSel.compareTo(selectionRange.begin) < 0) {
            n = this.getXForRun(selectionRange.begin.run) + selectionRange.begin.run.getX(selectionRange.begin.letter.getInsertionIndex());
        }
        int n2 = n;
        int n3 = this.finishSel.compareTo(selectionRange.end) <= 0 ? this.getWidth() : this.getXForRun(selectionRange.end.run) + selectionRange.end.run.getX(selectionRange.end.letter.getInsertionIndex());
        return new Rectangle(this.getX() + n2, this.getY(), n3 - n2, this.getHeight());
    }

    SelectionPoint select(int n) {
        if (n < this.x) {
            return this.startSel;
        }
        if (n >= this.x + this.width) {
            return this.finishSel;
        }
        int n2 = this.getRunAtX(n);
        Letter letter = this.runs[n2].getLetter(n - this.x - this.runX[n2]);
        if (letter == null) {
            throw new IllegalStateException();
        }
        return new SelectionPoint(this.runs[n2], letter);
    }

    String copy(SelectionRange selectionRange) {
        if (this.startSel.compareTo(selectionRange.end) >= 0 || this.finishSel.compareTo(selectionRange.begin) <= 0) {
            return null;
        }
        if (this.startSel.compareTo(selectionRange.begin) > 0 && this.finishSel.compareTo(selectionRange.end) < 0) {
            return this.text;
        }
        int n = 0;
        if (this.startSel.compareTo(selectionRange.begin) < 0) {
            n = this.getLetterForRun(selectionRange.begin.run) + selectionRange.begin.letter.getInsertionIndex();
        }
        int n2 = n;
        int n3 = this.finishSel.compareTo(selectionRange.end) <= 0 ? this.numLetters : this.getLetterForRun(selectionRange.end.run) + selectionRange.end.letter.getInsertionIndex();
        return this.text.substring(n2, n3);
    }

    private final SelectionRange createWordSelection(int n, int n2) {
        int n3 = this.getRunAtLetter(n);
        int n4 = this.getRunAtLetter(n2);
        return new SelectionRange(new SelectionPoint(this.runs[n3], new Letter(n - this.runLetter[n3], true)), new SelectionPoint(this.runs[n4], new Letter(n2 - this.runLetter[n4], true)));
    }

    private final int getRunAtX(int n) {
        int n2 = this.runs.length - 1;
        int n3 = 0;
        while (n3 < n2) {
            if (n >= this.x + this.runX[n3] && n < this.x + this.runX[n3 + 1]) {
                return n3;
            }
            ++n3;
        }
        if (n >= this.x + this.runX[n2] && n <= this.x + this.width) {
            return n2;
        }
        throw new IllegalStateException();
    }

    private final int getRunAtLetter(int n) {
        int n2 = this.runs.length - 1;
        int n3 = 0;
        while (n3 < n2) {
            if (n >= this.runLetter[n3] && n < this.runLetter[n3 + 1]) {
                return n3;
            }
            ++n3;
        }
        if (n >= this.runLetter[n2] && n < this.numLetters) {
            return n2;
        }
        throw new IllegalStateException();
    }

    private final int getLetterForRun(StyleRun styleRun) {
        int n = 0;
        while (n < this.runs.length) {
            if (styleRun.equals(this.runs[n])) {
                return this.runLetter[n];
            }
            ++n;
        }
        throw new IllegalStateException();
    }

    private final int getXForRun(StyleRun styleRun) {
        int n = 0;
        while (n < this.runs.length) {
            if (styleRun.equals(this.runs[n])) {
                return this.runX[n];
            }
            ++n;
        }
        throw new IllegalStateException();
    }

    int getX() {
        return this.x;
    }

    int getY() {
        return this.y;
    }

    boolean isVisible() {
        return this.visible;
    }

    boolean isHardReturn() {
        return this.hardReturn;
    }

    int getAscent() {
        return this.ascent;
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    String getText() {
        return this.text;
    }

    StyleRun[] getRuns() {
        return this.runs;
    }

    void setX(int n) {
        this.x = n;
    }

    void setY(int n) {
        this.y = n;
    }

    SelectionPoint getStartSel() {
        return this.startSel;
    }

    SelectionPoint getFinishSel() {
        return this.finishSel;
    }

    TextRow(StyleRun[] styleRunArray, int n, int n2, int n3, boolean bl, boolean bl2) {
        this.runs = styleRunArray;
        this.x = n;
        this.y = n2;
        this.index = n3;
        this.visible = bl;
        this.hardReturn = bl2;
        this.ascent = 0;
        this.height = 0;
        this.width = 0;
        this.numLetters = 0;
        StringBuffer stringBuffer = new StringBuffer();
        this.runX = new int[styleRunArray.length];
        this.runLetter = new int[styleRunArray.length];
        int n4 = 0;
        while (n4 < styleRunArray.length) {
            styleRunArray[n4].setTextRow(this);
            stringBuffer.append(styleRunArray[n4].getText());
            this.ascent = Math.max(this.ascent, styleRunArray[n4].getAscent());
            this.height = Math.max(this.height, styleRunArray[n4].getHeight());
            this.runX[n4] = this.width;
            this.runLetter[n4] = this.numLetters;
            this.numLetters += styleRunArray[n4].getNumLetters();
            this.width += styleRunArray[n4].getWidth();
            ++n4;
        }
        this.text = stringBuffer.toString();
        this.startSel = new SelectionPoint(styleRunArray[0], new Letter(0, true));
        this.finishSel = new SelectionPoint(styleRunArray[styleRunArray.length - 1], new Letter(styleRunArray[styleRunArray.length - 1].getNumLetters() - 1, false));
    }

    static {
        BBrush bBrush = Theme.textEditor().getSelectionBackground();
        if (bBrush.getPaint() instanceof BBrush.Solid) {
            BColor bColor = ((BBrush.Solid)bBrush.getPaint()).getColor();
            HIGHLIGHT = new Color(bColor.getRed(), bColor.getGreen(), bColor.getBlue(), bColor.getAlpha());
        } else if (bBrush.getPaint() instanceof BBrush.Gradient) {
            BBrush.Gradient gradient = (BBrush.Gradient)bBrush.getPaint();
            BBrush.Stop[] stopArray = gradient.getStops();
            BColor bColor = stopArray[stopArray.length / 2].getColor();
            HIGHLIGHT = new Color(bColor.getRed(), bColor.getGreen(), bColor.getBlue(), bColor.getAlpha());
        } else {
            HIGHLIGHT = new Color(204, 204, 255);
        }
    }
}

