/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.canvas.glyph;

import com.tridium.html.canvas.glyph.FlowLayout;
import com.tridium.html.canvas.glyph.Glyph;
import com.tridium.html.canvas.glyph.GlyphAlign;
import com.tridium.html.canvas.glyph.GlyphChangeIndent;
import com.tridium.html.canvas.glyph.GlyphFragment;
import com.tridium.html.canvas.glyph.GlyphHR;
import com.tridium.html.canvas.glyph.GlyphImage;
import com.tridium.html.canvas.glyph.GlyphLF;
import com.tridium.html.canvas.glyph.GlyphListItem;
import com.tridium.html.canvas.glyph.GlyphRectEnd;
import com.tridium.html.canvas.glyph.GlyphRectStart;
import com.tridium.html.canvas.glyph.GlyphRoot;
import com.tridium.html.canvas.glyph.GlyphTable;
import com.tridium.html.canvas.glyph.GlyphWord;
import com.tridium.html.canvas.glyph.StyleRun;
import com.tridium.html.canvas.glyph.TextGlyph;
import com.tridium.html.canvas.glyph.TextRow;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class RootLayout {
    private static final int MIN_ROW_HEIGHT = 14;
    private GlyphRoot root;
    private Point pen;
    private ArrayList rowGlyphs;
    private ArrayList imageQueue;
    private int indentLevel;
    private int align;
    private FlowLayout textFlow;

    public int doLayout() {
        this.pen = new Point(this.root.getX(), this.root.getY());
        this.root.textRows.clear();
        this.textFlow.clear();
        int n = 0;
        while (n < this.root.size()) {
            Glyph glyph;
            Glyph glyph2 = this.root.getGlyph(n);
            if (glyph2 instanceof GlyphWord) {
                if (this.getAvailableWidth(this.pen.x) < glyph2.getWidth()) {
                    this.createRow(14, false);
                }
                this.pen.x += glyph2.getWidth();
                this.rowGlyphs.add(glyph2);
            } else if (glyph2 instanceof GlyphImage) {
                glyph = (GlyphImage)glyph2;
                if (((GlyphImage)glyph).isFlowAround()) {
                    this.imageQueue.add(glyph);
                } else {
                    if (this.getAvailableWidth(this.pen.x) < glyph.getWidth()) {
                        this.createRow(14, true);
                    }
                    this.pen.x += glyph.getWidth();
                    this.rowGlyphs.add(glyph);
                }
            } else if (glyph2 instanceof GlyphLF) {
                this.rowGlyphs.add(glyph2);
                this.createRow(glyph2.getHeight(), true);
            } else if (glyph2 instanceof GlyphHR) {
                glyph = (GlyphHR)glyph2;
                glyph.setX(this.root.getX());
                glyph.setY(this.pen.y);
                glyph.setWidth(this.root.getWidth());
                this.carriageReturn();
                this.linefeed(glyph.getHeight());
            } else if (glyph2 instanceof GlyphTable) {
                ((GlyphTable)glyph2).doLayout(this.pen.x, this.pen.y, this.root.getWidth() - this.indentLevel * 40);
                this.carriageReturn();
                this.linefeed(glyph2.getHeight());
            } else if (glyph2 instanceof GlyphListItem) {
                this.carriageReturn();
                glyph2.setX(this.pen.x - 40);
                glyph2.setY(this.pen.y);
            } else if (glyph2 instanceof GlyphChangeIndent) {
                if (this.rowGlyphs.size() > 0) {
                    this.createRow(14, true);
                }
                this.indentLevel = ((GlyphChangeIndent)glyph2).getIndent();
            } else if (glyph2 instanceof GlyphFragment) {
                glyph2.setX(this.pen.x);
                glyph2.setY(this.pen.y);
            } else if (glyph2 instanceof GlyphRectStart) {
                this.carriageReturn();
                glyph2.setX(this.pen.x);
                glyph2.setY(this.pen.y);
            } else if (glyph2 instanceof GlyphRectEnd) {
                glyph = ((GlyphRectEnd)glyph2).getRect();
                glyph.setWidth(this.root.getWidth());
                glyph.setHeight(this.pen.y - glyph.getY());
            } else if (glyph2 instanceof GlyphAlign) {
                this.align = ((GlyphAlign)glyph2).getAlign();
            }
            ++n;
        }
        if (this.rowGlyphs.size() > 0) {
            this.createRow(14, true);
        }
        n = this.pen.y - this.root.getY();
        return n;
    }

    private final TextRow createTextRow(int n, int n2, boolean bl) {
        ArrayList<StyleRun> arrayList = new ArrayList<StyleRun>();
        TextGlyph textGlyph = null;
        int n3 = n;
        while (n3 < n2) {
            textGlyph = (TextGlyph)this.rowGlyphs.get(n3);
            arrayList.addAll(Arrays.asList(textGlyph.getStyleRuns()));
            ++n3;
        }
        return new TextRow(arrayList.toArray(new StyleRun[arrayList.size()]), 0, 0, this.root.textRows.size(), true, bl);
    }

    private final ArrayList createRowItems(boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < this.rowGlyphs.size()) {
            Glyph glyph = (Glyph)this.rowGlyphs.get(n2);
            if (glyph instanceof GlyphImage) {
                if (bl2) {
                    TextRow textRow = this.createTextRow(n, n2, bl);
                    this.root.textRows.add(textRow);
                    arrayList.add(textRow);
                }
                arrayList.add(glyph);
                bl2 = false;
            } else if (glyph instanceof TextGlyph) {
                if (!bl2) {
                    n = n2;
                }
                bl2 = true;
            }
            ++n2;
        }
        if (bl2) {
            TextRow textRow = this.createTextRow(n, this.rowGlyphs.size(), bl);
            this.root.textRows.add(textRow);
            arrayList.add(textRow);
        }
        return arrayList;
    }

    private final int layoutRow(boolean bl) {
        Object object;
        ArrayList arrayList = this.createRowItems(bl);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < arrayList.size()) {
            Object e = arrayList.get(n3);
            if (e instanceof TextRow) {
                object = (TextRow)e;
                n = Math.max(n, ((TextRow)object).getHeight());
                n2 += ((TextRow)object).getWidth();
            } else if (e instanceof GlyphImage) {
                object = (GlyphImage)e;
                n = Math.max(n, ((Glyph)object).getHeight());
                n2 += ((Glyph)object).getWidth();
            }
            ++n3;
        }
        n3 = this.pen.x + GlyphAlign.apply(this.align, this.root.getWidth() - n2);
        int n4 = 0;
        while (n4 < arrayList.size()) {
            Object object2;
            object = arrayList.get(n4);
            if (object instanceof TextRow) {
                object2 = (TextRow)object;
                ((TextRow)object2).setX(n3);
                ((TextRow)object2).setY(this.pen.y + (n - ((TextRow)object2).getHeight()));
                n3 += ((TextRow)object2).getWidth();
            } else if (object instanceof GlyphImage) {
                object2 = (GlyphImage)object;
                ((Glyph)object2).setX(n3);
                ((Glyph)object2).setY(this.pen.y + (n - ((Glyph)object2).getHeight()));
                n3 += ((Glyph)object2).getWidth();
            }
            ++n4;
        }
        return n;
    }

    private final void createRow(int n, boolean bl) {
        this.carriageReturn();
        this.linefeed(Math.max(this.layoutRow(bl), n));
        this.rowGlyphs.clear();
        if (this.imageQueue.size() > 0) {
            int n2 = 0;
            while (n2 < this.imageQueue.size()) {
                this.addQueuedImage((GlyphImage)this.imageQueue.get(n2));
                ++n2;
            }
            this.imageQueue.clear();
            this.carriageReturn();
        }
    }

    private final void addQueuedImage(GlyphImage glyphImage) {
        if (glyphImage.getAlign() == 0) {
            glyphImage.setX(this.getCarriageReturn());
            glyphImage.setY(this.pen.y);
            this.textFlow.add(this.pen.y, glyphImage.getWidth(), glyphImage.getHeight(), glyphImage.getAlign());
        } else if (glyphImage.getAlign() == 2) {
            int n = this.getCarriageReturn();
            n += this.getAvailableWidth(n);
            glyphImage.setX(n - glyphImage.getWidth());
            glyphImage.setY(this.pen.y);
            this.textFlow.add(this.pen.y, glyphImage.getWidth(), glyphImage.getHeight(), glyphImage.getAlign());
        }
    }

    private final void carriageReturn() {
        this.pen.x = this.getCarriageReturn();
    }

    private final int getCarriageReturn() {
        return this.root.getX() + this.indentLevel * 40 + this.textFlow.getBegin(this.pen.y);
    }

    private final void linefeed(int n) {
        this.pen.y += n;
        this.pen.x = this.getCarriageReturn();
    }

    private final int getAvailableWidth(int n) {
        return this.root.getWidth() - this.indentLevel * 40 - (n - this.root.getX()) - this.textFlow.getEnd(this.pen.y);
    }

    private final /* synthetic */ void this() {
        this.rowGlyphs = new ArrayList();
        this.imageQueue = new ArrayList();
        this.indentLevel = 0;
        this.align = 0;
        this.textFlow = new FlowLayout();
    }

    RootLayout(GlyphRoot glyphRoot) {
        this.this();
        this.root = glyphRoot;
    }
}

