/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.canvas.glyph;

import com.tridium.html.canvas.glyph.CircleUtil;
import com.tridium.html.canvas.glyph.Glyph;
import com.tridium.html.canvas.glyph.StyleRun;
import com.tridium.html.canvas.glyph.TextGlyph;
import com.tridium.html.canvas.glyph.VisibleGlyph;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;

public class GlyphListItem
extends Glyph
implements VisibleGlyph,
TextGlyph {
    static final int WIDTH = 40;
    private boolean ordered;
    private StyleRun[] runs;
    private Color color;
    private int indentLevel;

    public String toString() {
        return "LIST_ITEM " + this.ordered + ": " + this.getX() + ", " + this.getY() + ", " + this.getWidth() + ", " + this.getHeight();
    }

    public void paint(Graphics2D graphics2D, int n, int n2) {
        graphics2D.setColor(this.color);
        if (this.ordered) {
            this.runs[0].paint(graphics2D, this.getX() + 40 - this.runs[0].getWidth(), this.getY() + this.runs[0].getAscent());
        } else {
            switch (this.indentLevel % 2) {
                case 0: {
                    CircleUtil.drawCircle(graphics2D, this.getX() + 31, this.getY() + this.runs[0].getAscent() / 2 + 1, 2);
                    break;
                }
                case 1: {
                    CircleUtil.fillCircle(graphics2D, this.getX() + 31, this.getY() + this.runs[0].getAscent() / 2 + 1, 2);
                    break;
                }
            }
        }
    }

    public StyleRun[] getStyleRuns() {
        return this.runs;
    }

    public GlyphListItem(Font font, Color color, int n) {
        this.color = color;
        this.ordered = false;
        this.indentLevel = n;
        this.runs = new StyleRun[]{new StyleRun("* ", font, color, null, null, false)};
        this.setWidth(40);
        this.setHeight(this.runs[0].getHeight());
    }

    public GlyphListItem(Font font, Color color, int n, int n2) {
        this.color = color;
        this.ordered = true;
        this.indentLevel = n2;
        this.runs = new StyleRun[]{new StyleRun(Integer.toString(n) + ". ", font, color, null, null, false)};
        this.setWidth(40);
        this.setHeight(this.runs[0].getHeight());
    }
}

