/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.canvas.glyph;

import com.tridium.gx.awt.AwtEnv;
import com.tridium.html.canvas.glyph.Glyph;
import com.tridium.html.canvas.glyph.GlyphAlign;
import com.tridium.html.canvas.glyph.VisibleGlyph;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.baja.gx.BImage;

public class GlyphImage
extends Glyph
implements VisibleGlyph {
    private static final BImage MISSING = BImage.make((String)"module://icons/x32/error.png");
    private BImage image;
    private Image awtImage;
    private String href;
    private int align;

    public String toString() {
        return "IMAGE (" + GlyphAlign.encode(this.align) + ')';
    }

    public void paint(Graphics2D graphics2D, int n, int n2) {
        if (this.href != null) {
            graphics2D.setColor(Color.blue);
            graphics2D.drawRect(this.getX() + 2, this.getY() + 2, this.getWidth() - 5, this.getHeight() - 5);
        }
        this.awtImage = AwtEnv.peer((BImage)this.image).image();
        if (this.awtImage != null) {
            graphics2D.drawImage(this.awtImage, this.getX() + 3, this.getY() + 3, null);
        }
    }

    public boolean isConglomerable() {
        return this.isFlowAround() ^ true;
    }

    int getAlign() {
        return this.align;
    }

    boolean isFlowAround() {
        boolean bl = false;
        if (this.align == 0 || this.align == 2) {
            bl = true;
        }
        return bl;
    }

    public GlyphImage(BImage bImage, String string, int n) {
        if (bImage == null) {
            this.image = MISSING;
        } else {
            this.awtImage = AwtEnv.peer((BImage)bImage).image();
            this.image = this.awtImage == null ? MISSING : bImage;
        }
        this.href = string;
        this.align = n;
        this.setWidth((int)this.image.getWidth() + 6);
        this.setHeight((int)this.image.getHeight() + 6);
    }
}

