/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.canvas.glyph;

import com.tridium.html.canvas.glyph.Glyph;

public class GlyphAlign
extends Glyph {
    public static final int NONE = -1;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private int align;

    public static int decode(String string) {
        return GlyphAlign.decode(string, 0);
    }

    public static int decode(String string, int n) {
        if (string == null) {
            return n;
        }
        if ((string = string.toUpperCase()).equals("LEFT")) {
            return 0;
        }
        if (string.equals("CENTER")) {
            return 1;
        }
        if (string.equals("RIGHT")) {
            return 2;
        }
        System.out.println("WARNING: could not decode alignment: " + string);
        return n;
    }

    public String toString() {
        return GlyphAlign.encode(this.align);
    }

    public static String encode(int n) {
        String string = "ALIGN ";
        switch (n) {
            case 0: {
                string = string + "LEFT";
                break;
            }
            case 1: {
                string = string + "CENTER";
                break;
            }
            case 2: {
                string = string + "RIGHT";
                break;
            }
        }
        return string;
    }

    public static int apply(int n, int n2) {
        int n3 = 0;
        switch (n) {
            case 1: {
                n3 = n2 / 2;
                break;
            }
            case 2: {
                n3 = n2;
                break;
            }
        }
        return n3;
    }

    public int getAlign() {
        return this.align;
    }

    public GlyphAlign() {
        this.align = 0;
    }

    public GlyphAlign(String string) {
        this.align = GlyphAlign.decode(string);
    }
}

