/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.canvas.build;

import com.tridium.html.canvas.glyph.Glyph;
import com.tridium.html.canvas.glyph.GlyphAlign;
import com.tridium.html.canvas.glyph.GlyphChangeIndent;
import com.tridium.html.canvas.glyph.GlyphFragment;
import com.tridium.html.canvas.glyph.GlyphRectEnd;
import com.tridium.html.canvas.glyph.GlyphRectStart;

class GlyphIterator {
    private Glyph parent;
    private int n;

    Glyph next() {
        if (this.n > this.parent.size() - 1) {
            return null;
        }
        Glyph glyph = this.parent.getGlyph(this.n++);
        while (this.ignorable(glyph)) {
            if (this.n > this.parent.size() - 1) {
                return null;
            }
            glyph = this.parent.getGlyph(this.n++);
        }
        return glyph;
    }

    Glyph prev() {
        if (this.n < 0) {
            return null;
        }
        Glyph glyph = this.parent.getGlyph(this.n--);
        while (this.ignorable(glyph)) {
            if (this.n < 0) {
                return null;
            }
            glyph = this.parent.getGlyph(this.n--);
        }
        return glyph;
    }

    int idx() {
        return this.n;
    }

    private final boolean ignorable(Glyph glyph) {
        boolean bl = false;
        if (glyph instanceof GlyphAlign || glyph instanceof GlyphChangeIndent || glyph instanceof GlyphFragment || glyph instanceof GlyphRectStart || glyph instanceof GlyphRectEnd) {
            bl = true;
        }
        return bl;
    }

    GlyphIterator(Glyph glyph, int n) {
        this.parent = glyph;
        this.n = n;
    }
}

