/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.canvas.build;

import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.baja.gx.BFont;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FontPool {
    private static Lexicon lexicon = Lexicon.make((String)"html");
    private static String NORMAL;
    private static String MONO;
    private static int SIZE;
    private static int STYLE;
    private static Font DEFAULT_FONT;
    private static Map fontPool;
    private String fontName;
    private int fontSize;
    private boolean bold;
    private boolean italic;
    private Stack sizeStack;
    private Stack nameStack;
    private Stack colorStack;

    Font make() {
        int n;
        int n2 = this.bold ? (this.italic ? 3 : 1) : (n = this.italic ? 2 : 0);
        if (this.fontName.equals(NORMAL) && n == STYLE && this.fontSize == SIZE) {
            return DEFAULT_FONT;
        }
        Font font = new Font(this.fontName, n, this.fontSize);
        Font font2 = (Font)fontPool.get(font);
        if (font2 == null) {
            font2 = font;
            fontPool.put(font, font2);
        }
        return font2;
    }

    void pushSize(int n) {
        this.fontSize = n;
        this.sizeStack.push(new Integer(n));
    }

    void popSize() {
        this.sizeStack.pop();
        this.fontSize = (Integer)this.sizeStack.peek();
    }

    int getSize() {
        return this.fontSize;
    }

    void pushName(String string) {
        this.fontName = string;
        this.nameStack.push(string);
    }

    void popName() {
        this.nameStack.pop();
        this.fontName = (String)this.nameStack.peek();
    }

    String getName() {
        return (String)this.nameStack.peek();
    }

    void pushColor(Color color) {
        if (color == null) {
            color = this.getColor();
        }
        this.colorStack.push(color);
    }

    void popColor() {
        this.colorStack.pop();
    }

    Color getColor() {
        return (Color)this.colorStack.peek();
    }

    static String getMono() {
        return MONO;
    }

    void setBold(boolean bl) {
        this.bold = bl;
    }

    void setItalic(boolean bl) {
        this.italic = bl;
    }

    private final /* synthetic */ void this() {
        this.fontName = NORMAL;
        this.fontSize = SIZE;
        this.bold = false;
        this.italic = false;
        this.sizeStack = new Stack();
        this.nameStack = new Stack();
        this.colorStack = new Stack();
    }

    FontPool() {
        this.this();
        this.pushName(NORMAL);
        this.pushSize(SIZE);
        this.pushColor(Color.black);
    }

    static {
        BFont bFont = BFont.make((String)lexicon.getText("htmlCanvas.font.normal"));
        NORMAL = bFont.getName();
        SIZE = (int)bFont.getSize();
        STYLE = bFont.getStyle();
        DEFAULT_FONT = new Font(NORMAL, STYLE, SIZE);
        BFont bFont2 = BFont.make((String)lexicon.getText("htmlCanvas.font.mono"));
        MONO = bFont2.getName();
        fontPool = new HashMap();
    }
}

