/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.canvas.build;

import com.tridium.html.canvas.BHtmlCanvas;
import com.tridium.html.canvas.build.BuildTable;
import com.tridium.html.canvas.build.FontPool;
import com.tridium.html.canvas.build.GlyphIterator;
import com.tridium.html.canvas.build.LinefeedManager;
import com.tridium.html.canvas.build.NormalTextWalker;
import com.tridium.html.canvas.build.PreformatTextWalker;
import com.tridium.html.canvas.glyph.Glyph;
import com.tridium.html.canvas.glyph.GlyphAlign;
import com.tridium.html.canvas.glyph.GlyphChangeIndent;
import com.tridium.html.canvas.glyph.GlyphFragment;
import com.tridium.html.canvas.glyph.GlyphHR;
import com.tridium.html.canvas.glyph.GlyphImage;
import com.tridium.html.canvas.glyph.GlyphLF;
import com.tridium.html.canvas.glyph.GlyphListItem;
import com.tridium.html.canvas.glyph.GlyphRectEnd;
import com.tridium.html.canvas.glyph.GlyphRectStart;
import com.tridium.html.canvas.glyph.GlyphRoot;
import com.tridium.html.canvas.glyph.GlyphTable;
import com.tridium.html.util.HtmlNode;
import com.tridium.html.util.HtmlTag;
import com.tridium.html.util.HtmlText;
import com.tridium.html.util.HtmlTokenizer;
import java.awt.Color;
import java.awt.Font;
import java.util.Stack;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BuildGlyphs {
    private static final boolean DEBUG = false;
    Glyph currGlyph;
    int idx;
    LinefeedManager linefeedMgr;
    GlyphRoot glyphRoot;
    private BHtmlCanvas canvas;
    private FontPool fontPool;
    private boolean allBold;
    private boolean inPreformat;
    private NormalTextWalker normalTextWalker;
    private PreformatTextWalker preformatTextWalker;
    private GlyphRectStart paragraph;
    private GlyphRectStart heading;
    private String href;
    private String target;
    private int listItemCounter;
    private int indentLevel;
    private Stack orderedList;

    public GlyphRoot makeGlyphs(HtmlNode htmlNode, boolean bl, boolean bl2) {
        HtmlTag htmlTag;
        this.normalTextWalker.reset();
        this.preformatTextWalker.reset();
        this.allBold = bl;
        if (bl) {
            this.fontPool.setBold(true);
        }
        if (htmlNode instanceof HtmlTag && (htmlTag = (HtmlTag)htmlNode).getTagName().equals("BODY")) {
            this.glyphRoot.setBgColor(htmlTag.getColorAttribute("BGCOLOR", null));
        }
        int n = 0;
        while (n < htmlNode.size()) {
            this.traverseNode(htmlNode.get(n));
            ++n;
        }
        this.linefeedMgr.trim();
        if (this.glyphRoot.size() == 0) {
            this.linefeed();
        }
        this.glyphRoot.setNoWrap(bl2);
        return this.glyphRoot;
    }

    private final void traverseNode(HtmlNode htmlNode) {
        if (htmlNode instanceof HtmlText) {
            this.traverseText((HtmlText)htmlNode);
        } else if (htmlNode instanceof HtmlTag) {
            this.traverseTag((HtmlTag)htmlNode);
        }
    }

    private final void traverseTag(HtmlTag htmlTag) {
        String string;
        String string2 = htmlTag.getAttribute("ID");
        if (string2 != null) {
            this.addGlyph(new GlyphFragment(string2));
        }
        if ((string = htmlTag.getTagName()).equals("BR")) {
            this.handleBR();
        } else if (string.equals("DD")) {
            this.handleDD();
        } else if (string.equals("DT")) {
            this.handleDT();
        } else if (string.equals("HR")) {
            this.handleHR();
        } else if (string.equals("IMG")) {
            this.handleImage(htmlTag);
        } else if (string.equals("LI")) {
            this.handleListItem(htmlTag);
        } else if (string.equals("TABLE")) {
            this.traverseTable(htmlTag);
        } else {
            if (string.equals("A")) {
                this.enterAnchor(htmlTag);
            } else if (string.equals("B") || string.equals("STRONG")) {
                if (!this.allBold) {
                    this.fontPool.setBold(true);
                }
            } else if (string.equals("CODE") || string.equals("TT")) {
                this.fontPool.pushName(FontPool.getMono());
            } else if (string.equals("DL")) {
                this.enterDL();
            } else if (string.equals("FONT")) {
                this.enterFont(htmlTag);
            } else if (string.equals("H1")) {
                this.enterHeading(htmlTag, 10);
            } else if (string.equals("H2")) {
                this.enterHeading(htmlTag, 6);
            } else if (string.equals("H3")) {
                this.enterHeading(htmlTag, 3);
            } else if (string.equals("H4")) {
                this.enterHeading(htmlTag, 1);
            } else if (string.equals("H5")) {
                this.enterHeading(htmlTag, 0);
            } else if (string.equals("I") || string.equals("EM")) {
                this.fontPool.setItalic(true);
            } else if (string.equals("OL")) {
                this.enterOrderedList();
            } else if (string.equals("P")) {
                this.enterParagraph(htmlTag);
            } else if (string.equals("PRE")) {
                this.enterPreformat(htmlTag);
            } else if (string.equals("UL")) {
                this.enterUnorderedList();
            }
            int n = 0;
            while (n < htmlTag.size()) {
                this.traverseNode(htmlTag.get(n));
                ++n;
            }
            if (string.equals("A")) {
                this.exitAnchor();
            } else if (string.equals("B") || string.equals("STRONG")) {
                if (!this.allBold) {
                    this.fontPool.setBold(false);
                }
            } else if (string.equals("CODE") || string.equals("TT")) {
                this.fontPool.popName();
            } else if (string.equals("DL")) {
                this.exitDL();
            } else if (string.equals("FONT")) {
                this.exitFont();
            } else if (string.equals("H1")) {
                this.exitHeading();
            } else if (string.equals("H2")) {
                this.exitHeading();
            } else if (string.equals("H3")) {
                this.exitHeading();
            } else if (string.equals("H4")) {
                this.exitHeading();
            } else if (string.equals("H5")) {
                this.exitHeading();
            } else if (string.equals("I") || string.equals("EM")) {
                this.fontPool.setItalic(false);
            } else if (string.equals("OL")) {
                this.exitOrderedList();
            } else if (string.equals("P")) {
                this.exitParagraph();
            } else if (string.equals("PRE")) {
                this.exitPreformat();
            } else if (string.equals("UL")) {
                this.exitUnorderedList();
            }
        }
    }

    private final void traverseText(HtmlText htmlText) {
        String string = HtmlTokenizer.replaceLiterals(htmlText.getText());
        Font font = this.fontPool.make();
        Color color = this.fontPool.getColor();
        int n = string.indexOf(153);
        while (n != -1) {
            String string2 = string.substring(0, n);
            if (string2.length() > 0) {
                this.walkText(string2, font, color, false);
            }
            this.walkText("TM", font, color, true);
            string = string.substring(n + 1);
            n = string.indexOf(153);
        }
        if (string.length() > 0) {
            this.walkText(string, font, color, false);
        }
    }

    private final void walkText(String string, Font font, Color color, boolean bl) {
        if (this.inPreformat) {
            this.preformatTextWalker.walk(string, font, color, this.href, this.target, bl);
        } else {
            this.normalTextWalker.walk(string, font, color, this.href, this.target, bl);
        }
    }

    private final void interruptTextFlow() {
        if (this.inPreformat) {
            this.preformatTextWalker.reset();
        } else {
            this.normalTextWalker.reset();
        }
    }

    private final void handleImage(HtmlTag htmlTag) {
        String string = htmlTag.getAttribute("SRC");
        if (string != null) {
            this.interruptTextFlow();
            this.addGlyph(new GlyphImage(this.canvas.getHtmlController().downloadImage(string), this.href, GlyphAlign.decode(htmlTag.getAttribute("ALIGN"), -1)));
        }
    }

    private final void handleHR() {
        this.linefeedMgr.ensureLinefeed();
        this.addGlyph(new GlyphHR());
    }

    private final void handleDT() {
        this.linefeedMgr.ensureLinefeed();
        this.addGlyph(new GlyphChangeIndent(this.indentLevel - 1));
    }

    private final void handleDD() {
        this.linefeedMgr.ensureLinefeed();
        this.addGlyph(new GlyphChangeIndent(this.indentLevel));
    }

    private final void enterDL() {
        if (this.indentLevel == 0) {
            this.linefeedMgr.ensureDoubleLinefeed();
        }
        ++this.indentLevel;
    }

    private final void exitDL() {
        --this.indentLevel;
        if (this.indentLevel == 0) {
            this.linefeedMgr.ensureDoubleLinefeed();
        } else {
            this.linefeedMgr.ensureLinefeed();
        }
        this.addGlyph(new GlyphChangeIndent(this.indentLevel));
    }

    private final void enterUnorderedList() {
        this.orderedList.push(new Boolean(false));
        if (this.indentLevel == 0) {
            this.linefeedMgr.ensureDoubleLinefeed();
        } else {
            this.linefeedMgr.ensureLinefeed();
        }
        this.addGlyph(new GlyphChangeIndent(++this.indentLevel));
    }

    private final void exitUnorderedList() {
        this.orderedList.pop();
        if (this.indentLevel == 1) {
            this.linefeedMgr.ensureDoubleLinefeed();
        } else {
            this.linefeedMgr.ensureLinefeed();
        }
        this.addGlyph(new GlyphChangeIndent(--this.indentLevel));
    }

    private final void enterOrderedList() {
        this.orderedList.push(new Boolean(true));
        this.listItemCounter = 1;
        if (this.indentLevel == 0) {
            this.linefeedMgr.ensureDoubleLinefeed();
        } else {
            this.linefeedMgr.ensureLinefeed();
        }
        this.addGlyph(new GlyphChangeIndent(++this.indentLevel));
    }

    private final void exitOrderedList() {
        this.orderedList.pop();
        if (this.indentLevel == 1) {
            this.linefeedMgr.ensureDoubleLinefeed();
        } else {
            this.linefeedMgr.ensureLinefeed();
        }
        this.addGlyph(new GlyphChangeIndent(--this.indentLevel));
    }

    private final void handleListItem(HtmlTag htmlTag) {
        this.linefeedMgr.ensureDoubleLinefeed();
        if (this.orderedList.size() > 0) {
            GlyphListItem glyphListItem;
            if (((Boolean)this.orderedList.peek()).booleanValue()) {
                int n = this.listItemCounter++;
                glyphListItem = new GlyphListItem(this.fontPool.make(), this.fontPool.getColor(), n, this.indentLevel);
            } else {
                glyphListItem = new GlyphListItem(this.fontPool.make(), this.fontPool.getColor(), this.indentLevel);
            }
            this.addGlyph(glyphListItem);
        }
    }

    private final void handleBR() {
        this.linefeed();
    }

    void linefeed() {
        this.interruptTextFlow();
        this.addGlyph(new GlyphLF(this.fontPool.make()));
    }

    private final void enterParagraph(HtmlTag htmlTag) {
        GlyphIterator glyphIterator = new GlyphIterator(this.currGlyph, this.idx);
        Glyph glyph = glyphIterator.prev();
        if (glyph == null || !(glyph instanceof GlyphListItem)) {
            this.linefeedMgr.ensureDoubleLinefeed();
        }
        this.fontPool.pushColor(htmlTag.getColorAttribute("COLOR", Color.black));
        Color color = htmlTag.getColorAttribute("BGCOLOR", null);
        if (color != null) {
            this.paragraph = new GlyphRectStart(color);
            this.addGlyph(this.paragraph);
            Color color2 = htmlTag.getColorAttribute("BORDER", null);
            if (color2 != null) {
                this.paragraph.border = color2;
            } else {
                color2 = htmlTag.getColorAttribute("BORDER-TOP", null);
                if (color2 != null) {
                    this.paragraph.borderTop = color2;
                }
                if ((color2 = htmlTag.getColorAttribute("BORDER-BOTTOM", null)) != null) {
                    this.paragraph.borderBottom = color2;
                }
            }
            this.addGlyph(new GlyphAlign(htmlTag.getAttribute("ALIGN")));
        } else {
            this.paragraph = null;
        }
    }

    private final void exitParagraph() {
        this.fontPool.popColor();
        if (this.paragraph != null) {
            this.linefeed();
            this.addGlyph(new GlyphAlign());
            if (this.paragraph != null) {
                this.addGlyph(new GlyphRectEnd(this.paragraph));
            }
        }
    }

    private final void enterHeading(HtmlTag htmlTag, int n) {
        if (this.orderedList.size() == 0) {
            this.linefeedMgr.ensureDoubleLinefeed();
        }
        int n2 = this.fontPool.getSize() + n;
        String string = htmlTag.getAttribute("FONT-SIZE");
        if (string != null) {
            try {
                int n3 = 0;
                while (string.charAt(n3) >= '0' && string.charAt(n3) <= '9') {
                    ++n3;
                }
                n2 = Integer.parseInt(string.substring(0, n3));
            }
            catch (Exception exception) {}
        }
        this.fontPool.pushSize(n2);
        if (!this.allBold) {
            this.fontPool.setBold(true);
        }
        this.fontPool.pushColor(htmlTag.getColorAttribute("COLOR", null));
        Color color = htmlTag.getColorAttribute("BGCOLOR", null);
        if (color != null) {
            this.heading = new GlyphRectStart(color);
            this.addGlyph(this.heading);
            Color color2 = htmlTag.getColorAttribute("BORDER", null);
            if (color2 != null) {
                this.heading.border = color2;
            } else {
                color2 = htmlTag.getColorAttribute("BORDER-BOTTOM", null);
                if (color2 != null) {
                    this.heading.borderBottom = color2;
                }
            }
        } else {
            this.heading = null;
        }
    }

    private final void exitHeading() {
        this.fontPool.popSize();
        if (!this.allBold) {
            this.fontPool.setBold(false);
        }
        this.fontPool.popColor();
        this.linefeed();
        if (this.heading != null) {
            this.addGlyph(new GlyphRectEnd(this.heading));
        }
        this.linefeed();
    }

    private final void enterAnchor(HtmlTag htmlTag) {
        this.href = htmlTag.getAttribute("HREF");
        this.target = htmlTag.getAttribute("TARGET");
        this.fontPool.pushColor(htmlTag.getColorAttribute("COLOR", Color.blue));
        String string = htmlTag.getAttribute("NAME");
        if (string != null) {
            this.addGlyph(new GlyphFragment(string));
        }
    }

    private final void exitAnchor() {
        this.fontPool.popColor();
        this.href = null;
        this.target = null;
    }

    private final void enterFont(HtmlTag htmlTag) {
        String string = htmlTag.getAttribute("SIZE");
        this.fontPool.pushSize(string != null && string.length() > 0 ? this.decodeSize(string) : this.fontPool.getSize());
        this.fontPool.pushColor(htmlTag.getColorAttribute("COLOR", null));
        String string2 = htmlTag.getAttribute("NAME");
        this.fontPool.pushName(string2 != null && string2.length() > 0 ? string2 : this.fontPool.getName());
    }

    private final int decodeSize(String string) {
        if (string.charAt(0) == '+') {
            string = string.substring(1);
            int n = Integer.parseInt(string);
            return this.fontPool.getSize() + n * 3;
        }
        if (string.charAt(0) == '-') {
            string = string.substring(1);
            int n = Integer.parseInt(string);
            return this.fontPool.getSize() - n * 3;
        }
        int n = Integer.parseInt(string);
        return n * 3 + 3;
    }

    private final void exitFont() {
        this.fontPool.popSize();
        this.fontPool.popColor();
        this.fontPool.popName();
    }

    private final void enterPreformat(HtmlTag htmlTag) {
        this.inPreformat = true;
        this.linefeedMgr.ensureDoubleLinefeed();
        this.fontPool.pushName(FontPool.getMono());
        this.fontPool.pushColor(htmlTag.getColorAttribute("COLOR", Color.black));
        this.preformatTextWalker.reset();
    }

    private final void exitPreformat() {
        this.inPreformat = false;
        this.linefeedMgr.ensureDoubleLinefeed();
        this.fontPool.popName();
        this.fontPool.popColor();
        this.normalTextWalker.reset();
    }

    private final void traverseTable(HtmlTag htmlTag) {
        this.linefeedMgr.ensureLinefeed();
        BuildTable buildTable = new BuildTable(this.canvas);
        GlyphTable glyphTable = buildTable.build(htmlTag);
        this.addGlyph(glyphTable);
    }

    void addGlyph(Glyph glyph) {
        this.currGlyph.add(glyph);
        ++this.idx;
    }

    private final /* synthetic */ void this() {
        this.idx = -1;
        this.linefeedMgr = new LinefeedManager(this);
        this.canvas = null;
        this.fontPool = new FontPool();
        this.allBold = false;
        this.inPreformat = false;
        this.normalTextWalker = new NormalTextWalker(this);
        this.preformatTextWalker = new PreformatTextWalker(this);
        this.href = null;
        this.target = null;
        this.orderedList = new Stack();
    }

    public BuildGlyphs(BHtmlCanvas bHtmlCanvas) {
        this.this();
        this.canvas = bHtmlCanvas;
        this.glyphRoot = new GlyphRoot();
        this.currGlyph = this.glyphRoot;
    }
}

