/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.canvas;

import com.tridium.html.util.HtmlNode;
import com.tridium.html.util.HtmlTag;
import com.tridium.html.util.HtmlText;
import com.tridium.html.util.Selector;
import java.util.ArrayList;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class ParseNodeAnalyzer {
    private String title;
    private String styleSheetRef;
    private HtmlNode startingNode;

    void traverse(HtmlNode htmlNode) {
        this.startingNode = htmlNode;
        this.traverseNode(htmlNode);
    }

    String getTitle() {
        return this.title;
    }

    String getStyleSheetRef() {
        return this.styleSheetRef;
    }

    HtmlNode getStartingNode() {
        return this.startingNode;
    }

    void applyStyleSheet(Map map, HtmlNode htmlNode) {
        if (htmlNode instanceof HtmlTag) {
            HtmlTag htmlTag = (HtmlTag)htmlNode;
            Selector selector = new Selector(htmlTag.getTagName(), htmlTag.getAttribute("CLASS"));
            ArrayList arrayList = (ArrayList)map.get(selector);
            if (arrayList == null) {
                selector = new Selector(htmlTag.getTagName(), null);
                arrayList = (ArrayList)map.get(selector);
            }
            htmlTag.applyStyleSheetDefaults(arrayList);
        }
        int n = 0;
        while (n < htmlNode.size()) {
            this.applyStyleSheet(map, htmlNode.get(n));
            ++n;
        }
    }

    private final void setTitle(HtmlTag htmlTag) {
        this.title = "";
        int n = 0;
        while (n < htmlTag.size()) {
            HtmlNode htmlNode = htmlTag.get(n);
            if (htmlNode instanceof HtmlText) {
                HtmlText htmlText = (HtmlText)htmlNode;
                this.title = this.title + htmlText.getText().trim();
            }
            ++n;
        }
    }

    private final void traverseNode(HtmlNode htmlNode) {
        if (htmlNode instanceof HtmlTag) {
            HtmlTag htmlTag = (HtmlTag)htmlNode;
            String string = htmlTag.getTagName();
            if (string.equals("BODY")) {
                this.startingNode = htmlNode;
                return;
            }
            if (string.equals("TITLE")) {
                this.setTitle(htmlTag);
                return;
            }
            if (string.equals("LINK")) {
                String string2 = htmlTag.getAttribute("REL");
                String string3 = htmlTag.getAttribute("TYPE");
                if (string2 != null && string2.equalsIgnoreCase("StyleSheet") && string3 != null && string3.equals("text/css")) {
                    this.styleSheetRef = htmlTag.getAttribute("HREF");
                    return;
                }
            }
        }
        int n = 0;
        while (n < htmlNode.size()) {
            this.traverseNode(htmlNode.get(n));
            ++n;
        }
    }

    private final /* synthetic */ void this() {
        this.title = null;
        this.styleSheetRef = null;
        this.startingNode = null;
    }

    ParseNodeAnalyzer() {
        this.this();
    }
}

