/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.canvas;

import com.tridium.util.Href2Ord;
import com.tridium.workbench.shell.WbMain;
import java.io.InputStream;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.workbench.BWbShell;

public class HtmlController {
    private BWbShell shell;
    private BOrd baseOrd;
    private Href2Ord href2Ord;

    public InputStream downloadFile(String string) throws Exception {
        BOrd bOrd = this.href2Ord().hrefToOrd(string);
        return ((BIFile)bOrd.resolve().get()).getInputStream();
    }

    public void hyperlink(String string, String string2, BMouseEvent bMouseEvent) {
        try {
            if (string.startsWith("#")) {
                BOrd bOrd = BOrd.make((String)(this.stripFragment(this.baseOrd) + string));
                if (string2 == null) {
                    this.shell.hyperlink(new HyperlinkInfo(bOrd, (BInputEvent)bMouseEvent));
                } else {
                    WbMain.open((BWbShell)this.shell, (BOrd)bOrd, (String)string2);
                }
            } else {
                BOrd bOrd = this.href2Ord().hrefToOrd(string);
                if (string2 == null) {
                    this.shell.hyperlink(new HyperlinkInfo(bOrd, (BInputEvent)bMouseEvent));
                } else {
                    WbMain.open((BWbShell)this.shell, (BOrd)bOrd, (String)string2);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    private final String stripFragment(BOrd bOrd) {
        int n;
        OrdQuery[] ordQueryArray = bOrd.parse();
        if (!(ordQueryArray[n = ordQueryArray.length - 1] instanceof FilePath)) {
            return bOrd.toString();
        }
        FilePath filePath = (FilePath)ordQueryArray[n];
        String string = filePath.getFragment();
        if (string == null) {
            return bOrd.toString();
        }
        String string2 = bOrd.toString();
        return string2.substring(0, string2.length() - string.length() - 1);
    }

    public BImage downloadImage(String string) {
        BImage bImage = null;
        try {
            BOrd bOrd = this.href2Ord().hrefToOrd(string);
            return BImage.make((BOrd)bOrd).sync();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return bImage;
        }
    }

    private final Href2Ord href2Ord() {
        if (this.href2Ord == null) {
            this.href2Ord = new Href2Ord(this.baseOrd);
        }
        return this.href2Ord;
    }

    public HtmlController(BWbShell bWbShell, BOrd bOrd) {
        this.shell = bWbShell;
        this.baseOrd = bOrd;
    }
}

