/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.html.canvas;

import com.tridium.gx.awt.AwtGraphics;
import com.tridium.html.canvas.BHtmlPane;
import com.tridium.html.canvas.HtmlCanvasContainer;
import com.tridium.html.canvas.HtmlController;
import com.tridium.html.canvas.ParseNodeAnalyzer;
import com.tridium.html.canvas.build.BuildGlyphs;
import com.tridium.html.canvas.glyph.GlyphFragment;
import com.tridium.html.canvas.glyph.GlyphLF;
import com.tridium.html.canvas.glyph.GlyphRoot;
import com.tridium.html.canvas.glyph.GlyphWord;
import com.tridium.html.canvas.glyph.SelectionPoint;
import com.tridium.html.canvas.glyph.SelectionRange;
import com.tridium.html.canvas.glyph.StyleRun;
import com.tridium.html.canvas.glyph.Text;
import com.tridium.html.util.CSSParser;
import com.tridium.html.util.HtmlNode;
import com.tridium.html.util.HtmlParser;
import com.tridium.util.ThrowableUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.baja.file.FileUtil;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.commands.CopyCommand;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.FindPattern;
import javax.baja.ui.text.TextParser;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.xml.XInputStreamReader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BHtmlCanvas
extends BTransferWidget {
    public static final Type TYPE;
    private static final Insets DEFAULT_INSETS;
    private static final Insets NO_INSETS;
    private static Lexicon lex;
    private HtmlController controller;
    private Insets insets;
    private GlyphRoot root;
    private Text text;
    private HtmlParser parser;
    private MouseCursor savedCursor;
    private MouseCursor currentCursor;
    private BMouseEvent lastMouseMoved;
    private SelectionPoint selBegin;
    private SelectionPoint selEnd;
    private boolean selecting;
    private FindPattern pattern;
    private SelectionRange[] locations;
    private int locationIdx;
    static /* synthetic */ Class class$com$tridium$html$canvas$BHtmlCanvas;

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof HtmlCanvasContainer;
    }

    public void setContent(InputStream inputStream) {
        this.parser = new HtmlParser();
        try {
            this.parser.parse((Reader)new XInputStreamReader(inputStream), false);
            this.loadHtml();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.parser = null;
            this.root = this.loadFromTextList(TextUtil.split((String)ThrowableUtil.dumpToString((Throwable)iOException), (char)'\n'));
        }
        if (this.lastMouseMoved != null) {
            this.mouseMoved(this.lastMouseMoved);
        }
    }

    public void setContent(String string) {
        this.parser = new HtmlParser();
        this.parser.parse(string);
        this.loadHtml();
        if (this.lastMouseMoved != null) {
            this.mouseMoved(this.lastMouseMoved);
        }
    }

    public CommandArtifact doFind() {
        this.pattern = FindPattern.query((BWidget)this);
        if (this.pattern == null) {
            return null;
        }
        if (this.pattern.string.length() == 0) {
            return null;
        }
        this.locations = this.text.findLocations(this.pattern);
        this.locationIdx = -1;
        return this.doFindNext();
    }

    public CommandArtifact doFindNext() {
        if (this.pattern == null) {
            return null;
        }
        if (this.pattern.string.length() == 0) {
            return null;
        }
        if (this.locations.length == 0) {
            this.noMore();
        } else if (this.locationIdx == this.locations.length - 1) {
            this.noMore();
        } else {
            ++this.locationIdx;
            this.locateString();
        }
        return null;
    }

    public CommandArtifact doFindPrev() {
        if (this.pattern == null) {
            return null;
        }
        if (this.pattern.string.length() == 0) {
            return null;
        }
        if (this.locations.length == 0) {
            this.noMore();
        } else if (this.locationIdx == 0) {
            this.noMore();
        } else {
            --this.locationIdx;
            this.locateString();
        }
        return null;
    }

    private final void locateString() {
        if (this.locations.length == 0) {
            this.noMore();
        }
        this.selBegin = this.locations[this.locationIdx].begin;
        this.selEnd = this.locations[this.locationIdx].end;
        this.setCopyEnabled(this.isSelectionEmpty() ^ true);
        this.scrollToVisible(this.text.getHighlightRectangle(this.locations[this.locationIdx]));
        this.getShell().showStatus("");
        this.repaint();
    }

    private final void noMore() {
        this.getShell().showStatus(UiLexicon.bajaui.getText("noMore") + ": " + this.pattern.string);
    }

    public void useInsets(boolean bl) {
        this.insets = bl ? DEFAULT_INSETS : NO_INSETS;
    }

    public void selectAll() {
        if (this.root == null || this.text == null) {
            this.selBegin = null;
            this.selEnd = null;
        } else {
            SelectionRange selectionRange = this.text.selectAll();
            this.selBegin = selectionRange.begin;
            this.selEnd = selectionRange.end;
        }
        this.setCopyEnabled(this.isSelectionEmpty() ^ true);
        this.repaint();
    }

    public void keyPressed(BKeyEvent bKeyEvent) {
        if (bKeyEvent.isControlDown() && bKeyEvent.getKeyCode() == 67) {
            try {
                this.doCopy();
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        } else if (!bKeyEvent.isControlDown() && !bKeyEvent.isAltDown()) {
            BComplex bComplex = this.getParent();
            if (!(bComplex instanceof BHtmlPane)) {
                return;
            }
            BHtmlPane bHtmlPane = (BHtmlPane)bComplex;
            RectGeom rectGeom = bHtmlPane.getViewport();
            double d = rectGeom.y;
            BScrollBar bScrollBar = bHtmlPane.getVscrollBar();
            switch (bKeyEvent.getKeyCode()) {
                case 33: {
                    d -= (double)bScrollBar.getBlockIncrement();
                    break;
                }
                case 34: {
                    d += (double)bScrollBar.getBlockIncrement();
                    break;
                }
                case 38: {
                    d -= (double)bScrollBar.getUnitIncrement();
                    break;
                }
                case 40: {
                    d += (double)bScrollBar.getUnitIncrement();
                    break;
                }
                case 36: {
                    d = 0.0;
                    break;
                }
                case 35: {
                    d = bScrollBar.getMax();
                    break;
                }
            }
            bHtmlPane.scrollToVisible(new RectGeom(rectGeom.x, d, rectGeom.width, rectGeom.height));
        }
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
        double d;
        if (this.root == null || this.text == null) {
            return;
        }
        this.lastMouseMoved = bMouseEvent;
        double d2 = bMouseEvent.getX() - (double)this.insets.left;
        SelectionPoint selectionPoint = this.text.get(d2, d = bMouseEvent.getY() - (double)this.insets.top);
        if (selectionPoint == null) {
            this.getShell().showStatus("");
            this.currentCursor = MouseCursor.normal;
            this.setMouseCursor(this.currentCursor);
        } else if (selectionPoint.run.getHref() == null) {
            this.getShell().showStatus("");
            this.currentCursor = MouseCursor.text;
            this.setMouseCursor(this.currentCursor);
        } else {
            StringBuffer stringBuffer = new StringBuffer(selectionPoint.run.getHref());
            if (selectionPoint.run.getTarget() != null) {
                stringBuffer.append(", target:" + selectionPoint.run.getTarget());
            }
            this.getShell().showStatus(stringBuffer.toString());
            this.currentCursor = MouseCursor.hand;
            this.setMouseCursor(this.currentCursor);
        }
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        if (this.root == null || this.text == null) {
            return;
        }
        this.requestFocus();
        if (bMouseEvent.isButton1Down()) {
            if (bMouseEvent.getClickCount() == 1) {
                this.mousePressedSingleClick(bMouseEvent);
            } else if (bMouseEvent.getClickCount() == 2) {
                this.mousePressedDoubleClick(bMouseEvent);
            }
        } else if (bMouseEvent.isButton3Down()) {
            BMenu bMenu = new BMenu();
            CopyCommand copyCommand = new CopyCommand((BTransferWidget)this);
            copyCommand.setEnabled(this.isSelectionEmpty() ^ true);
            bMenu.add(null, (Command)copyCommand);
            bMenu.add(null, (Command)new ViewSource());
            bMenu.open((BWidget)this, bMouseEvent.getX(), bMouseEvent.getY());
        }
    }

    private final void mousePressedSingleClick(BMouseEvent bMouseEvent) {
        double d;
        double d2 = bMouseEvent.getX() - (double)this.insets.left;
        SelectionPoint selectionPoint = this.text.get(d2, d = bMouseEvent.getY() - (double)this.insets.top);
        if (selectionPoint == null) {
            this.startSelecting(this.text.select(d2, d));
        } else if (selectionPoint.run.getHref() == null) {
            this.startSelecting(this.text.select(d2, d));
        }
    }

    private final void startSelecting(SelectionPoint selectionPoint) {
        this.selecting = true;
        this.selBegin = selectionPoint;
        this.selEnd = selectionPoint;
        this.setCopyEnabled(this.isSelectionEmpty() ^ true);
        this.repaint();
    }

    private final void mousePressedDoubleClick(BMouseEvent bMouseEvent) {
        SelectionRange selectionRange;
        this.selBegin = null;
        this.selEnd = null;
        this.setCopyEnabled(false);
        double d = bMouseEvent.getX() - (double)this.insets.left;
        double d2 = bMouseEvent.getY() - (double)this.insets.top;
        SelectionPoint selectionPoint = this.text.select(d, d2);
        if (selectionPoint != null && (selectionRange = this.text.selectWord(selectionPoint)) != null && !selectionRange.isEmpty()) {
            this.selBegin = selectionRange.begin;
            this.selEnd = selectionRange.end;
            this.setCopyEnabled(this.isSelectionEmpty() ^ true);
            this.repaint();
        }
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        if (this.root == null) {
            return;
        }
        if (bMouseEvent.isButton3Down()) {
            return;
        }
        if (this.selecting) {
            this.selEnd = this.text.select(bMouseEvent.getX() - (double)this.insets.left, bMouseEvent.getY() - (double)this.insets.top);
            this.repaint();
        }
    }

    public void mousePulsed(BMouseEvent bMouseEvent) {
        BComplex bComplex;
        if (this.root == null) {
            return;
        }
        if (bMouseEvent.isButton3Down()) {
            return;
        }
        if (this.selecting && (bComplex = this.getParent()) instanceof BHtmlPane) {
            this.ensurePulseVisible((int)bMouseEvent.getX(), (int)bMouseEvent.getY(), (BHtmlPane)bComplex);
            this.selEnd = this.text.select(bMouseEvent.getX() - (double)this.insets.left, bMouseEvent.getY() - (double)this.insets.top);
            this.repaint();
        }
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        if (this.root == null) {
            return;
        }
        if (bMouseEvent.isButton3Down()) {
            return;
        }
        if (this.selecting) {
            this.selecting = false;
            this.selEnd = this.text.select(bMouseEvent.getX() - (double)this.insets.left, bMouseEvent.getY() - (double)this.insets.top);
            this.setCopyEnabled(this.isSelectionEmpty() ^ true);
            this.repaint();
        } else {
            double d;
            double d2 = bMouseEvent.getX() - (double)this.insets.left;
            SelectionPoint selectionPoint = this.text.get(d2, d = bMouseEvent.getY() - (double)this.insets.top);
            if (selectionPoint != null && selectionPoint.run.getHref() != null) {
                this.controller.hyperlink(selectionPoint.run.getHref(), selectionPoint.run.getTarget(), bMouseEvent);
            }
        }
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        if (this.root == null) {
            return;
        }
        this.currentCursor = MouseCursor.normal;
        this.savedCursor = this.setMouseCursor(this.currentCursor);
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        if (this.root == null) {
            return;
        }
        this.setMouseCursor(this.savedCursor);
    }

    private final void ensurePulseVisible(int n, int n2, BHtmlPane bHtmlPane) {
        RectGeom rectGeom = bHtmlPane.getViewport();
        if (!rectGeom.contains((double)n, (double)n2)) {
            BScrollBar bScrollBar = bHtmlPane.getVscrollBar();
            BScrollBar bScrollBar2 = bHtmlPane.getHscrollBar();
            int n3 = (int)rectGeom.x;
            int n4 = n3 + (int)rectGeom.width;
            int n5 = (int)rectGeom.y;
            int n6 = n5 + (int)rectGeom.height;
            if (n < n3) {
                n -= bScrollBar.getUnitIncrement() * 2;
            } else if (n >= n4) {
                n += bScrollBar.getUnitIncrement() * 2;
            }
            if (n2 < n5) {
                n2 -= bScrollBar2.getUnitIncrement();
            } else if (n2 >= n6) {
                n2 += bScrollBar2.getUnitIncrement();
            }
            bHtmlPane.scrollToVisible(new RectGeom((double)n, (double)n2, 0.0, 0.0));
        }
    }

    public void paint(Graphics graphics) {
        if (this.root == null) {
            return;
        }
        try {
            Graphics2D graphics2D = ((AwtGraphics)graphics).getAwtGraphics();
            if (this.root.getBgColor() != null) {
                graphics2D.setColor(this.root.getBgColor());
                graphics2D.fillRect(0, 0, (int)this.getWidth(), (int)this.getHeight());
            }
            BWidget bWidget = (BWidget)this.getParent();
            Point point = bWidget.translateToChild((BWidget)this, new Point(0.0, 0.0));
            graphics2D.translate(this.insets.left, this.insets.top);
            try {
                this.root.paint(graphics2D, (int)point.y, (int)(point.y + this.getUsableHeight(bWidget)));
                this.text.paint(graphics2D, (int)point.y, (int)(point.y + this.getUsableHeight(bWidget)), new SelectionRange(this.selBegin, this.selEnd));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            graphics2D.translate(-this.insets.left, -this.insets.top);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final double getUsableWidth(BWidget bWidget) {
        double d = bWidget.getWidth();
        if (bWidget instanceof HtmlCanvasContainer) {
            HtmlCanvasContainer htmlCanvasContainer = (HtmlCanvasContainer)bWidget;
            d = d - htmlCanvasContainer.getMargin().left - htmlCanvasContainer.getMargin().right;
        }
        return d;
    }

    private final double getUsableHeight(BWidget bWidget) {
        double d = bWidget.getHeight();
        if (bWidget instanceof HtmlCanvasContainer) {
            HtmlCanvasContainer htmlCanvasContainer = (HtmlCanvasContainer)bWidget;
            d = d - htmlCanvasContainer.getMargin().top - htmlCanvasContainer.getMargin().bottom;
        }
        return d;
    }

    public void computePreferredSize() {
        if (this.root == null) {
            return;
        }
        BWidget bWidget = (BWidget)this.getParent();
        double d = this.getUsableWidth(bWidget) - (double)this.insets.left - (double)this.insets.right;
        double d2 = this.getUsableHeight(bWidget) - (double)this.insets.top - (double)this.insets.bottom;
        double d3 = this.root.computeMinimumWidth();
        this.root.setWidth((int)Math.max(d3, d));
        double d4 = this.root.doLayout(0, 0);
        this.text = new Text(this.root.getTextRows(), this.root.getWidth(), (int)d4);
        this.setPreferredSize(d3 += (double)(this.insets.left + this.insets.right), d4 += (double)(this.insets.top + this.insets.bottom));
    }

    public void focusGained(BFocusEvent bFocusEvent) {
        this.repaint();
    }

    private final boolean isSelectionEmpty() {
        if (this.selBegin == null) {
            return true;
        }
        if (this.selEnd == null) {
            return true;
        }
        return this.selBegin.equals(this.selEnd);
    }

    private final GlyphRoot loadFromTextList(String[] stringArray) {
        GlyphRoot glyphRoot = new GlyphRoot();
        Font font = new Font("Courier New", 0, 12);
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            string = TextUtil.trimRight((String)string);
            if ((string = TextUtil.replace((String)string, (String)"\t", (String)"    ")).length() > 0) {
                glyphRoot.add(new GlyphWord(string, font, Color.black, null, null, false));
                glyphRoot.add(new GlyphLF(font));
            }
            ++n;
        }
        return glyphRoot;
    }

    private final Map decodeStyleSheet(String string) throws IOException {
        try {
            InputStream inputStream = this.getHtmlController().downloadFile(string);
            CSSParser cSSParser = new CSSParser();
            return cSSParser.parse(FileUtil.readString((Reader)new InputStreamReader(inputStream)));
        }
        catch (Exception exception) {
            System.out.println("WARNING: style sheet ignored: " + string);
            return new HashMap();
        }
    }

    private final void loadHtml() {
        try {
            Object object;
            ParseNodeAnalyzer parseNodeAnalyzer = new ParseNodeAnalyzer();
            parseNodeAnalyzer.traverse(this.parser.getParseRoot());
            HtmlNode htmlNode = parseNodeAnalyzer.getStartingNode();
            String string = parseNodeAnalyzer.getStyleSheetRef();
            if (string != null) {
                object = this.decodeStyleSheet(string);
                parseNodeAnalyzer.applyStyleSheet((Map)object, htmlNode);
            }
            StyleRun.resetIndexCounter();
            object = new BuildGlyphs(this);
            this.root = ((BuildGlyphs)object).makeGlyphs(htmlNode, false, false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.parser = null;
            this.root = this.loadFromTextList(TextUtil.split((String)ThrowableUtil.dumpToString((Throwable)iOException), (char)'\n'));
        }
        this.relayout();
    }

    private final void scrollToVisible(Rectangle rectangle) {
        BComplex bComplex = this.getParent();
        if (!(bComplex instanceof BHtmlPane)) {
            return;
        }
        ((BHtmlPane)bComplex).scrollToVisible(new RectGeom((double)(rectangle.x + this.insets.left), (double)(rectangle.y + this.insets.top), (double)rectangle.width, (double)rectangle.height));
    }

    public TransferEnvelope getTransferData() throws Exception {
        if (this.root == null || this.text == null) {
            return null;
        }
        if (this.isSelectionEmpty()) {
            return null;
        }
        return TransferEnvelope.make((String)this.text.copy(new SelectionRange(this.selBegin, this.selEnd)));
    }

    public CommandArtifact insertTransferData(TransferContext transferContext) {
        throw new UnsupportedOperationException();
    }

    public CommandArtifact removeTransferData(TransferContext transferContext) {
        throw new UnsupportedOperationException();
    }

    public HtmlController getHtmlController() {
        return this.controller;
    }

    public void setHtmlController(HtmlController htmlController) {
        this.controller = htmlController;
    }

    GlyphFragment findFragment(String string) {
        return this.root.findFragment(string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.insets = DEFAULT_INSETS;
        this.root = null;
        this.text = null;
        this.parser = null;
        this.lastMouseMoved = null;
        this.selBegin = null;
        this.selEnd = null;
        this.selecting = false;
        this.pattern = null;
        this.locations = new SelectionRange[0];
        this.locationIdx = 0;
    }

    public BHtmlCanvas() {
        this.this();
        this.setCopyEnabled(true);
    }

    public BHtmlCanvas(String string) {
        this();
        this.setContent(string);
    }

    public BHtmlCanvas(InputStream inputStream) {
        this();
        this.setContent(inputStream);
    }

    public BHtmlCanvas(String string, HtmlController htmlController) {
        this();
        this.setHtmlController(htmlController);
        this.setContent(string);
    }

    public BHtmlCanvas(InputStream inputStream, HtmlController htmlController) {
        this();
        this.setHtmlController(htmlController);
        this.setContent(inputStream);
    }

    static {
        Class clazz = class$com$tridium$html$canvas$BHtmlCanvas;
        if (clazz == null) {
            clazz = class$com$tridium$html$canvas$BHtmlCanvas = BHtmlCanvas.class("[Lcom.tridium.html.canvas.BHtmlCanvas;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        DEFAULT_INSETS = new Insets(10, 10, 10, 10);
        NO_INSETS = new Insets(1, 1, 1, 1);
        lex = Lexicon.make((String)"html");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ViewSource
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            if (BHtmlCanvas.this.parser == null) {
                return null;
            }
            BTextEditor bTextEditor = new BTextEditor();
            bTextEditor.setEditable(false);
            bTextEditor.setParser((TextParser)new javax.baja.ui.text.parsers.HtmlParser());
            bTextEditor.setText(BHtmlCanvas.this.parser.getSource());
            BTextEditorPane bTextEditorPane = new BTextEditorPane(bTextEditor, 40, 100);
            BDialog.open((BWidget)this.getOwner(), (String)this.getLabel(), (Object)bTextEditorPane, (int)1);
            return null;
        }

        public ViewSource() {
            super((BWidget)BHtmlCanvas.this, lex, "commands.viewSource");
            boolean bl = false;
            if (BHtmlCanvas.this.parser != null) {
                bl = true;
            }
            this.setEnabled(bl);
        }
    }
}

